﻿
Module Tomy_Identifier
    Friend IdentiFinder As Class_Identify
End Module


Public Class Class_Identify

    '**********************************
    '*  Isotope identification Class  *
    '*                                *
    '*         Tomy 9A5TOM            *
    '*    crnazvijezda@gmail.com      *
    '* Youtube channel - crnazvijezda *
    '**********************************

    ' ===================================================================================================
    '   PUBLIC FUNCTIONS
    ' ===================================================================================================
    Friend Sub New()
        LoadIdentSettings()
        LoadIsotopesAndXRF()
        LoadComboBox(Form_Tomy.ComboBox_IsotopeList, "g")
    End Sub

    Private mEnabled As Boolean
    Friend Sub Enable()
        mEnabled = True
    End Sub
    Friend Sub Disable()
        mEnabled = False
        ResetPOI()
        '        Form_Tomy.Visible = False
    End Sub
    Friend Function Enabled() As Boolean
        Return mEnabled
    End Function

    Friend Sub IdentifyElements()
        If Not mEnabled Then Exit Sub
        Form_Tomy.TextBox_TomyIsotopeIdentifier.Text = ElementIdentify(Spectrometer.SelectedEnergy)
    End Sub

    Friend Sub MarkIsotopes(ByVal gfx As Graphics)
        If InStateChanging = False Then
            'On Error Resume Next
            If Form_Tomy.ComboBox_IsotopeList.Items.Count = 0 Then Return
            If Form_Tomy.ComboBox_IsotopeList.SelectedIndex < 0 Then Form_Tomy.ComboBox_IsotopeList.SelectedIndex = 0
            Dim LocalDecSep As String = Globalization.CultureInfo.CurrentCulture.NumberFormat.CurrencyDecimalSeparator.ToString
            GSorXRF()
            If strGSorXRF = "g" Then 'for isotopes
                Dim strEnerg As String = IsotopeEnergies(Form_Tomy.ComboBox_IsotopeList.Items(Form_Tomy.ComboBox_IsotopeList.SelectedIndex).ToString)
                Dim strSplitedEnerg As String() = strEnerg.Split(New Char() {"\"c})
                Dim strOneEnerg As String
                For Each strOneEnerg In strSplitedEnerg
                    MarkIsotope(gfx, "", CSng(strOneEnerg))
                Next
            Else 'for XRF
                Dim strEnerg As String = XRFEnergies(Form_Tomy.ComboBox_IsotopeList.Items(Form_Tomy.ComboBox_IsotopeList.SelectedIndex).ToString)
                Dim strSplitedEnerg As String() = strEnerg.Split(New Char() {"\"c})
                Dim strOneEnerg As String
                Dim strOneEnergForSplit As String
                Dim strXRFPart() As String
                For Each strOneEnerg In strSplitedEnerg
                    strOneEnergForSplit = strOneEnerg
                    strXRFPart = strOneEnergForSplit.Split(CChar("?"))
                    MarkIsotope(gfx, strXRFPart(0), CSng(strXRFPart(1)))
                Next
            End If
            'marking POI
            If bolSemiAutoIdent = True Then
                If sngPOI.Length > 0 Then
                    For icnt As Int32 = LBound(sngPOI) To UBound(sngPOI)
                        MarkPOI(gfx, "", (sngPOI(icnt) / 1000))
                    Next
                End If
            End If
        End If
    End Sub

    Friend Sub AddPOI(ByVal EnergyPoint As Single)
        Dim sngTolerance As Single = CSng(Form_Tomy.txt_EnergyTolerance.NumericValue)
        Dim POIExist As Boolean = False
        For iCnt As Int32 = LBound(sngPOI) To UBound(sngPOI)
            If (Spectrometer.SelectedEnergy * 1000) > (sngPOI(iCnt) - sngTolerance) And (Spectrometer.SelectedEnergy * 1000) < (sngPOI(iCnt) + sngTolerance) Then
                POIExist = True
            End If
        Next

        If POIExist = True Then
            If MessageBox.Show("Current POI is in range of another selected POI. Do you want to add selected POI anyway?", "POI Exist", MessageBoxButtons.YesNo, MessageBoxIcon.Question) = DialogResult.Yes Then POIExist = False
        End If

        If POIExist = False Then
            Array.Resize(sngPOI, sngPOI.Length + 1)
            sngPOI(UBound(sngPOI)) = Spectrometer.SelectedEnergy * 1000 'in eV
        End If
    End Sub

    Friend Sub ResetPOI()
        If sngPOI.Length > 0 Then
            Array.Clear(sngPOI, LBound(sngPOI), UBound(sngPOI))
            Array.Resize(sngPOI, 0)
        End If
    End Sub

    Friend Sub ShowAutoIdentResults(ByVal strResGsorXRF As String)
        If sngPOI.Length > 0 Then

            strLastReportTime = Now.ToString

            Dim ReportText As String = ""
            Dim ReportTime As String = "Report time:" & vbCrLf & strLastReportTime & vbCrLf
            Dim ReportText_POI As String = ""
            Dim ReportText_Tol As String = ""
            Dim ReportText_ELsuitPOI As String = ""
            Dim ReportText_POI_El_PE As String = ""
            Dim RepEl(0) As String
            Dim RepPOI(0) As Int32
            Dim RepNumberOfDefPeaks(0) As Int32
            Dim ElExist As Boolean
            Dim AppendCounter As Int32 = 0
            Dim iStat1, iStat2, iStat3 As Int32

            If strResGsorXRF = "GS" Then
                SAI_Results("GS")
                ReportText = "Report for Gamma Spectrometry" & vbCrLf

            ElseIf strResGsorXRF = "XRF" Then
                SAI_Results("XRF")
                ReportText = "Report for XRF" & vbCrLf

            End If
            ReportText_Tol = "Energy tolerance:" & vbCrLf & Form_Tomy.txt_EnergyTolerance.Text & " eV" & vbCrLf
            ReportText_POI = "Energy point of interest:" & vbCrLf
            For icnt As Int32 = LBound(sngPOI) To UBound(sngPOI)
                ReportText_POI = ReportText_POI & sngPOI(icnt).ToString & " eV" & vbCrLf
            Next
            If arrSAIResults_Element.Length > 0 Then

                Form_Tomy.ToolStripButton_SaveReport.Visible = True

                ReportText_POI_El_PE = "POI -> Element -> Peak energy" & vbCrLf
                For icnt2 As Int32 = LBound(arrSAIResults_POI) To UBound(arrSAIResults_POI)
                    ReportText_POI_El_PE = ReportText_POI_El_PE & arrSAIResults_POI(icnt2).ToString & _
                                " eV -> " & arrSAIResults_Element(icnt2) & " -> " & arrSAIResults_ElementEnergy(icnt2).ToString & " eV" & vbCrLf
                Next

                Array.Resize(RepEl, arrSAIResults_Element.Length)
                Array.Resize(RepPOI, arrSAIResults_Element.Length)
                Array.Resize(RepNumberOfDefPeaks, arrSAIResults_Element.Length)

                For iStat1 = LBound(arrSAIResults_Element) To UBound(arrSAIResults_Element)
                    If arrSAIResults_Element(iStat1) <> Nothing Then
                        If InStr(arrSAIResults_Element(iStat1), "*") = 0 Then 'if element is not marked for trash
                            ElExist = False
                            For iStat2 = LBound(RepEl) To UBound(RepEl)
                                If RepEl(iStat2) = arrSAIResults_Element(iStat1) Then
                                    For iStat3 = LBound(RepEl) To UBound(RepEl)
                                        If RepEl(iStat3) = arrSAIResults_Element(iStat1) Then RepPOI(iStat3) = RepPOI(iStat3) + 1
                                    Next
                                    arrSAIResults_Element(iStat1) = "*" & arrSAIResults_Element(iStat1)
                                    ElExist = True
                                End If
                            Next
                            If ElExist = False Then
                                If IsNumeric(RepPOI(AppendCounter)) = False Then
                                    RepPOI(AppendCounter) = 1
                                Else
                                    RepPOI(AppendCounter) = RepPOI(AppendCounter) + 1
                                End If
                                RepEl(AppendCounter) = arrSAIResults_Element(iStat1)
                                RepNumberOfDefPeaks(AppendCounter) = 0
                                AppendCounter = AppendCounter + 1
                            End If
                        End If
                    End If
                Next

                If strResGsorXRF = "GS" Then
                    ReportText_ELsuitPOI = "Isotopes suit to POI:" & vbCrLf
                    For iStat1 = LBound(RepEl) To UBound(RepEl)
                        If RepEl(iStat1) <> Nothing Then
                            For iStat2 = LBound(iIsotopeName) To UBound(iIsotopeName)
                                If RepEl(iStat1) = iIsotopeName(iStat2) Then
                                    RepNumberOfDefPeaks(iStat1) = RepNumberOfDefPeaks(iStat1) + 1
                                End If

                            Next
                        End If
                    Next
                ElseIf strResGsorXRF = "XRF" Then
                    ReportText_ELsuitPOI = "Elements suit to POI:" & vbCrLf
                    For iStat1 = LBound(RepEl) To UBound(RepEl)
                        If RepEl(iStat1) <> Nothing Then
                            For iStat2 = LBound(iXRFName) To UBound(iXRFName)
                                If RepEl(iStat1) = iXRFName(iStat2) Then
                                    RepNumberOfDefPeaks(iStat1) = RepNumberOfDefPeaks(iStat1) + 1
                                End If
                            Next
                        End If
                    Next
                End If

                For iStat1 = LBound(RepEl) To UBound(RepEl)
                    If RepEl(iStat1) <> Nothing Then
                        ReportText_ELsuitPOI = ReportText_ELsuitPOI & RepEl(iStat1) & " in " & RepPOI(iStat1).ToString & " POI of " & RepNumberOfDefPeaks(iStat1).ToString & " peak for this element" & vbCrLf
                    End If
                Next

                'full report
                ReportText = ReportText & vbCrLf & ReportTime & vbCrLf & ReportText_POI & vbCrLf & ReportText_Tol & vbCrLf & ReportText_ELsuitPOI & vbCrLf & ReportText_POI_El_PE 'fali glavni report
                Form_Tomy.TextBox_TomyReport.Text = ReportText

            Else
                MessageBox.Show("There is no elements suit to POI. Try to change tolerance value to bigger or select another POI.", "No elements suit to POI", MessageBoxButtons.OK, MessageBoxIcon.Exclamation)
            End If
        Else
            MessageBox.Show("Select Energy POI then ask for report!", "Report", MessageBoxButtons.OK, MessageBoxIcon.Exclamation)
        End If

    End Sub

    Friend Function GetSetTolerance(ByVal GSorXRF As String, ByVal SuitOrCloseTo As String, ByVal GorS As String) As Single
        Dim TolInEv As Single
        If GorS = "G" Then
            If GSorXRF = "XRF" Then
                If SuitOrCloseTo = "Suit" Then
                    TolInEv = XRFSuitTolerance
                ElseIf SuitOrCloseTo = "CloseTo" Then
                    TolInEv = XRFCloseToTolerance
                End If
            ElseIf GSorXRF = "GS" Then
                If SuitOrCloseTo = "Suit" Then
                    TolInEv = IsotopeSuitTolerance
                ElseIf SuitOrCloseTo = "CloseTo" Then
                    TolInEv = IsotopeCloseToTolerance
                End If
            End If
        ElseIf GorS = "S" Then
            If GSorXRF = "XRF" Then
                If SuitOrCloseTo = "Suit" Then
                    XRFSuitTolerance = CSng(Form_Tomy.MyTextBox_Suit.NumericValue)
                ElseIf SuitOrCloseTo = "CloseTo" Then
                    XRFCloseToTolerance = CSng(Form_Tomy.MyTextBox_CloseTo.NumericValue)
                End If
            ElseIf GSorXRF = "GS" Then
                If SuitOrCloseTo = "Suit" Then
                    IsotopeSuitTolerance = CSng(Form_Tomy.MyTextBox_Suit.NumericValue)
                ElseIf SuitOrCloseTo = "CloseTo" Then
                    IsotopeCloseToTolerance = CSng(Form_Tomy.MyTextBox_CloseTo.NumericValue)
                End If
            End If
            TolInEv = 0
            'save settings to file
            SaveIdentSettings()
        End If

        Return TolInEv

    End Function


    Friend Sub SAIonoff(ByVal OnOff As Boolean)
        bolSemiAutoIdent = OnOff
    End Sub

    Friend Sub SaveReport(ByVal TextToSave As String)
        Dim strXG As String = If(Form_Tomy.CheckBox_XRF.Checked, "XRF", "GS")
        Dim ReportFileName As String = ValidFilename(strXG & " report " & strLastReportTime & ".txt")
        Dim IdentReportPath As String = Application.StartupPath & "\IdentReport\"
        Dim ReportSaveWriter As IO.StreamWriter = New IO.StreamWriter(IdentReportPath & ReportFileName)
        ReportSaveWriter.Write(TextToSave)
        ReportSaveWriter.Close()
        MessageBox.Show("Report is saved in file: " & ReportFileName, _
                        "Report", MessageBoxButtons.OK, MessageBoxIcon.Information)
    End Sub

    Friend Function GetSetShells(ByVal AtomicShell As String, ByVal GorS As String, ByVal NewValue As Boolean) As Boolean
        Dim ResultForReturn As Boolean = True
        Dim WriteValue As Byte = 0
        If NewValue = True Then WriteValue = 1

        If GorS = "G" Then
            Select Case AtomicShell
                Case "Kalpha1"
                    ResultForReturn = CBool(Kalpha1)
                Case "Kalpha2"
                    ResultForReturn = CBool(Kalpha2)
                Case "Kbeta1"
                    ResultForReturn = CBool(Kbeta1)
                Case "Lalpha1"
                    ResultForReturn = CBool(Lalpha1)
                Case "Lalpha2"
                    ResultForReturn = CBool(Lalpha2)
                Case "Lbeta1"
                    ResultForReturn = CBool(Lbeta1)
                Case "Lbeta2"
                    ResultForReturn = CBool(Lbeta2)
                Case "Lgamma1"
                    ResultForReturn = CBool(Lgamma1)
                Case "Malpha1"
                    ResultForReturn = CBool(Malpha1)
            End Select
        ElseIf GorS = "S" Then
            Select Case AtomicShell
                Case "Kalpha1"
                    Kalpha1 = WriteValue
                Case "Kalpha2"
                    Kalpha2 = WriteValue
                Case "Kbeta1"
                    Kbeta1 = WriteValue
                Case "Lalpha1"
                    Lalpha1 = WriteValue
                Case "Lalpha2"
                    Lalpha2 = WriteValue
                Case "Lbeta1"
                    Lbeta1 = WriteValue
                Case "Lbeta2"
                    Lbeta2 = WriteValue
                Case "Lgamma1"
                    Lgamma1 = WriteValue
                Case "Malpha1"
                    Malpha1 = WriteValue
            End Select
            InStateChanging = True
            SaveIdentSettings()
            Form_Tomy.ComboBox_IsotopeList.Items.Clear()
            LoadIdentSettings()
            LoadIsotopesAndXRF()
            LoadComboBox(Form_Tomy.ComboBox_IsotopeList, "x")
            InStateChanging = False
        End If

        Return ResultForReturn

    End Function

    ' ===================================================================================================
    '   PRIVATE FUNCTIONS
    ' ===================================================================================================

    Private Sub MarkIsotope(ByVal gfx As Graphics, ByVal name As String, ByVal e As Single)
        Dim f As Font = New Font(Spectrometer.Marker_Font, Spectrometer.Marker_Fontsize)
        Dim x As Single = Spectrometer.EnergyToX(e) - 1
        gfx.DrawLine(New Pen(Spectrometer.Identifier_Color, Spectrometer.Identifier_Width), x, 20, x, Form_Main.PBox_Spectrum.Height)
        gfx.DrawString(name, f, New SolidBrush(Spectrometer.Number_Color), x, 2)
    End Sub



    Friend iIsotopeEnergy(1) As Single
    Friend iIsotopeName(1) As String
    Private iIsotopeList(1) As String

    Private InStateChanging As Boolean = False


    Private Function IsotopeEnergies(ByVal IsotopeName As String) As String
        Dim strReturnValue As String = ""
        Dim iCounter As Int32
        For iCounter = LBound(iIsotopeName) To UBound(iIsotopeName)
            If iIsotopeName(iCounter) = IsotopeName Then
                strReturnValue = strReturnValue & iIsotopeEnergy(iCounter).ToString & "\"
            End If
        Next
        Return strReturnValue.Substring(0, strReturnValue.Length - 1)
    End Function

    Private iXRFName(1) As String '3. row in XRFTable.txt
    Private iXRFShell(1) As String '4. row in XRFTable.txt
    Private iXRFDefEnergy(1) As Single '5. row in XRFTable.txt
    Private iXRFEnergy(1) As Single '6. row in XRFTable.txt
    Private iXRFVisible(1) As String '1. row in XRFTable.txt
    Private iXRFUserDefined(1) As String '2. row in XRFTable.txt
    Private iXRFList(1) As String
    Private strGSorXRF As String
    Private strGSorXRFoldval As String
    ' ---------------------------------------------------------------- settings variables
    Private IsotopeSuitTolerance As Single = 10
    Private IsotopeCloseToTolerance As Single = 20
    Private XRFSuitTolerance As Single = 10
    Private XRFCloseToTolerance As Single = 20
    Private Kalpha1 As Byte = 1
    Private Kalpha2 As Byte = 1
    Private Kbeta1 As Byte = 1
    Private Lalpha1 As Byte = 1
    Private Lalpha2 As Byte = 1
    Private Lbeta1 As Byte = 1
    Private Lbeta2 As Byte = 1
    Private Lgamma1 As Byte = 1
    Private Malpha1 As Byte = 1
    ' ---------------------------------------------------------------- semi auto ident var
    Private bolSemiAutoIdent As Boolean = False
    Private arrSAIResults_POI(0) As Single
    Private arrSAIResults_Element(0) As String
    Private arrSAIResults_ElementEnergy(0) As Single
    Private strLastReportTime As String

    Private Sub LoadIdentSettings()
        'loading settings
        Dim LocalDecSep As String = Globalization.CultureInfo.CurrentCulture.NumberFormat.CurrencyDecimalSeparator.ToString
        Dim IdentSettingsFilePath As String = Application.StartupPath & "\Extra\IdentSettings.txt"
        Dim inFile As IO.StreamReader = IO.File.OpenText(IdentSettingsFilePath)
        Dim strFmt As String = "{0,1}{2,3}{4,5}"
        Dim temp As Int32 = 3
        Dim strItems() As String
        'load settings from file IdentSettings.txt
        Do While inFile.Peek <> -1
            strItems = Split(inFile.ReadLine, ",")
            Select Case strItems(0)
                Case "IsotopeSuitTolerance"
                    IsotopeSuitTolerance = CSng(Replace(strItems(1).ToString, ".", LocalDecSep))
                Case "IsotopeCloseToTolerance"
                    IsotopeCloseToTolerance = CSng(Replace(strItems(1).ToString, ".", LocalDecSep))
                Case "XRFSuitTolerance"
                    XRFSuitTolerance = CSng(Replace(strItems(1).ToString, ".", LocalDecSep))
                Case "XRFCloseToTolerance"
                    XRFCloseToTolerance = CSng(Replace(strItems(1).ToString, ".", LocalDecSep))
                Case "Kalpha1"
                    Kalpha1 = CByte(strItems(1).ToString)
                Case "Kalpha2"
                    Kalpha2 = CByte(strItems(1).ToString)
                Case "Kbeta1"
                    Kbeta1 = CByte(strItems(1).ToString)
                Case "Lalpha1"
                    Lalpha1 = CByte(strItems(1).ToString)
                Case "Lalpha2"
                    Lalpha2 = CByte(strItems(1).ToString)
                Case "Lbeta1"
                    Lbeta1 = CByte(strItems(1).ToString)
                Case "Lbeta2"
                    Lbeta2 = CByte(strItems(1).ToString)
                Case "Lgamma1"
                    Lgamma1 = CByte(strItems(1).ToString)
                Case "Malpha1"
                    Malpha1 = CByte(strItems(1).ToString)
                Case Else
            End Select
        Loop
        inFile.Close()
    End Sub

    Private Sub SaveIdentSettings()
        'save settings

        Dim IdentSettingsFilePath As String = Application.StartupPath & "\Extra\IdentSettings.txt"
        Dim FileText As String

        Dim outFile As IO.StreamWriter = New IO.StreamWriter(IdentSettingsFilePath)
        FileText = "IsotopeSuitTolerance," & IsotopeSuitTolerance.ToString & vbCrLf & _
            "IsotopeCloseToTolerance," & IsotopeCloseToTolerance.ToString & vbCrLf & _
            "XRFSuitTolerance," & XRFSuitTolerance.ToString & vbCrLf & _
            "XRFCloseToTolerance," & XRFCloseToTolerance.ToString & vbCrLf & _
            "Kalpha1," & Kalpha1.ToString & vbCrLf & _
            "Kalpha2," & Kalpha2.ToString & vbCrLf & _
            "Kbeta1," & Kbeta1.ToString & vbCrLf & _
            "Lalpha1," & Lalpha1.ToString & vbCrLf & _
            "Lalpha2," & Lalpha2.ToString & vbCrLf & _
            "Lbeta1," & Lbeta1.ToString & vbCrLf & _
            "Lbeta2," & Lbeta2.ToString & vbCrLf & _
            "Lgamma1," & Lgamma1.ToString & vbCrLf & _
            "Malpha1," & Malpha1.ToString
        outFile.Write(FileText)
        outFile.Close()

    End Sub

    Private Function XRFEnergies(ByVal XRFName As String) As String
        Dim strReturnValue As String = ""
        Dim iCounter As Int32
        For iCounter = LBound(iXRFName) To UBound(iXRFName)
            If iXRFName(iCounter) = XRFName And iXRFVisible(iCounter) = "1" Then
                strReturnValue = strReturnValue & iXRFShell(iCounter) & "?" & (iXRFEnergy(iCounter) / 1000).ToString & "\"
            End If
        Next
        strReturnValue = strReturnValue.Substring(0, strReturnValue.Length - 1)
        Return strReturnValue
    End Function


    Private Sub GSorXRF()
        If Form_Tomy.CheckBox_XRF.Checked = True Then
            strGSorXRF = "x"
        Else
            strGSorXRF = "g"
        End If
        If strGSorXRFoldval <> strGSorXRF Then
            IdentiFinder.LoadComboBox(Form_Tomy.ComboBox_IsotopeList, strGSorXRF)
            If strGSorXRFoldval Is Nothing And strGSorXRF = "g" Then
                Form_Tomy.ComboBox_IsotopeList.SelectedIndex = 16
            Else
                Form_Tomy.ComboBox_IsotopeList.SelectedIndex = 0
            End If
            strGSorXRFoldval = strGSorXRF
        End If
    End Sub


    Private Sub LoadIsotopesAndXRF()

        If InStateChanging = True Then
            Array.Resize(iIsotopeEnergy, 1)
            Array.Resize(iIsotopeName, 1)
            Array.Resize(iIsotopeList, 1)
            Array.Resize(iXRFName, 1)
            Array.Resize(iXRFShell, 1)
            Array.Resize(iXRFDefEnergy, 1)
            Array.Resize(iXRFEnergy, 1)
            Array.Resize(iXRFVisible, 1)
            Array.Resize(iXRFUserDefined, 1)
            Array.Resize(iXRFList, 1)
        End If

        Dim LocalDecSep As String = Globalization.CultureInfo.CurrentCulture.NumberFormat.CurrencyDecimalSeparator.ToString

        Dim IsotopeEnergyFilePath As String = Application.StartupPath & "\Extra\Isotopes_Energy.txt"
        Dim inFile As IO.StreamReader = IO.File.OpenText(IsotopeEnergyFilePath)
        Dim inFileSize As IO.StreamReader = IO.File.OpenText(IsotopeEnergyFilePath)
        Dim strFmt As String = "{0,1}{2,3}{4,5}"

        Dim XRFFilePath As String = Application.StartupPath & "\Extra\XRFTable.txt"
        Dim inXRFFile As IO.StreamReader = IO.File.OpenText(XRFFilePath)
        'Dim inXRFFileSize As IO.StreamReader = IO.File.OpenText(XRFFilePath)
        Dim strXRFFmt As String = "{0,1,3,4,5,6}{7,8,9,10,11,12}{13,14,15,16,17,18}"

        Dim temp As Int32 = 3
        Dim FileLineNumber As Int32 = 0
        Dim strItems() As String

        Dim bolVisible As Boolean
        Dim bolInitArr As Boolean = False

        Dim iXRFlistNumber As Int32 = 1
        Dim iGSlistNumber As Int32 = 1
        Dim bolXRFlist As Boolean = False
        Dim bolGSlist As Boolean = False
        Dim bolGSlistInit As Boolean = False
        Dim bolXRFlistInit As Boolean = False

        Dim iCounter As Int32
        ' ------------------------------------------- load list of isotopes
        Do While inFile.Peek <> -1
            FileLineNumber = iIsotopeName.Length
            strItems = Split(inFile.ReadLine, ",")
            bolGSlist = False
            For iCounter = LBound(iIsotopeList) To UBound(iIsotopeList)
                If strItems(1) = iIsotopeList(iCounter) Then bolGSlist = True
            Next
            If bolGSlist = False Then
                If iGSlistNumber = 1 And bolGSlistInit = False Then
                    iIsotopeList(iGSlistNumber - 1) = strItems(1)
                    bolGSlistInit = True
                Else
                    iGSlistNumber = iGSlistNumber + 1
                    Array.Resize(iIsotopeList, iGSlistNumber)
                    iIsotopeList(iGSlistNumber - 1) = strItems(1)
                End If
            End If

            If FileLineNumber = 1 And bolInitArr = False Then
                iIsotopeEnergy(FileLineNumber - 1) = CSng(Replace(strItems(0).ToString, ".", LocalDecSep))
                iIsotopeName(FileLineNumber - 1) = strItems(1).ToString
                bolInitArr = True
            Else
                FileLineNumber = FileLineNumber + 1
                Array.Resize(iIsotopeEnergy, FileLineNumber)
                Array.Resize(iIsotopeName, FileLineNumber)
                iIsotopeEnergy(FileLineNumber - 1) = CSng(Replace(strItems(0).ToString, ".", LocalDecSep))
                iIsotopeName(FileLineNumber - 1) = strItems(1).ToString
            End If
        Loop

        bolInitArr = False

        ' ------------------------------------------- load XRF elements
        Do While inXRFFile.Peek <> -1
            FileLineNumber = iXRFName.Length
            strItems = Split(inXRFFile.ReadLine, ",")
            'ovdje ako item mora biti vidljiv onda dalje inače preskoči
            bolXRFlist = False
            'For iCounter = LBound(iXRFList) To UBound(iXRFList)
            '    If strItems(2) = iXRFList(iCounter) Then bolXRFlist = True
            'Next
            'If bolXRFlist = False Then
            '    If iXRFlistNumber = 1 And bolXRFlistInit = False Then
            '        iXRFList(iXRFlistNumber - 1) = strItems(2)
            '        bolXRFlistInit = True
            '    Else
            '        iXRFlistNumber = iXRFlistNumber + 1
            '        Array.Resize(iXRFList, iXRFlistNumber)
            '        iXRFList(iXRFlistNumber - 1) = strItems(2)
            '    End If
            'End If

            bolVisible = False
            Select Case strItems(3)
                Case "Ka1"
                    If Kalpha1 = 1 Then bolVisible = True
                Case "Ka2"
                    If Kalpha2 = 1 Then bolVisible = True
                Case "Kb1"
                    If Kbeta1 = 1 Then bolVisible = True
                Case "La1"
                    If Lalpha1 = 1 Then bolVisible = True
                Case "La2"
                    If Lalpha2 = 1 Then bolVisible = True
                Case "Lb1"
                    If Lbeta1 = 1 Then bolVisible = True
                Case "Lb2"
                    If Lbeta2 = 1 Then bolVisible = True
                Case "Lg1"
                    If Lgamma1 = 1 Then bolVisible = True
                Case "Ma1"
                    If Malpha1 = 1 Then bolVisible = True
                Case Else
            End Select

            If bolVisible = True Then
                'gornji dio prebačen ovdje- početak
                For iCounter = LBound(iXRFList) To UBound(iXRFList)
                    If strItems(2) = iXRFList(iCounter) Then bolXRFlist = True
                Next
                If bolXRFlist = False Then
                    If iXRFlistNumber = 1 And bolXRFlistInit = False Then
                        iXRFList(iXRFlistNumber - 1) = strItems(2)
                        bolXRFlistInit = True
                    Else
                        iXRFlistNumber = iXRFlistNumber + 1
                        Array.Resize(iXRFList, iXRFlistNumber)
                        iXRFList(iXRFlistNumber - 1) = strItems(2)
                    End If
                End If
                'gornji dio prebačen ovdje- kraj
                If FileLineNumber = 1 And bolInitArr = False Then
                    iXRFVisible(FileLineNumber - 1) = strItems(0).ToString
                    iXRFUserDefined(FileLineNumber - 1) = strItems(1).ToString
                    iXRFName(FileLineNumber - 1) = strItems(2)
                    iXRFShell(FileLineNumber - 1) = strItems(3)
                    iXRFDefEnergy(FileLineNumber - 1) = (CSng(Replace(strItems(4).ToString, ".", LocalDecSep)))
                    iXRFEnergy(FileLineNumber - 1) = (CSng(Replace(strItems(5).ToString, ".", LocalDecSep)))
                    bolInitArr = True
                Else
                    FileLineNumber = FileLineNumber + 1
                    Array.Resize(iXRFName, FileLineNumber)
                    Array.Resize(iXRFShell, FileLineNumber)
                    Array.Resize(iXRFDefEnergy, FileLineNumber)
                    Array.Resize(iXRFEnergy, FileLineNumber)
                    Array.Resize(iXRFVisible, FileLineNumber)
                    Array.Resize(iXRFUserDefined, FileLineNumber)
                    iXRFVisible(FileLineNumber - 1) = strItems(0).ToString
                    iXRFUserDefined(FileLineNumber - 1) = strItems(1).ToString
                    iXRFName(FileLineNumber - 1) = strItems(2)
                    iXRFShell(FileLineNumber - 1) = strItems(3)
                    iXRFDefEnergy(FileLineNumber - 1) = (CSng(Replace(strItems(4).ToString, ".", LocalDecSep)))
                    iXRFEnergy(FileLineNumber - 1) = (CSng(Replace(strItems(5).ToString, ".", LocalDecSep)))
                End If
            End If
        Loop
    End Sub

    Private Sub LoadComboBox(ByRef cbbx As ComboBox, ByVal ix As String)
        cbbx.Items.Clear()
        'isotope list
        If ix = "g" Then
            For i As Int32 = LBound(iIsotopeList) To UBound(iIsotopeList)
                If iIsotopeList(i) <> Nothing Then
                    cbbx.Items.Add(iIsotopeList(i))
                End If
            Next
        End If
        'XRF list
        If ix = "x" Then
            For i As Int32 = LBound(iXRFList) To UBound(iXRFList)
                If iXRFList(i) <> Nothing Then
                    cbbx.Items.Add(iXRFList(i))
                End If
            Next
        End If
    End Sub

    Private Function ElementIdentify(ByVal iEnergyPeakValue As Single) As String
        Dim strReturnValue As String = ""
        Dim iCounter As Int32
        Dim EnergyPeakValueInEV As Single = (iEnergyPeakValue * 1000)

        If strGSorXRF = "g" Then
            strReturnValue = strReturnValue & "Isotope suits to selected energy:" & vbCrLf
            For iCounter = LBound(iIsotopeEnergy) To UBound(iIsotopeEnergy)
                If Math.Abs(iIsotopeEnergy(iCounter) * 1000 - EnergyPeakValueInEV) < IsotopeSuitTolerance And Math.Abs(iIsotopeEnergy(iCounter) * 1000 - EnergyPeakValueInEV) > 0 Then
                    If iIsotopeEnergy(iCounter).ToString <> "0" Then
                        strReturnValue = strReturnValue & iIsotopeName(iCounter) & " (" & iIsotopeEnergy(iCounter).ToString & ")" & vbCrLf
                    End If
                End If
            Next
            strReturnValue = strReturnValue & vbCrLf & "Isotope close to selected energy:" & vbCrLf
            For iCounter = LBound(iIsotopeEnergy) To UBound(iIsotopeEnergy)
                If Math.Abs(iIsotopeEnergy(iCounter) * 1000 - EnergyPeakValueInEV) >= IsotopeSuitTolerance And Math.Abs(iIsotopeEnergy(iCounter) * 1000 - EnergyPeakValueInEV) < IsotopeCloseToTolerance And Math.Abs(iIsotopeEnergy(iCounter) * 1000 - EnergyPeakValueInEV) > 0 Then
                    If iIsotopeEnergy(iCounter).ToString <> "0" Then
                        strReturnValue = strReturnValue & iIsotopeName(iCounter) & " (" & iIsotopeEnergy(iCounter).ToString & ")" & vbCrLf
                    End If
                End If
            Next
        ElseIf strGSorXRF = "x" Then
            strReturnValue = strReturnValue & "Element suits to selected energy:" & vbCrLf
            For iCounter = LBound(iXRFEnergy) To UBound(iXRFEnergy)
                If Math.Abs(iXRFEnergy(iCounter) - EnergyPeakValueInEV) < XRFSuitTolerance And Math.Abs(iXRFEnergy(iCounter) - EnergyPeakValueInEV) > 0 Then
                    If iXRFEnergy(iCounter).ToString <> "0" Then
                        strReturnValue = strReturnValue & iXRFName(iCounter) & " (" & iXRFShell(iCounter) & "/" & iXRFEnergy(iCounter).ToString & ")" & vbCrLf
                    End If
                End If
            Next
            strReturnValue = strReturnValue & vbCrLf & "Element close to selected energy:" & vbCrLf
            For iCounter = LBound(iXRFEnergy) To UBound(iXRFEnergy)
                If Math.Abs(iXRFEnergy(iCounter) - EnergyPeakValueInEV) >= XRFSuitTolerance And Math.Abs(iXRFEnergy(iCounter) - EnergyPeakValueInEV) < XRFCloseToTolerance And Math.Abs(iXRFEnergy(iCounter) - EnergyPeakValueInEV) > 0 Then
                    If iXRFEnergy(iCounter).ToString <> "0" Then
                        strReturnValue = strReturnValue & iXRFName(iCounter) & " (" & iXRFShell(iCounter) & "/" & iXRFEnergy(iCounter).ToString & ")" & vbCrLf
                    End If
                End If
            Next
        End If
        Return strReturnValue
    End Function


    Private Sub MarkPOI(ByVal gfx As Graphics, ByVal name As String, ByVal e As Single)
        Dim f As Font = New Font("Arial", 8)
        Dim x As Single = Spectrometer.EnergyToX(e) - 1
        gfx.DrawLine(New Pen(Color.DarkViolet, 1), x, 2, x, Form_Main.PBox_Spectrum.Height)
        gfx.DrawString(name, f, Brushes.Black, x, 2)
    End Sub

    Private sngPOI(0) As Single



    Private Sub SAI_Results(ByVal GorX As String)
        Dim sngTol As Single
        sngTol = CSng(Form_Tomy.txt_EnergyTolerance.NumericValue)
        'truncate arrays
        Array.Resize(arrSAIResults_POI, 0)
        Array.Resize(arrSAIResults_Element, 0)
        Array.Resize(arrSAIResults_ElementEnergy, 0)

        If GorX = "GS" Then
            For iCnt As Int32 = LBound(sngPOI) To UBound(sngPOI)
                For iCnt2 As Int32 = LBound(iIsotopeEnergy) To UBound(iIsotopeEnergy)
                    If Math.Abs((iIsotopeEnergy(iCnt2) * 1000) - sngPOI(iCnt)) < sngTol And Math.Abs((iIsotopeEnergy(iCnt2) * 1000) - sngPOI(iCnt)) > 0 Then
                        Array.Resize(arrSAIResults_POI, arrSAIResults_POI.Length + 1)
                        Array.Resize(arrSAIResults_Element, arrSAIResults_Element.Length + 1)
                        Array.Resize(arrSAIResults_ElementEnergy, arrSAIResults_ElementEnergy.Length + 1)
                        arrSAIResults_POI(UBound(arrSAIResults_POI)) = sngPOI(iCnt)
                        arrSAIResults_Element(UBound(arrSAIResults_Element)) = iIsotopeName(iCnt2)
                        arrSAIResults_ElementEnergy(UBound(arrSAIResults_ElementEnergy)) = (iIsotopeEnergy(iCnt2) * 1000)
                    End If
                Next
            Next

        ElseIf GorX = "XRF" Then
            For iCnt As Int32 = LBound(sngPOI) To UBound(sngPOI)
                For iCnt2 As Int32 = LBound(iXRFEnergy) To UBound(iXRFEnergy)
                    'If (sngPOI(iCnt) >= (iXRFEnergy(iCnt2) * 1000) - sngTol) And (sngPOI(iCnt) <= ((iXRFEnergy(iCnt2) * 1000) + sngTol)) Then
                    'If Math.Abs((iXRFEnergy(iCnt2) * 1000) - sngPOI(iCnt)) < sngTol And Math.Abs((iXRFEnergy(iCnt2) * 1000) - sngPOI(iCnt)) > 0 Then
                    If Math.Abs(iXRFEnergy(iCnt2) - sngPOI(iCnt)) < sngTol And Math.Abs(iXRFEnergy(iCnt2) - sngPOI(iCnt)) > 0 Then

                        Array.Resize(arrSAIResults_POI, arrSAIResults_POI.Length + 1)
                        Array.Resize(arrSAIResults_Element, arrSAIResults_Element.Length + 1)
                        Array.Resize(arrSAIResults_ElementEnergy, arrSAIResults_ElementEnergy.Length + 1)
                        arrSAIResults_POI(UBound(arrSAIResults_POI)) = sngPOI(iCnt)
                        arrSAIResults_Element(UBound(arrSAIResults_Element)) = iXRFName(iCnt2)
                        arrSAIResults_ElementEnergy(UBound(arrSAIResults_ElementEnergy)) = iXRFEnergy(iCnt2)
                    End If
                Next
            Next
        End If
    End Sub

End Class
