﻿
Class WaveRecorder

    Private mPBox As PictureBox
    Private mGraphics As Graphics

    Private mAudioIn As AudioIn = New AudioIn
    Private mBufferlen As Int32
    Private mCBufferSize As Int32 = 4096
    Private mCBuffer(mCBufferSize - 1) As Int32
    Private mCBufferWriteIndex As Int32
    Private mCBufferReadIndex As Int32

    Private mSamplesPerSec As Int32
    Private mInputDevice As Int32

    Private mBaseLineTest_Enable As Boolean
    Private mBaseLinePosition_Samples As Int32
    Private mBaseLineSize_Samples As Int32
    Private mBltMaxSlope As Single
    Private mBltMaxNoise As Single
    Private mPrevious1 As Int32
    Private mPrevious2 As Int32


    Friend AudioGain As Single
    Friend AudioZero As Int32
    Friend BinMultiplier As Single
    Friend TotalPulses As ULong
    Friend Counter As Int32
    Friend PeakMeter_Positive As Single
    Friend PeakMeter_Negative As Single
    Friend NegPulses As Boolean
    Friend Enabled As Boolean = True
    Friend Bins(MAX_BIN_INDEX) As Single
    Friend TimeMicrosec As Double
    Friend BLT_MaxSlopeAdjust As Boolean = True


    Friend WriteOnly Property Picture_Box() As PictureBox
        Set(ByVal value As PictureBox)
            mPBox = value
            mGraphics = Graphics.FromImage(mPBox.Image)
        End Set
    End Property

    Friend Property SamplesPerSec() As Int32
        Get
            Return mSamplesPerSec
        End Get
        Set(ByVal value As Int32)
            mSamplesPerSec = value
        End Set
    End Property
    Friend Property InputDevice() As Int32
        Get
            Return mInputDevice
        End Get
        Set(ByVal value As Int32)
            mInputDevice = value
        End Set
    End Property
    Friend Function RecordStart() As Boolean
        RecordStop()
        ' ------------------------------------------------- bufferLen = 20 mS
        Select Case mSamplesPerSec
            Case 44100
                mBufferlen = 940
            Case 48000
                mBufferlen = 1024
            Case 96000
                mBufferlen = 2048
            Case 144000
                mBufferlen = 3072
            Case 176400
                mBufferlen = 3760
            Case 192000
                mBufferlen = 4096
            Case 384000
                mBufferlen = 8192
            Case 768000
                mBufferlen = 16384
                'mSamplesPerSec = 201000 ' <<< error tester
            Case Else
                MsgBox("Invalid AudioIn sampling frequency")
        End Select
   
        Dim audioWorking As Boolean = mAudioIn.InputOn(InputDevice, _
                                                       mSamplesPerSec, _
                                                       16, _
                                                       1, _
                                                       mBufferlen, _
                                                       6, _
                                                       AddressOf DataArrived)

        If audioWorking Then
            Return True
        Else
            Return False
        End If
    End Function
    Friend Sub RecordStop()
        mAudioIn.InputOff()
    End Sub


    Friend WriteOnly Property BLT_Enable() As Boolean
        Set(ByVal value As Boolean)
            mBaseLineTest_Enable = value
        End Set
    End Property
    Friend WriteOnly Property BLT_Position_uS() As Single
        Set(ByVal value As Single)
            mBaseLinePosition_Samples = CInt(value * mSamplesPerSec / 1000000.0F)
            If mBaseLinePosition_Samples <= 0 Then mBaseLinePosition_Samples = 1
        End Set
    End Property
    Friend WriteOnly Property BLT_Size_uS() As Single
        Set(ByVal value As Single)
            mBaseLineSize_Samples = CInt(value * mSamplesPerSec / 1000000.0F)
            If mBaseLineSize_Samples <= 0 Then mBaseLineSize_Samples = 1
        End Set
    End Property
    Friend Property BLT_MaxSlope() As Single
        Get
            Return mBltMaxSlope
        End Get
        Set(ByVal value As Single)
            mBltMaxSlope = value
        End Set
    End Property
    Friend Property BLT_MaxNoise() As Single
        Get
            Return mBltMaxNoise
        End Get
        Set(ByVal value As Single)
            mBltMaxNoise = value
        End Set
    End Property


    ' =============================================================================================
    '  DATA ARRIVED - Version 4 - With Baseline TEST
    ' =============================================================================================
    '
    Private Sub DataArrived(ByRef WaveInBuffer() As Int16)
        '
        If Not Enabled Then Return
        Dim sw1 As Diagnostics.Stopwatch = New Diagnostics.Stopwatch : sw1.Start()
        '
        ' --------------------------------------------------------------------- initialize vars
        Dim MaxValue As Int32 = -999999
        Dim MinValue As Int32 = 999999
        Dim vmax0 As Int32 = MaxValue
        Dim vmin0 As Int32 = MinValue
        Dim v0 As Int32
        Dim index As Int32
        Dim ValidPulse As Boolean
        Dim BaseLine1, BaseLine2, BaseLine3 As Single
        BaseLine1 = 0
        BaseLine2 = 0
        BaseLine3 = 0
        Dim ScopeRR As String = " "
        ' --------------------------------------------------------------------- scan the buffer data
        For i As Int32 = 0 To WaveInBuffer.Length - 1
            ' ----------------------------------------------------------------- invert pulses
            If NegPulses Then
                v0 = -CInt((WaveInBuffer(i) - AudioZero) * AudioGain)
            Else
                v0 = CInt((WaveInBuffer(i) + AudioZero) * AudioGain)
            End If
            ' ----------------------------------------------------------------- peak values MIN and MAX
            If v0 > MaxValue Then MaxValue = v0
            If v0 < MinValue Then MinValue = v0
            ' ----------------------------------------------------------------- update the CircularBuffer
            mCBufferWriteIndex += 1
            If mCBufferWriteIndex >= mCBufferSize Then mCBufferWriteIndex = 0
            mCBufferReadIndex = mCBufferWriteIndex - 500
            If mCBufferReadIndex < 0 Then mCBufferReadIndex += mCBufferSize
            mCBuffer(mCBufferWriteIndex) = v0
            v0 = mCBuffer(mCBufferReadIndex)
            ' -----------------------------------------------------------------
            ValidPulse = True
            ScopeRR = " "
            ' ----------------------------------------------------------------- if level is decreasing
            Dim noise1 As Int32
            Dim noise2 As Int32
            If v0 < mPrevious1 And mPrevious1 >= mPrevious2 Then
                ' ------------------------------------------------------------- Baseline TEST
                If mBaseLineTest_Enable Then
                    Dim vmin As Int32
                    Dim vmax As Int32
                    Dim vsum As Int32
                    Dim v2 As Int32
                    ' --------------------------------------------------------- buffer index start position
                    index = mCBufferReadIndex - _
                            mBaseLinePosition_Samples - _
                            mBaseLineSize_Samples
                    If index < 0 Then index += mCBufferSize
                    ' --------------------------------------------------------- mean of the first half samples
                    'vmin = 999999
                    'vmax = -999999
                    vmin = vmin0
                    vmax = vmax0
                    vsum = 0
                    For j As Int32 = 1 To mBaseLineSize_Samples \ 2
                        index += 1
                        If index >= mCBufferSize Then index = 0
                        v2 = mCBuffer(index)
                        If v2 > vmax Then vmax = v2
                        If v2 < vmin Then vmin = v2
                        vsum += v2
                    Next
                    noise1 = vmax - vmin
                    BaseLine1 = vsum / (mBaseLineSize_Samples / 2.0F) ' - 0.5F)
                    ' --------------------------------------------------------- mean of the second half samples
                    'vmin = 999999
                    'vmax = -999999
                    vmin = vmin0
                    vmax = vmax0
                    vsum = 0
                    For j As Int32 = 1 To mBaseLineSize_Samples \ 2
                        index += 1
                        If index >= mCBufferSize Then index = 0
                        v2 = mCBuffer(index)
                        If v2 > vmax Then vmax = v2
                        If v2 < vmin Then vmin = v2
                        vsum += v2
                    Next
                    noise2 = vmax - vmin
                    BaseLine2 = vsum / (mBaseLineSize_Samples / 2.0F) ' - 0.5F)
                    ' --------------------------------------------------------- calc zero in the middle of the pulse 
                    Dim d1 As Single = mBaseLineSize_Samples \ 2
                    Dim d2 As Single = mBaseLinePosition_Samples + d1 / 2
                    BaseLine3 = BaseLine2 + (BaseLine2 - BaseLine1) * d2 / d1
                    ' --------------------------------------------------------- max differences = fraction of pulse
                    Dim MaxSlope As Single = mBltMaxSlope * (mPrevious1 - BaseLine3) / 100.0F
                    Dim MaxNoise As Single = mBltMaxNoise * (mPrevious1 - BaseLine3) / 100.0F

                    If Math.Abs(BaseLine2 - BaseLine1) > MaxSlope Then
                        ScopeRR = "S"
                        ValidPulse = False
                    ElseIf noise1 > MaxNoise OrElse noise2 > MaxNoise Then
                        ScopeRR = "N"
                        ValidPulse = False
                    End If
                    ' --------------------------------------------------------- max baseline = pulse * 0.2

                    If mBltMaxSlope >= 0 And Math.Abs(BaseLine1 - BaseLine3) > _
                                                    0.2 * Math.Abs(mPrevious1 - BaseLine3) Then
                        ScopeRR = "B"
                        ValidPulse = False
                    End If
                End If ' --- End Base Line Test
                ' ------------------------------------------------------------- pre pulse ringing rejection
                Dim TestTime_uS As Int32 = 200 ' 200 uS
                index = mCBufferReadIndex
                For j As Int32 = 1 To CInt(TestTime_uS * mSamplesPerSec / 1000000.0F)
                    index += 1
                    If index >= mCBufferSize Then index = 0
                    If mCBuffer(index) > mPrevious1 + 10 Then
                        ' in the test time following the center of the pulse
                        ' there are samples with eight more than pulse
                        ' so the pulse is not a true pulse but only a pre-pulse ringing
                        ScopeRR = "R"
                        ValidPulse = False
                        Exit For
                    End If
                Next
                Dim mp1 As Integer = mPrevious1
                If Not ValidPulse Then
                    mPrevious2 = mPrevious1
                    mPrevious1 = v0
                    mp1 = v0
                End If
                ' ------------------------------------------------------------- select the bin
                If BLT_MaxSlopeAdjust Then
                    index = CInt((mPrevious1 - BaseLine3) * BinMultiplier)
                Else
                    index = CInt((mPrevious1) * BinMultiplier)
                End If

                'If DBG Then
                'If index > 250 Then
                'flog.WriteLine(ValidPulse.ToString & " " & index.ToString() & ", " & mPrevious1.ToString() & ", " & ((mPrevious1) * BinMultiplier).ToString())
                'End If

                'End If

                If index < 0 Then index = 0

                ' ------------------------------------------------------------- copy Pulse Samples to Scope Samples
                If (ValidPulse And Rejected = 0) Or _
                     ((Rejected > 0 And RejectedReasons.Contains(ScopeRR)) Or _
                        (ValidPulse And Rejected = 2)) Then
                    If mGetScopeSamples AndAlso _
                                        index >= mMinEnergyBin AndAlso _
                                        index < mMinEnergyBin + mMaxEnergyBin Then
                        '
                        Dim i2 As Int32 = mCBufferReadIndex - MAX_SCOPE_SAMPLES \ 2 - 1
                        If i2 < 0 Then i2 += mCBufferSize
                        For j As Int32 = 0 To MAX_SCOPE_SAMPLES - 1
                            If mBltMaxSlope > 0 Then
                                mScopeSamples(j) = mCBuffer(i2) - BaseLine3
                            Else
                                mScopeSamples(j) = mCBuffer(i2)
                            End If
                            i2 += 1
                            If i2 >= mCBufferSize Then i2 = 0
                        Next
                        Dim denom As Single = (mp1 - BaseLine3) * 100
                        If denom <= 0 Then denom = 0.000001
                        mScopeNoise1 = CInt(noise1 / denom)
                        mScopeNoise2 = CInt(noise2 / denom)
                        mScopeRR = ScopeRR
                        mScopeBaseLine1 = BaseLine1
                        mScopeBaseLine2 = BaseLine2
                        mScopeBaseLine3 = BaseLine3
                        mScopeSlope = (BaseLine2 - BaseLine1) / denom
                        mGetScopeSamples = False
                        mValidScopeSamples = True
                        mRefreshPulsePicture = True
                    End If
                End If
                ' ------------------------------------------------------------- invalid pulse - continue
                If Not ValidPulse Then Continue For

                ' ------------------------------------------------------------- increase bin if not out of range
                If index > 0 And index < MAX_BIN_INDEX Then
                    Bins(index) += 1
                    TotalPulses += 1UL
                End If
                If index >= Spectrometer.mFirstBinIndex Then
                    Counter += 1
                    If Counter > 65535 Then Counter = 0
                End If
            End If
            ' ----------------------------------------------------------------- update Previous values
            mPrevious2 = mPrevious1
            mPrevious1 = v0
        Next
        ' --------------------------------------------------------------------- update PeakMeter
        If MaxValue > PeakMeter_Positive Then
            PeakMeter_Positive = MaxValue
        End If
        If MinValue < PeakMeter_Negative Then
            PeakMeter_Negative = MinValue
        End If
        ' --------------------------------------------------------------------- update elapsed time
        TimeMicrosec = sw1.Elapsed.TotalMilliseconds * 1000
    End Sub




    ' =============================================================================================
    '   SCOPE
    ' =============================================================================================
    Private Const MAX_SCOPE_SAMPLES As Int32 = 400
    Private mGetScopeSamples As Boolean = False
    Private mValidScopeSamples As Boolean = False
    Private mScopeSamples(MAX_SCOPE_SAMPLES) As Single
    Private mScopeBaseLine1 As Single
    Private mScopeBaseLine2 As Single
    Private mScopeBaseLine3 As Single
    Private mScopeSlope As Single
    Private mScopeNoise1 As Int32
    Private mScopeNoise2 As Int32
    Private mScopeRR As String = ""
    Private mVp As Int32
    Private mRp As Int32
    Friend Rejected As Integer
    Friend RejectedReasons As String

    Private mMaxEnergy As Single
    Private mMinEnergy As Single
    Private mMaxEnergyBin As Int32
    Private mMinEnergyBin As Int32
    Private mSizeX As Int32
    Private mPosY As Int32
    Private mSizeY As Int32
    Private mNormalized As Boolean
    Private mRefreshPulsePicture As Boolean

    Friend WriteOnly Property MaxEnergy() As Single
        Set(ByVal value As Single)
            mMaxEnergy = value
            mMaxEnergyBin = Spectrometer.EnergyToBin(value)
        End Set
    End Property
    Friend WriteOnly Property MinEnergy() As Single
        Set(ByVal value As Single)
            mMinEnergy = value
            mMinEnergyBin = Spectrometer.EnergyToBin(value)
        End Set
    End Property
    Friend WriteOnly Property SizeX() As Int32
        Set(ByVal value As Int32)
            mSizeX = value \ 2
            mRefreshPulsePicture = True
        End Set
    End Property
    Friend WriteOnly Property PosY() As Int32
        Set(ByVal value As Int32)
            mPosY = value
            mRefreshPulsePicture = True
        End Set
    End Property
    Friend WriteOnly Property SizeY() As Int32
        Set(ByVal value As Int32)
            mSizeY = value
            mRefreshPulsePicture = True
        End Set
    End Property
    Friend WriteOnly Property Normalized() As Boolean
        Set(ByVal value As Boolean)
            mNormalized = value
            mRefreshPulsePicture = True
        End Set
    End Property
    Friend Sub InvalidatePulsePicture()
        mRefreshPulsePicture = True
    End Sub
    Friend Sub Scope_Clear()
        If mGraphics Is Nothing Then Return
        mGraphics.Clear(Color.AliceBlue)
        mPBox.Invalidate()
        mGetScopeSamples = True
        mValidScopeSamples = False
        mRefreshPulsePicture = True
    End Sub
    Friend Sub Scope_Stop()
        mGetScopeSamples = False
    End Sub

    Friend Sub Scope_ShowPulses()
        If Form_Pulses.WindowState = FormWindowState.Minimized Then Return
        If Not Form_Pulses.Visible Then Return
        If mGraphics Is Nothing Then Return
        If Not mValidScopeSamples Then Return
        ' --------------------------------------------------------------------- 
        If Form_Pulses.btn_OneShot.Checked Then
            Form_Pulses.btn_Run.Checked = False
            Form_Pulses.btn_OneShot.Checked = False
            Return
        End If
        If Not Form_Pulses.btn_Run.Checked AndAlso Not mRefreshPulsePicture Then Return
        mRefreshPulsePicture = False
        ' --------------------------------------------------------------------- 
        Dim i As Int32
        Dim oldx, oldy, x, y, dx As Single
        Dim mPBoxW As Int32 = mPBox.ClientSize.Width
        Dim mPBoxH As Int32 = mPBox.ClientSize.Height
        Dim ZeroX As Int32
        Dim ZeroY As Int32
        Dim kx, ky As Single
        Dim p As Pen = Pens.DarkGreen
        ' -------------------------------------------------------------------- init sizes and positions
        If mNormalized Then
            ZeroY = CInt(mPBoxH * (1 - 0.4))
            ky = mScopeSamples(MAX_SCOPE_SAMPLES \ 2)
            If ky = 0 Then ky = 0.1
            ky = 0.8333F * ZeroY / ky
            ky = Math.Abs(ky)
        Else
            ZeroY = CInt(mPBoxH * (1 - mPosY * 0.01))
            ky = mSizeY / 5.0F * mPBoxH / 32768.0F
        End If
        ZeroX = mPBoxW \ 2
        kx = mPBoxW * 0.0005F * mSizeX
        ' --------------------------------------------------------------------- clear the scope area
        mGraphics.Clear(Color.AliceBlue)
        ' --------------------------------------------------------------------- Vertical lines
        For i = 0 To 16
            x = i * mPBoxW \ 16
            mGraphics.DrawLine(Pens.LightGray, x, 0, x, mPBoxH)
        Next
        ' --------------------------------------------------------------------- Horizz. lines
        For i = 0 To 10
            y = i * mPBoxH \ 10
            mGraphics.DrawLine(Pens.LightGray, 0, y, mPBoxW, y)
        Next
        ' --------------------------------------------------------------------- left side text
        Dim b As Brush = Brushes.DarkSlateBlue
        Dim bb As Brush = Brushes.DarkSlateBlue
        Dim f As Font = New Font("Arial", 10, FontStyle.Bold)
        Dim uSDiv As Single = mPBoxW / 16.0F * 1000000 / mSamplesPerSec / kx
        Dim mvDiv As Single = mPBoxH / 329.1F / ky
        Dim kevDiv As Single = Spectrometer.MillivoltToEnergy_NotLinearized(mvDiv)
        mGraphics.DrawString(kevDiv.ToString("Y: 0.0") & " KeV/div", f, b, 10, 5)
        mGraphics.DrawString(mvDiv.ToString("Y: 0.0") & " mV/div", f, b, 10, 25)
        mGraphics.DrawString(uSDiv.ToString("X: 0.0") & " uS/div", f, b, 10, mPBoxH - 20)
        ' --------------------------------------------------------------------- max pulse energy
        Dim v As Single = mScopeSamples(MAX_SCOPE_SAMPLES \ 2) * 1000 / 32768.0F
        Dim kev As Single = Spectrometer.MillivoltToEnergy_NotLinearized(v)
        mGraphics.DrawString("Pulse   " & kev.ToString("0.0") & " KeV", f, b, mPBoxW - 120, 5)
        kev = Spectrometer.MillivoltToEnergy(v)
        mGraphics.DrawString("Linear. " & kev.ToString("0.0") & " KeV", f, b, mPBoxW - 120, 25)
        Dim mSRR As String = ""
        If Rejected > 0 And mScopeRR <> " " Then
            mSRR = "Rej.= " & mScopeRR
            'If Rejected = 2 Then bb = Brushes.Red
            bb = Brushes.Red
            'p = Pens.DarkSalmon
        End If
        mGraphics.DrawString("S,   N1,  N2   " & mSRR & vbCrLf & CInt(mScopeSlope).ToString() & "%, " & mScopeNoise1.ToString & "%, " & mScopeNoise2.ToString & "%", f, bb, mPBoxW - 130, mPBoxH - 34)
        ' --------------------------------------------------------------------- warning
        If False And mMinEnergy = 0 Then
            Dim f2 As Font = New Font("Tahoma", 8, FontStyle.Regular)
            mGraphics.DrawString("WARNING - Min energy = 0", f2, Brushes.Maroon, mPBoxW - 150, mPBoxH - 45)
            mGraphics.DrawString("If not measuring the noise", f2, Brushes.Maroon, mPBoxW - 150, mPBoxH - 30)
            mGraphics.DrawString("increase it.  (use 1 or more)", f2, Brushes.Maroon, mPBoxW - 150, mPBoxH - 15)
        End If
        ' --------------------------------------------------------------------- red lines
        mGraphics.DrawLine(Pens.Red, 0, ZeroY, mPBoxW, ZeroY)
        mGraphics.DrawLine(Pens.Red, ZeroX, 0, ZeroX, mPBoxH)
        ' --------------------------------------------------------------------- plot pulses
        Dim visibleSamples As Int32 = CInt(2000 / mSizeX)
        i = MAX_SCOPE_SAMPLES \ 2 - visibleSamples \ 2
        oldx = -1
        For j As Int32 = -visibleSamples \ 2 To visibleSamples \ 2
            x = j * kx + ZeroX
            y = ZeroY - mScopeSamples(i) * ky
            i += 1
            If oldx >= 0 Then
                mGraphics.DrawLine(p, oldx, oldy, x, y)
                mGraphics.DrawEllipse(p, x - 2, y - 2, 4, 4)
            End If
            oldx = x
            oldy = y
        Next
        ' --------------------------------------------------------------------- baseLine rectangles
        If mBaseLineTest_Enable Then
            x = ZeroX - (mBaseLinePosition_Samples + mBaseLineSize_Samples) * kx
            dx = mBaseLineSize_Samples * kx * 0.5F
            y = ZeroY - 10
            Dim BL3 As Single = mScopeBaseLine3
            If mBltMaxSlope <= 0 Then BL3 = 0
            mGraphics.DrawRectangle(Pens.Blue, x, y - (mScopeBaseLine1 - BL3) * ky, dx, 20)
            mGraphics.DrawRectangle(Pens.Blue, x + dx, y - (mScopeBaseLine2 - BL3) * ky, dx, 20)
        End If
        ' --------------------------------------------------------------------- refresh
        mPBox.Invalidate()
        ' --------------------------------------------------------------------- restart
        If Form_Pulses.btn_Run.Checked Then
            mValidScopeSamples = False
            mGetScopeSamples = True
        End If
    End Sub

End Class

