﻿Imports System.Windows.Forms
Imports System.Net
Imports System.IO
Imports System.Collections.Generic

Public Class Dialog_Download
    Public URI As String
    Public Filename As String
    Public FileList As List(Of String) = New List(Of String)
    Private fn As String
    Dim WithEvents WC As New WebClient
    Private Busy As Boolean = False
    Dim Fcount As Integer = 0
    Private Sub OK_Button_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btn_DD_OK.Click
        If FileList.Count > 0 Then
            Dim n As Integer = CInt(40 / FileList.Count())
            For Each fn As String In FileList
                Fcount += 1
                Filename = fn
                txt_Mesassge.Text = Lc("DD_Start") & "  " & System.IO.Path.GetFileName(fn)
                Log("Start Downloading " & fn)
                While Busy
                    'Log("Busy " & fn)
                    Application.DoEvents()
                    System.Threading.Thread.Sleep(200)
                End While
                Busy = True
                Try
                    ProgressBar1.Value += n
                    WC.DownloadFile(New Uri(URI & System.IO.Path.GetFileName(fn)), fn)
                    'Log("Download done 0")
                    ProgressBar1.Value += n
                    Application.DoEvents()
                    System.Threading.Thread.Sleep(400)
                    Busy = False
                    'WC.DownloadFile(New Uri(URI & System.IO.Path.GetFileName(fn)), fn)
                Catch ex As Exception
                    Log("Downloading " & fn & " failed :" & ex.Message)
                End Try
                Log("Download done")
                'MsgBox("One done")
                'ProgressBar1.Value = 1
                'MsgBox("One done2")
            Next
            'Log("Download All done")
            ProgressBar1.Value = 100
            System.Threading.Thread.Sleep(700)
            WC.Dispose()
            ProgressBar1.Value = 1
            FileList.Clear()
            Me.DialogResult = System.Windows.Forms.DialogResult.OK
            Log("Me closing")
            Me.Close()
        Else
            Fcount = 1
            txt_Mesassge.Text = Lc("DD_Start") & "  " & System.IO.Path.GetFileName(Filename)
            Application.DoEvents()
            ProgressBar1.Value += 1
            WC.DownloadFileAsync(New Uri(URI), Filename)
        End If
    End Sub

    Private Sub Cancel_Button_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btn_DD_Cancel.Click
        Me.DialogResult = System.Windows.Forms.DialogResult.Cancel
        WC.Dispose()
        ' ------------- Delete "partial" file ???
        Busy = False
        Me.Close()
    End Sub

    Private Sub Dialog1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        ProgressBar1.Value = 1
        fn = Path.GetFileName(Filename)
        txt_Mesassge.Text = String.Format(Lc("DD_Download") & vbCrLf & URI, fn)
        '                "You can download from http://pico.dreamhosters.com/ThereminoMca.html", fn)
    End Sub

    Private Sub Download_OpenReadCompleted(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles WC.DownloadFileCompleted
        'Log("OpenRead_Completed")
        'Application.DoEvents()
        'Log("Next message 0")
        'System.Threading.Thread.Sleep(500)
        'Application.DoEvents()
        'Log("Next message 1")
        Application.DoEvents()
        'Log("Next message 2")
        If False And My.Computer.FileSystem.GetFileInfo(Filename).Length = 0 Then
            'Log("Deleting " & Filename)
            Try
                My.Computer.FileSystem.DeleteFile(Filename)
            Catch ex As Exception
                Log("Deleting " & Filename & " failed :" & ex.Message)
            End Try
            Me.DialogResult = System.Windows.Forms.DialogResult.Cancel
            MsgBox(Lc("DD_Sorry")) ' & vbCrLf & WC.)
        Else
            'Log("Seting Dialog result")
            Me.DialogResult = System.Windows.Forms.DialogResult.OK
        End If
        Fcount -= 1
        'Log(CStr(Fcount) & " more to download")
        Busy = False
        If Fcount <= 0 Then
            WC.Dispose()
            Me.Close()
            FileList.Clear()
            'Log("Cleaning up")
        End If
        'Log("Exit sub")
    End Sub

    Private Sub WC_DownloadProgressChanged(ByVal sender As Object, ByVal e As DownloadProgressChangedEventArgs) Handles WC.DownloadProgressChanged
        ProgressBar1.Value = e.ProgressPercentage
    End Sub

End Class
