﻿Imports System.Collections.Generic
Imports System.Text.RegularExpressions
Imports System.IO


Public Class Form_BSpectrum

    Friend BS_LocationX As Integer = 0
    Friend BS_LocationY As Integer = 0

    Friend BS_RawData As Boolean = True
    Friend BS_Repeat As Boolean = True
    Friend BS_Folder As String = ""
    Friend BS_Format As String = ""
    Friend BS_Ref As Int32 = 1
    Friend BS_Directory As String = "."
    Friend BS_Files As List(Of String) = New List(Of String)
    Friend BS_Index As Integer = -1
    Friend BS_OffsetMax As Single = 200
    Friend Mode As Integer = 0
    Friend BS_Output As String = "Output"
    Private BS_Outprefix As String = "Normal"
    Private BS_LoadFIleBusy As Boolean = False
    Private BS_PreviousFolder As String = "---"
    Private BS_PreviousFileIndex As Integer = -2


    Friend Sub BS_init()
        Me.Visible = False
        If BS_Folder = "" Then BS_Folder = Directory.GetCurrentDirectory()
        FolderBrowserDialog_BS.SelectedPath = BS_Folder
        'txt_BS_Index.Text = Form_Main.txt_BrowseSpectrum.Text
        btn_BS_UseBKG.Checked = Form_Main.btn_UseBkg.Checked
        If BS_LocationX = 0 And BS_LocationY = 0 Then
            BS_LocationX = Form_Main.Location.X + 400
            BS_LocationY = Form_Main.Location.Y + 200
        End If
        Me.Location = New Point(BS_LocationX, BS_LocationY)
        BS_set_Ref_state()
        If tk_BS_Speed.Value > 0 Then AnimateTimer.Interval = CInt(100 * 100 / tk_BS_Speed.Value)
        txt_BS_Offset.MaxValue = BS_OffsetMax
        txt_BS_Offset.MinValue = -BS_OffsetMax
    End Sub
    Private Sub Form_BSpectrum_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        chk_BS_RawData.Checked = BS_RawData
        chk_BS_Repeat.Checked = BS_Repeat
        txt_BS_Folder.Text = BS_Folder
        txt_BS_Filename.Text = BS_Format
        txt_BS_Speed.NumericValueInteger = tk_BS_Speed.Value
        If btn_BS_MoreOptions.Checked Then
            Me.Height = 456
        Else
            Me.Height = 220
        End If
        BS_set_Ref_state()
        'Me.TopMost = True
    End Sub

    Private Sub Button_BS_Brpwse(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btn_BS_Browse.Click
        Stop_Animate()
        'FolderBrowserDialog_BS.Description = "Choose folder"
        FolderBrowserDialog_BS.SelectedPath = txt_BS_Folder.Text
        If FolderBrowserDialog_BS.ShowDialog() = DialogResult.OK Then
            txt_BS_Folder.Text = FolderBrowserDialog_BS.SelectedPath
        End If
    End Sub


    Private Sub Apply_Changes(Optional ByVal loadspectrum As Boolean = True) ' --- Populate (if needed) the file list and load spectrum file
        BS_Folder = txt_BS_Folder.Text
        BS_RawData = chk_BS_RawData.Checked
        BS_Repeat = chk_BS_Repeat.Checked
        If rad_BS_Current.Checked Then
            Form_Main.ToolStripButton_Run.Checked = False
        End If
        If BS_Folder <> BS_PreviousFolder Then
            If Not Populate_FileList() Then
                lbl_BS_Info.Text = ""
                Stop_Animate()
                Exit Sub
            End If
            txt_BS_Index.NumericValueInteger = 0
            tk_BS_Index.Value = 0
            'Form_Main.txt_BrowseSpectrum.NumericValueInteger = 0
            LoadedSeconds = 0
            LoadedPulses = 0
        End If
        If loadspectrum Then BS_LoadSpectrum(BS_Index)
    End Sub

    Private Sub btn_BS_OK_Click(ByVal sender As System.Object, ByVal e As System.EventArgs)
        'Apply_Changes()
        Me.Hide()
        Form_Main.btn_BrowseSpectrum.Checked = False
        Stop_Animate()
    End Sub

    Private Sub btn_BS_Apply_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btn_BS_Apply.Click
        'BS_PreviousFolder = "---"
        Apply_Changes()
    End Sub

    Private Sub btn_BS_Cancel_Click(ByVal sender As System.Object, ByVal e As System.EventArgs)
        Me.Hide()
        Form_Main.btn_BrowseSpectrum.Checked = False
        Stop_Animate()
    End Sub

    Private Sub BS_set_Ref_state()
        If rad_BS_Ref1.Checked Then
            BS_Ref = 1
            btn_BS_ShowHide.Checked = Form_Main.btn_Reference1.Checked
        ElseIf rad_BS_Ref2.Checked Then
            BS_Ref = 2
            btn_BS_ShowHide.Checked = Form_Main.btn_Reference2.Checked
        ElseIf rad_BS_Ref3.Checked Then
            BS_Ref = 3
            btn_BS_ShowHide.Checked = Form_Main.btn_Reference3.Checked
        ElseIf rad_BS_BKG.Checked Then
            BS_Ref = 0
            btn_BS_ShowHide.Checked = Form_Main.btn_SaveAsBkg.Checked
            updateXY()
        ElseIf rad_BS_Current.Checked Then
            BS_Ref = 4
            Spectrometer.HideSpectrum = False
            btn_BS_ShowHide.Checked = True
            Exit Sub
        End If
        txt_BS_X_Multiply.NumericValue = CInt(Spectrometer.mRef_X_Factor(BS_Ref) * 100)
        Spectrometer.mDBG = (Spectrometer.mRef_X_Factor(BS_Ref) * 100).ToString
        txt_BS_X_Multiply00.NumericValue = CInt(((Spectrometer.mRef_X_Factor(BS_Ref) * 100) - txt_BS_X_Multiply.NumericValue) * 100)
        tk_BS_X.Value = hopstep_to_tk(txt_BS_X_Multiply.NumericValueInteger)
        If txt_BS_X_Multiply.NumericValue = 100 Then
            rad_BS_X_1.Checked = True
            rad_BS_X_Auto.Checked = False
        End If
        txt_BS_Y_Multiply.NumericValue = Spectrometer.mRef_Y_Factor(BS_Ref) * 100
        tk_BS_Y.Value = hopstep_to_tk(txt_BS_Y_Multiply.NumericValueInteger)
        If txt_BS_Y_Multiply.NumericValue = 100 Then
            rad_BS_Y_1.Checked = True
            rad_BS_Y_Auto.Checked = False
        End If
        txt_BS_Offset.NumericValue = Spectrometer.mRef_Offset(BS_Ref)
        BS_PreviousFileIndex = -2

    End Sub

    Private Sub rad_BS_Ref_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles rad_BS_Ref1.CheckedChanged, _
        rad_BS_Ref2.CheckedChanged, rad_BS_Ref3.CheckedChanged, rad_BS_BKG.CheckedChanged, rad_BS_Current.CheckedChanged
        BS_set_Ref_state()
    End Sub

    Friend Function Populate_FileList() As Boolean
        Dim d As String = txt_BS_Folder.Text
        BS_Files.Clear()
        If Not FolderExists(d) Then
            Return False
        End If
        For Each fn As String In Directory.GetFiles(d)
            Dim fnl As String = fn.ToLower
            If btn_BS_All.Checked Or (chk_BS_ThereminoMCA.Checked And fnl.EndsWith(".txt") And Not fnl.EndsWith("ini.txt") And Not fnl.Contains("_ini")) Or _
                (chk_BS_SPE.Checked And fnl.EndsWith(".spe")) Then
                'Log(fn)
                BS_Files.Add(fn)
            End If
        Next
        If BS_Files.Count() = 0 Then
            'MsgBox("Histogram file not found")
            'Form_Main.txt_BrowseSpectrum.Enabled = True
            'Form_Main.txt_BrowseSpectrum.Focus()
            'Form_Main.btn_BrowseSpectrum.Checked = False
            Stop_Animate()
            Return False
        End If
        tk_BS_Index.Maximum = BS_Files.Count() - 1
        BS_PreviousFolder = BS_Folder
        BS_PreviousFileIndex = -2
        BS_Index = 0
        Return True
    End Function

    Friend Sub BS_LoadSpectrum(ByVal n As Integer)
        If BS_LoadFIleBusy Or BS_Files.Count() = 0 Or (n = BS_PreviousFileIndex And (WaveRec.Enabled = False And BS_Ref = -1)) Then
            'Log("BS_LoadFIleBusy " & BS_LoadFIleBusy.ToString & ", " & BS_Files.Count & "," & n & ", " & BS_PreviousFileIndex)
            Exit Sub
        End If
        Dim fn As String = BS_Files(n)
        If btn_BS_All.Checked = False And _
        (((chk_BS_SPE.Checked = False) And BS_Files(n).ToLower().EndsWith(".spe")) Or _
        ((chk_BS_ThereminoMCA.Checked = False) And BS_Files(n).ToLower().EndsWith(".txt"))) Then
            lbl_BS_Info.Text = "Skipped"
            txt_BS_Filename.Text = Path.GetFileName(fn)
            Exit Sub
        End If
        BS_LoadFIleBusy = True
        txt_BS_Filename.Text = Path.GetFileName(fn)
        If BS_Ref = 4 And WaveRec.Enabled Then WaveRec.Enabled = False
        If LoadHistogramFile(BS_Ref, fn, True, chk_BS_RawData.Checked) Then
            Form_Main.btn_BrowseSpectrum.Checked = True
            btn_BS_ShowHide.Checked = True
            Select Case BS_Ref
                Case 1
                    Form_Main.btn_Reference1.Checked = True
                Case 2
                    Form_Main.btn_Reference2.Checked = True
                Case 3
                    Form_Main.btn_Reference3.Checked = True
                Case 0
                    Form_Main.btn_UseBkg.Enabled = True
                    Form_Main.btn_SaveAsBkg.Checked = True
                    Spectrometer.ApplyInterporation(0, 4, Spectrometer.mRefLastDataBin(0))
            End Select
            UpdateTitle()
            BS_PreviousFileIndex = n
            txt_BS_Index.NumericValueInteger = n
            tk_BS_Index.Value = n
            Form_Main.TimerDraw.Interval = 100
            If (Not rad_BS_Normal.Checked) And btn_BS_AutoSave.Checked Then
                save_reffile()
            End If
        End If
        BS_LoadFIleBusy = False
    End Sub

    Private Sub UpdateTitle()
        If BS_Index < 0 Or LoadedSeconds = 0 Or LoadedPulses = 0 Then
            lbl_BS_Info.Text = ""
            Stop_Animate()
            Exit Sub
        End If
        lbl_BS_Info.Text = "LT " & LoadedSeconds & " sec, " & _
           LoadedPulses & " cts,  " & CStr(CInt(LoadedPulses / LoadedSeconds)) & " cps," & _
           "  Max Count = " & CInt(Loadedmbv) & " cts, " & CInt(Loadedmbv / LoadedSeconds) & " cps"
        Form_Main.TimerDraw.Interval = 100
    End Sub

    Private BS_animate_delta As Integer

    Private Sub btn_BS_Forward_MouseUp(ByVal sender As System.Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles btn_BS_Forward.MouseUp
        BS_animate_delta = 1
        If Not btn_BS_Forward.Checked Then
            Stop_Animate()
            Exit Sub
        End If
        btn_BS_Back.Checked = False
        If txt_BS_Speed.NumericValue = 0 Then
            BS_IndexChanged(txt_BS_Index.NumericValueInteger + BS_animate_delta)
            btn_BS_Forward.Checked = False
        ElseIf Not AnimateTimer.Enabled Then
            AnimateTimer.Start()
        End If
    End Sub

    Private Sub btn_BS_Back_MouseUp(ByVal sender As System.Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles btn_BS_Back.MouseUp
        BS_animate_delta = -1
        If Not btn_BS_Back.Checked Then
            Stop_Animate()
            Exit Sub
        End If
        btn_BS_Forward.Checked = False
        If txt_BS_Speed.NumericValue = 0 Then
            BS_IndexChanged(txt_BS_Index.NumericValueInteger + BS_animate_delta)
            btn_BS_Back.Checked = False
        ElseIf Not AnimateTimer.Enabled Then
            AnimateTimer.Start()
        End If
    End Sub

    Private Sub btn_BS_Stop_MouseUp(ByVal sender As System.Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles btn_BS_Stop.MouseUp
        Stop_Animate()
    End Sub

    Private Sub Stop_Animate()
        AnimateTimer.Stop()
        btn_BS_Back.Checked = False
        btn_BS_Forward.Checked = False
    End Sub

    Private Sub AnimateTimer_Tick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles AnimateTimer.Tick
        Apply_Changes()
        BS_IndexChanged(txt_BS_Index.NumericValueInteger + BS_animate_delta)
    End Sub

    Private Sub Form_BSpectrum_FormClosing(ByVal sender As System.Object, ByVal e As System.Windows.Forms.FormClosingEventArgs) Handles MyBase.FormClosing
        Stop_Animate()
        BS_LocationX = Me.Location.X
        BS_LocationY = Me.Location.Y
        Spectrometer.HideSpectrum = False
        Form_Main.btn_BrowseSpectrum.Checked = False
        Me.Hide()
        e.Cancel = True
    End Sub

    Private Sub btn_Help_ClickButtonArea(ByVal Sender As System.Object, ByVal e As System.EventArgs) Handles btn_Help.ClickButtonArea
        Show_Help("Docs\BrowseSpectrum_Help_", ".rtf")
    End Sub

    Private Sub tk_BS_Index_Changes(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles tk_BS_Index.ValueChanged
        BS_IndexChanged(tk_BS_Index.Value)
    End Sub

    Private Sub txt_BS_Index_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles txt_BS_Index.TextChanged
        BS_IndexChanged(txt_BS_Index.NumericValueInteger)
    End Sub

    Friend Function BS_IndexChanged(ByVal v As Integer, Optional ByVal apply As Boolean = True) As Boolean
        If BS_Index = v Then Return True
        'Log("BS_Indexchanged " & BS_Index)
        Apply_Changes(False)
        Dim fc As Integer = BS_Files.Count() - 1
        Dim stop_play As Boolean = False
        If fc >= 0 Then
            If chk_BS_Repeat.Checked Then
                If v < 0 Then v = fc
                If v > fc Then v = 0
            Else
                If v < 0 Then v = 0 : stop_play = True
                If v > fc Then v = fc : stop_play = True
            End If
            BS_Index = v
            If apply Then Apply_Changes()
        Else
            v = 0
            stop_play = True
            BS_Index = 0
        End If
        tk_BS_Index.Value = v
        txt_BS_Index.NumericValueInteger = v
        'Form_Main.txt_BrowseSpectrum.NumericValueInteger = v
        If stop_play Then Stop_Animate()
        Return stop_play
    End Function

    Private Sub btn_BS_UseBKG_CheckedChanged(ByVal Sender As System.Object, ByVal e As System.EventArgs) Handles btn_BS_UseBKG.CheckedChanged
        Stop_Animate()
        If Not Form_Main.btn_UseBkg.Enabled Then btn_BS_UseBKG.Checked = False : Exit Sub
        Form_Main.btn_UseBkg.Checked = btn_BS_UseBKG.Checked
        Spectrometer.BKGsubtraction = btn_BS_UseBKG.Checked
        Spectrometer.UseReference(0) = Not btn_BS_UseBKG.Checked
        Form_Main.btn_SaveAsBkg.Checked = Not btn_BS_UseBKG.Checked
        If rad_BS_BKG.Checked Then btn_BS_ShowHide.Checked = Not btn_BS_UseBKG.Checked
        Form_Main.TimerDraw.Interval = 100
    End Sub

    Private Sub Btn_MoreOptions_ClickButtonArea(ByVal Sender As System.Object, ByVal e As System.EventArgs) Handles btn_BS_MoreOptions.ClickButtonArea
        If btn_BS_MoreOptions.Checked Then
            Me.Height = 456
        Else
            Me.Height = 220
        End If
    End Sub

    Private Sub rad_BS_Normal_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles rad_BS_Normal.CheckedChanged, _
        rad_BS_Difference.CheckedChanged, rad_BS_Sum.CheckedChanged, rad_BS_Add.CheckedChanged, rad_BS_Sub.CheckedChanged
        Stop_Animate()
        Dim i As Integer
        If rad_BS_Normal.Checked Then
            Mode = 0
            BS_Outprefix = "Normal"
        ElseIf rad_BS_Sum.Checked Then
            Mode = 1
            BS_Outprefix = "Sum"
        ElseIf rad_BS_Difference.Checked Then
            Mode = 2
            For i = 0 To MAX_BIN_INDEX
                mBuf(i) = 0
            Next
            mBufmbv = 0
            mBufsec = 0
            mBufpul = 0
            BS_Outprefix = "Diff"
        ElseIf rad_BS_Add.Checked Then
            Mode = 3
            Spectrometer.SetmBuf()
            BS_Outprefix = "Add"
        ElseIf rad_BS_Sub.Checked Then
            Mode = 4
            Spectrometer.SetmBuf()
            BS_Outprefix = "Sub"
        End If
    End Sub

    Private Sub btn_BS_Clear_ClickButtonArea(ByVal Sender As System.Object, ByVal e As System.EventArgs) Handles btn_BS_Clear.ClickButtonArea
        chk_BS_SPE.Checked = False
        chk_BS_ThereminoMCA.Checked = False
    End Sub

    Private Sub updateXY()
        If rad_BS_BKG.Checked Then
            Spectrometer.ApplyInterporation(0, 4, MAX_BIN_INDEX)
        End If
        Form_Main.TimerDraw.Interval = 100
        UpdateTitle()
    End Sub

    Private BS_X_State As String = ""
    Private BS_Y_State As String = ""

    Private Sub rad_BS_X_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles rad_BS_X_1.CheckedChanged, _
    rad_BS_X_2.CheckedChanged, rad_BS_X_5.CheckedChanged, rad_BS_X_10.CheckedChanged, rad_BS_X_20.CheckedChanged, rad_BS_X_Auto.CheckedChanged, rad_BS_X_1_2.CheckedChanged, rad_BS_X_1_10.CheckedChanged
        If rad_BS_X_1.Checked Then
            Spectrometer.mRef_X_Factor(BS_Ref) = 1
        ElseIf rad_BS_X_2.Checked Then
            Spectrometer.mRef_X_Factor(BS_Ref) = 2
        ElseIf rad_BS_X_5.Checked Then
            Spectrometer.mRef_X_Factor(BS_Ref) = 5
        ElseIf rad_BS_X_10.Checked Then
            Spectrometer.mRef_X_Factor(BS_Ref) = 10
        ElseIf rad_BS_X_20.Checked Then
            Spectrometer.mRef_X_Factor(BS_Ref) = 20
        ElseIf rad_BS_X_1_2.Checked Then
            Spectrometer.mRef_X_Factor(BS_Ref) = 0.5
        ElseIf rad_BS_X_1_10.Checked Then
            Spectrometer.mRef_X_Factor(BS_Ref) = 0.1
        ElseIf rad_BS_X_Auto.Checked Then
            Spectrometer.mRef_X_Factor(BS_Ref) = CSng((txt_BS_X_Multiply.NumericValue + txt_BS_X_Multiply00.NumericValue / 100) / 100)
            If Spectrometer.mRef_X_Factor(BS_Ref) = 0 Then
                txt_BS_X_Multiply.NumericValue = 100
                Spectrometer.mRef_X_Factor(BS_Ref) = 1
            End If
        Else
            MsgBox("Nothing checke")
        End If
        If BS_X_State = BS_Ref.ToString & "_" & Spectrometer.mRef_X_Factor(BS_Ref).ToString Then Exit Sub
        BS_X_State = BS_Ref.ToString & "_" & Spectrometer.mRef_X_Factor(BS_Ref).ToString
        updateXY()
    End Sub

    Private Sub rad_BS_Y_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles rad_BS_Y_1.CheckedChanged, _
        rad_BS_Y_2.CheckedChanged, rad_BS_Y_10.CheckedChanged, rad_BS_Y_100.CheckedChanged, rad_BS_Y_1_2.CheckedChanged, rad_BS_Y_Auto.CheckedChanged, rad_BS_Y_1_10.CheckedChanged
        If rad_BS_Y_1.Checked Then
            Spectrometer.mRef_Y_Factor(BS_Ref) = 1
        ElseIf rad_BS_Y_2.Checked Then
            Spectrometer.mRef_Y_Factor(BS_Ref) = 2
        ElseIf rad_BS_Y_10.Checked Then
            Spectrometer.mRef_Y_Factor(BS_Ref) = 10
        ElseIf rad_BS_Y_100.Checked Then
            Spectrometer.mRef_Y_Factor(BS_Ref) = 100
        ElseIf rad_BS_Y_1_2.Checked Then
            Spectrometer.mRef_Y_Factor(BS_Ref) = 0.5
        ElseIf rad_BS_Y_1_10.Checked Then
            Spectrometer.mRef_Y_Factor(BS_Ref) = 0.1
        ElseIf rad_BS_Y_Auto.Checked Then
            Spectrometer.mRef_Y_Factor(BS_Ref) = CSng(txt_BS_Y_Multiply.NumericValue) / 100
            If Spectrometer.mRef_Y_Factor(BS_Ref) = 0 Then
                Spectrometer.mRef_Y_Factor(BS_Ref) = 1
                txt_BS_Y_Multiply.NumericValue = 100
            End If
        End If
        If BS_Y_State = BS_Ref.ToString & "_" & Spectrometer.mRef_Y_Factor(BS_Ref).ToString Then Exit Sub
        BS_Y_State = BS_Ref.ToString & "_" & Spectrometer.mRef_Y_Factor(BS_Ref).ToString
        updateXY()
    End Sub

    Private Sub tk_BS_X_Scroll(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles tk_BS_X.Scroll
        txt_BS_X_Multiply.NumericValue = tk_to_hopstep(tk_BS_X.Value)
        Spectrometer.mRef_X_Factor(BS_Ref) = CSng(txt_BS_X_Multiply.NumericValue / 100.0)
        'updateXY()
    End Sub

    Private Sub tk_BS_Y_Scroll(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles tk_BS_Y.Scroll
        txt_BS_Y_Multiply.NumericValue = tk_to_hopstep(tk_BS_Y.Value)
        Spectrometer.mRef_Y_Factor(BS_Ref) = CSng(txt_BS_Y_Multiply.NumericValue / 100)
        'updateXY()
    End Sub

    Private Sub txt_BS_X_Multiply_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles txt_BS_X_Multiply.TextChanged, txt_BS_X_Multiply00.TextChanged
        Spectrometer.mRef_X_Factor(BS_Ref) = CSng((txt_BS_X_Multiply.NumericValue + txt_BS_X_Multiply00.NumericValue / 100) / 100)
        tk_BS_X.Value = hopstep_to_tk(txt_BS_X_Multiply.NumericValueInteger)
        rad_BS_X_Auto.Checked = True
        Spectrometer.mDBG = Spectrometer.mRef_X_Factor(BS_Ref).ToString
        updateXY()
    End Sub

    Private Sub txt_BS_Y_Multiply_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles txt_BS_Y_Multiply.TextChanged
        Spectrometer.mRef_Y_Factor(BS_Ref) = CSng(txt_BS_Y_Multiply.NumericValue) / 100
        tk_BS_Y.Value = hopstep_to_tk(txt_BS_Y_Multiply.NumericValueInteger)
        rad_BS_Y_Auto.Checked = True
        updateXY()
    End Sub

    Private Sub txt_BS_Offset_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles txt_BS_Offset.TextChanged
        Spectrometer.mRef_Offset(BS_Ref) = CSng(txt_BS_Offset.NumericValue)
        updateXY()
    End Sub

    Private Sub btn_BS_ShowHide_ClickButtonArea(ByVal Sender As System.Object, ByVal e As System.EventArgs) Handles btn_BS_ShowHide.CheckedChanged
        Stop_Animate()
        Select Case BS_Ref
            Case 1
                set_ShowHide(BS_Ref, Form_Main.btn_Reference1.Checked)
            Case 2
                set_ShowHide(BS_Ref, Form_Main.btn_Reference2.Checked)
            Case 3
                set_ShowHide(BS_Ref, Form_Main.btn_Reference3.Checked)
            Case 0
                If btn_BS_UseBKG.Checked Then btn_BS_ShowHide.Checked = False : Exit Sub
                set_ShowHide(BS_Ref, Form_Main.btn_SaveAsBkg.Checked)
            Case 4
                Spectrometer.HideSpectrum = Not btn_BS_ShowHide.Checked
        End Select
    End Sub

    Private Sub set_ShowHide(ByVal n As Integer, ByRef checked As Boolean)
        If btn_BS_ShowHide.Checked And Not Spectrometer.mReferenceValid(n) Then
            Log("Shohide Apply")
            Apply_Changes()
        End If
        checked = btn_BS_ShowHide.Checked
        Spectrometer.UseReference(n) = checked
        Form_Main.TimerDraw.Interval = 100
    End Sub

    Private Sub OpenFileDialog_BS_FileOk(ByVal sender As System.Object, ByVal e As System.ComponentModel.CancelEventArgs) Handles OpenFileDialog_BS.FileOk
        If OpenFileDialog_BS.SafeFileNames.Length = 0 Then
            Exit Sub
        ElseIf OpenFileDialog_BS.SafeFileNames.Length = 1 Then
            txt_BS_Folder.Text = Path.GetDirectoryName(OpenFileDialog_BS.FileName)
            Populate_FileList()
            BS_Index = BS_Files.IndexOf(OpenFileDialog_BS.FileNames(0))
            Apply_Changes()
            BS_Index = BS_Files.IndexOf(OpenFileDialog_BS.FileNames(0))
        Else
            txt_BS_Folder.Text = Path.GetDirectoryName(OpenFileDialog_BS.FileName)
            'OpenFileDialog_BS.
            BS_Folder = txt_BS_Folder.Text
            BS_Files = New List(Of String)(OpenFileDialog_BS.FileNames)
            txt_BS_Index.NumericValueInteger = BS_Files.IndexOf(OpenFileDialog_BS.FileName)
            tk_BS_Index.Value = txt_BS_Index.NumericValueInteger
            BS_Index = tk_BS_Index.Value
            BS_PreviousFileIndex = -3
            tk_BS_Index.Maximum = BS_Files.Count() - 1
            BS_LoadSpectrum(BS_Index)
            UpdateTitle()
        End If

    End Sub

    Private Sub Button1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btn_BS_Filename.Click
        Stop_Animate()
        With OpenFileDialog_BS
            .InitialDirectory = txt_BS_Folder.Text
            .Multiselect = True
            .CheckPathExists = True
            .CheckFileExists = True
            .RestoreDirectory = True
            .Filter = "Histogram files (*.txt)|*.txt|SPE files (*.spe)|*.spe|Histogram and SPE (*.txt, *.spe)|*.txt;*.spe|All files (*.*)|*.*"
            .FilterIndex = 4
            If Not btn_BS_All.Checked Then
                If chk_BS_ThereminoMCA.Checked And chk_BS_SPE.Checked Then
                    .FilterIndex = 3
                ElseIf chk_BS_ThereminoMCA.Checked Then
                    .FilterIndex = 1
                ElseIf chk_BS_SPE.Checked Then
                    .FilterIndex = 2
                End If
            End If
            .ShowDialog()
        End With
    End Sub

    Private Sub Form_BSpectrum_LocationChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.LocationChanged
        BS_LocationX = Me.Location.X
        BS_LocationY = Me.Location.Y
    End Sub

    Private Sub Form_BSpectrum_VisibleChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.VisibleChanged
        If Not Me.Visible Then Stop_Animate()
    End Sub

    Private Sub txt_BS_Speed_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles txt_BS_Speed.TextChanged
        tk_BS_Speed.Value = txt_BS_Speed.NumericValueInteger
        set_Animate_Timer()
    End Sub

    Private Sub tk_BS_Speed_Scroll(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles tk_BS_Speed.Scroll
        txt_BS_Speed.NumericValueInteger = tk_BS_Speed.Value
        set_Animate_Timer()
    End Sub

    Private Sub set_Animate_Timer()
        If tk_BS_Speed.Value > 0 Then
            AnimateTimer.Interval = CInt(100 * 100 / tk_BS_Speed.Value)
        Else
            Stop_Animate()
        End If
    End Sub

    Private Sub btn_BS_SetBase_ClickButtonArea(ByVal Sender As System.Object, ByVal e As System.EventArgs) Handles btn_BS_SetBase.ClickButtonArea
        Spectrometer.SetmBuf()
    End Sub


    Private Sub btn_BS_SaveNow_ClickButtonArea(ByVal Sender As System.Object, ByVal e As System.EventArgs) Handles btn_BS_SaveNow.ClickButtonArea
        save_reffile()
    End Sub

    Private Sub save_reffile()

        Dim fn As String
        If BS_Files.Count = 0 Then
            Dim nref As Integer = BS_Ref
            If nref >= 0 And Spectrometer.mReferenceValid(nref) = False Then Exit Sub
            If BS_Ref = 0 Then
                fn = "BKG"
            ElseIf BS_Ref < -1 Then
                fn = "Current"
            Else
                fn = "Ref" & BS_Ref
            End If
            fn += "-" & Date.Now.ToString("yyyy_MM_dd_HH_mm_ss") & ".spe"
        Else
            fn = Path.GetFileName(BS_Files(BS_Index))
        End If
        fn = BS_Folder & "\" & BS_Output & "\" & BS_Outprefix & "_" & fn
        Directory.CreateDirectory(Path.GetDirectoryName(fn))
        If fn.ToLower().EndsWith(".spe") Then
            AutoSaveSpefile(fn, BS_Ref)
        ElseIf fn.ToLower().EndsWith(".txt") Then
            AutoSaveHistogramFile(fn, BS_Ref)
        End If
    End Sub

    Private Sub chk_BS_RawData_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles chk_BS_RawData.CheckedChanged
        If chk_BS_RawData.Checked Then
            chk_BS_EnergyAdj.BackColor = GB_BS_X.BackColor
        Else
            chk_BS_EnergyAdj.BackColor = Color.LightGray
        End If
    End Sub

    Private Sub btn_BS_ComitXY_MouseUp(ByVal sender As System.Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles btn_BS_CommitXY.MouseUp
        If BS_Ref = -1 Then Exit Sub
        Dim nref As Integer = BS_Ref
        If nref = 0 Then
            For i As Integer = 0 To Spectrometer.mRefLastDataBin(4)
                Spectrometer.mReferences(0, i) = Spectrometer.mReferences(4, i)
            Next
        Else
            Spectrometer.mRefLastDataBin(nref) = CInt(Spectrometer.mRefLastDataBin(nref) * X_Factor) + Spectrometer.EnergyToBin(Spectrometer.mRef_Offset(nref))
            If Spectrometer.mRefLastDataBin(nref) > MAX_BIN_INDEX Then Spectrometer.mRefLastDataBin(nref) = MAX_BIN_INDEX
            Spectrometer.ApplyInterporation(nref, nref, Spectrometer.mRefLastDataBin(nref))
        End If
        Spectrometer.mRef_X_Factor(nref) = 1
        Spectrometer.mRef_Y_Factor(nref) = 1
        Spectrometer.mRef_Offset(nref) = 0
        rad_BS_X_1.Checked = True
        rad_BS_Y_1.Checked = True
        txt_BS_Offset.NumericValue = 0
        BS_PreviousFileIndex = -2
        Form_Main.TimerDraw.Interval = 100
    End Sub

    Private Sub btn_BS_CopyBack_MouseUp(ByVal sender As System.Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles btn_BS_CopyBack.MouseUp
        If BS_Ref < 0 Then Exit Sub
        Spectrometer.mLastBinIndex = Spectrometer.mRefLastDataBin(BS_Ref)
        Dim mbv As Single = 1
        For i As Integer = 0 To Spectrometer.mLastBinIndex
            WaveRec.Bins(i) = Spectrometer.mReferences(BS_Ref, i) / 2
            If WaveRec.Bins(i) > mbv Then mbv = WaveRec.Bins(i)
        Next
        Spectrometer.mMaxBinValue = mbv
        WaveRec.TotalPulses = Spectrometer.mRefTotalPulses(BS_Ref)
        TotalSeconds = Spectrometer.mRefTotalSeconds(BS_Ref)
        Form_Main.TimerDraw.Interval = 100
    End Sub

    Private Sub chk_Format_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles chk_BS_ThereminoMCA.CheckedChanged, chk_BS_SPE.CheckedChanged
        If Not (btn_BS_All.Checked Or chk_BS_ThereminoMCA.Checked Or chk_BS_SPE.Checked) Then
            txt_BS_Filename.Text = ""
            BS_PreviousFolder = "---"
            BS_Files.Clear()
            UpdateTitle()
            Exit Sub
        End If
        If btn_BS_All.Checked = False Then
            BS_PreviousFolder = "---"
            Apply_Changes()
        End If
    End Sub

    Private Sub btn_BS_All_CheckedChanged(ByVal Sender As System.Object, ByVal e As System.EventArgs) Handles btn_BS_All.CheckedChanged
        If Not (btn_BS_All.Checked Or chk_BS_ThereminoMCA.Checked Or chk_BS_SPE.Checked) Then
            txt_BS_Filename.Text = ""
            BS_PreviousFolder = "---"
            BS_Files.Clear()
            UpdateTitle()
            Exit Sub
        End If
        If btn_BS_All.Checked <> chk_BS_ThereminoMCA.Checked Or btn_BS_All.Checked <> chk_BS_SPE.Checked Then
            BS_PreviousFolder = "---"
            Apply_Changes()
        End If
    End Sub
End Class