﻿' TODO - MAIN LIST
' -------------------------------------------------
' Version 7.2 
' - Increased scale and zoom up to 10 MeV
' - Increased EnergyTrimmer up to 3000



Imports System.Drawing
Imports System.IO
Imports System.Text.RegularExpressions
Imports System
Imports System.Collections.Generic
Imports System.Net
'Imports System.Globalization
Imports System.Threading

Module ThereminoMCA_Program
    Friend Debug_Log As Boolean = False
    Friend ValidPulses As ULong
    Friend TotalSeconds As ULong
    Friend PulsesPerSec As Single
    Friend IntegrationTime As ULong
    Friend Slot_Counter As Int32
    Friend Slot_BinsFirstSlot As Int32
    Friend BinsNumSlots As Int32
    Friend OnlySelectedRows As Boolean
    Friend AutoPolarityTest As Boolean
    Friend IntegrationMode As Boolean = False

    Friend Tomy_StartIsotopeIndex As Int32
    Friend Form1_StartWindowState As Int32
    Friend Form2_StartWindowState As Int32
    Friend Form3_StartWindowState As Int32
    Friend Form4_StartWindowState As Int32
    Friend Form2_StartVisible As Boolean = True
    Friend Form3_StartVisible As Boolean = True
    Friend Form4_StartVisible As Boolean = False
    Public MAX_BIN_INDEX As Int32 = 4095
    Friend Isotopes As cIsotopes = New cIsotopes
    Friend WaveRec As WaveRecorder = New WaveRecorder
    Friend Spectrometer As cSpectrometer = New cSpectrometer

    Friend EXPDBG As Boolean = False
    Friend EXPMSG As Boolean = False


    ' Experimental -- NKOM ---
    'Friend Locale_Strings As New Dictionary(Of String, String)
    Friend cpsvalue As Single = 0.0001
    Friend maxyvalue As Single = 10
    Friend IsotopeEditing As Boolean = False
    Friend HalfMaxEnergy As Integer = 2400 '2048 ' 4096ch / 2
    Friend X_Factor As Single = 1
    Friend Y_Factor As Single = 1
    Friend LoadedSeconds As ULong = 0UL
    Friend LoadedPulses As ULong = 0UL
    Friend Loadedmbv As Single = 0
    Friend StartTime As Date
    Friend AutoSaveSeconds As Single = 300
    Friend AutoSaveSecondsMinimum As Integer = 10
    Friend AutoSave_StartNew As Boolean = False
    Friend AutoSave_Folder As String = Directory.GetCurrentDirectory()
    Friend AutoSave_Format As String = "Data\ThereminoMCA_(yyyy_MM_dd_HH_mm_ss)"
    Friend AutoSave_Execute As String = ""
    Friend AutoSave_ExecuteEnabled As Boolean = False
    Friend BinFactor As Single
    Friend IntegrationFactor As Single
    Friend TotalTick As ULong = 0UL
    Friend TotalCounts As ULong = 0UL
    Friend IntegrationSeconds As ULong = 0UL
    Friend BackgroundSeconds As ULong = 0UL

    Friend mBuf(MAX_BIN_INDEX) As Single
    Friend mBufsec As ULong
    Friend mBufpul As ULong
    Friend mBufmbv As Single

    Friend DBG As Boolean = False

    Friend Lc As Dictionary(Of String, String) = New Dictionary(Of String, String)

    '--- Description of fields in chk_list and chk_listBUF 
    Enum AutoSave_lst
        Name = 0
        Desc = 1
        Checked = 2
        Ext = 3
    End Enum

    ' ------------- Lazy way to initialize structure. Not probably the best way, though
    Friend chk_List(,) As Object = New Object(10, 3) { _
        {"Histogram", " Theremino_MCA standard format", True, "txt"}, _
        {"Full Image PNG", "Screen capture of entire aplication", False, "png"}, _
        {"Full Image JPG", "Screen capture of entire aplication", False, "jpg"}, _
        {"Spectrum Image PNG", "Screen capture of spectrum", False, "spc.png"}, _
        {"Spectrum Image JPG", "Screen capture of spectrum", False, "spc.jpg"}, _
        {"spe file", "Spectrum data in GBS Elektronik (PM1703 MO-1A/B) Format", False, "spe"}, _
        {"csv BeqMoni", "(Not Implemented yet) Spectrum data BeqMoni style csv format", False, "csv"}, _
        {"ats file", "(Not Implemented yet) Spectrum data in ATOMTEX AT1320 format", False, "ats"}, _
        {"", "", False, ""}, _
        {"", "", False, ""}, _
        {"", "", False, ""} _
    }
    ' ------ Structure buffer to hold localized data
    Friend chk_ListBUF(,) As Object = New Object(10, 3) { _
        {"", "", True, ""}, _
        {"", "", False, ""}, _
        {"", "", False, ""}, _
        {"", "", False, ""}, _
        {"", "", False, ""}, _
        {"", "", False, ""}, _
        {"", "", False, ""}, _
        {"", "", False, ""}, _
        {"", "", False, ""}, _
        {"", "", False, ""}, _
        {"", "", False, ""} _
    }

    Friend Language_Abbreviation(,) As String = New String(8, 1) { _
        {"English", "ENG"}, _
        {"Italian", "ITA"}, _
        {"Francais", "FRA"}, _
        {"Deutsch", "DEU"}, _
        {"Espanol", "ESP"}, _
        {"Portoguese", "POR"}, _
        {"Japanese", "JPN"}, _
        {"Chinese", "CHI"}, _
        {"", ""} _
    }

    Public Delegate Sub AutoSave_Delegate(ByVal s As String)

    ' ----- Structure of Delegate so that we can store delagates in array 
    Structure Dele
        Dim addr As AutoSave_Delegate
    End Structure

    Friend AutoSave_sd(10) As Dele
    'Friend Lc() As Dele

    ' ----- Debug log
    Friend Sub Log(Optional ByVal s As String = "", Optional ByVal o As Object = "")
        If Not DBG Then Exit Sub
        Dim f As StreamWriter = New StreamWriter("log.txt", True)
        f.WriteLine(s)
        f.Close()
    End Sub


    Friend Function hopstep(ByVal n As Integer, Optional ByVal vstop As Integer = 0) As Integer
        Dim hs As Integer = CInt(10 ^ (n.ToString.Length() - 1))
        Dim r As Integer
        If vstop > 0 And vstop < hs Then
            hs = vstop
            Dim t As Integer = n \ vstop
            Dim nlen As Integer = n.ToString.Length()
            Dim vlen As Integer = vstop.ToString.Length()
            Dim ss As Integer = nlen - vlen + 1
            Dim rr As Integer = CInt(CInt(n \ vstop).ToString.Substring(0, ss))
            r = rr * vstop
            r = CInt(CInt(n \ vstop).ToString.Substring(0, n.ToString.Length() - vstop.ToString.Length() + 1)) * vstop
        Else
            r = CInt(n.ToString.Substring(0, 1)) * hs
        End If
        If n = r + 1 Then r = r + hs
        Return r
    End Function

    Friend Function hopstep_to_tk(ByVal n As Integer) As Integer
        Dim hs As Integer = CInt(9 * (n.ToString.Length() - 1))
        Return CInt(n.ToString.Substring(0, 1)) + hs
    End Function

    Friend Function tk_to_hopstep(ByVal n As Integer) As Integer
        Dim b As Integer = 1
        Do While n > 10
            n -= 9
            b *= 10
        Loop
        Return n * b
    End Function

    'Friend flog As StreamWriter
End Module


Public Class Form_Main

    Private Sub Form_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        'File_Kill("log.txt")
        'flog = New StreamWriter("dlog.txt", True)

        Log("E: Form_Main.load")
        EventsAreEnabled = False
        System.Windows.Forms.Application.CurrentCulture = New System.Globalization.CultureInfo("EN-US")
        cmb_Bins.SelectedIndex = 3
        cmb_Sampling.SelectedIndex = 5
        cmb_PulsePolarity.SelectedIndex = 2
        Form_Pulses.Top = Me.Top
        Form_Pulses.Left = Me.Left + 800
        Form_Equalizers.Top = Me.Top + 320
        Form_Equalizers.Left = Me.Left + 800
        ' ---- Read isotopes_energy.txt and prepare isotope marker
        If IdentiFinder Is Nothing Then IdentiFinder = New Class_Identify
        Isotopes.ListIsotopes()

        IVmode = True : SaveLoad_INI()
        Lc_Init()
        SetLocales()
        Dim pbox_back_color As Color = PBox_Spectrum.BackColor

        'Log("SetLocales done")
        FillAudioInDevicesCombo()
        IntegrationMode = btn_IntegrationTime.Checked
        txt_AutoSave.MinValue = AutoSaveSecondsMinimum
        txt_Zoom.NumericValueInteger = tk_Zoom.Value
        txt_EqMaster.NumericValueInteger = tk_EqMaster.Value
        txt_LinMaster.NumericValueInteger = tk_LinMaster.Value
        tk_MaxY.Value = tknum2Rev(txt_MaxY.NumericValueInteger) * 3
        InitPictureboxImage(PBox_Spectrum)
        Spectrometer.Picture_Box = PBox_Spectrum
        ' -------------------------------------------
        'EventsAreEnabled = True
        Spectrometer.InitAll()
        PBox_Spectrum.BackColor = pbox_back_color
        Set_Props()
        Form_Equalizers.CreateLinearityCurve()
        Form_Equalizers.CreateHeightCurve()
        Form_Equalizers.EnableDisableControls()
        Form_Pulses.SetProps()
        StartAudioReader()
        cmb_SampleRows_Init()

        Spectrometer.LastAudioCardBin = CInt(Spectrometer.MillivoltToBin(1000 * WaveRec.AudioGain) - 1)
        If Spectrometer.LastAudioCardBin > MAX_BIN_INDEX Then Spectrometer.LastAudioCardBin = MAX_BIN_INDEX
        Spectrometer.LastDataBin = Spectrometer.LastAudioCardBin

        AllBinsToZero()
        Dim BuidDate As String = _
            System.IO.File.GetLastWriteTime(System.Reflection.Assembly.GetExecutingAssembly().Location).ToString("yyyy-MM-dd  HH:mm:ss")

        Me.Text = AppTitleAndVersion() '("--- BETA " & BuidDate & " --- Theremino MCA")
        EventsAreEnabled = True
        GroupBox_AudioInput.Focus()
        EventsAreEnabled = False

        ' Experimental -- AutoSave ----------------
        AutoSave_sd_Init()
        Form_BSpectrum.BS_init()

        If DBG Then btn_InputSelection.Visible = True
        btn_InputSelection_set()

        '' ------------------------------------------- Save left position and invisibilize them
        'Dim old1 As Int32 = Form_Pulses.Left
        'Dim old2 As Int32 = Form_Equalizers.Left
        'Form_Pulses.Left = -9999
        'Form_Equalizers.Left = -9999
        '' ------------------------------------------- Start windows
        'EventsAreEnabled = True
        'Me.WindowState = CType(Form1_StartWindowState, FormWindowState)
        'EventsAreEnabled = False
        'Form_Pulses.Show(Me)
        'Form_Pulses.Visible = Form2_StartVisible
        'Form_Pulses.Left = old1
        'Form_Pulses.WindowState = CType(Form2_StartWindowState, FormWindowState)
        'Form_Equalizers.Show(Me)
        'Form_Equalizers.Visible = Form3_StartVisible
        'Form_Equalizers.Left = old2
        'Form_Equalizers.WindowState = CType(Form3_StartWindowState, FormWindowState)
        'DockAllWindows()

        ' ------------------------------------------- Start windows (NEW with FadeIn)
        EventsAreEnabled = True
        Me.WindowState = CType(Form1_StartWindowState, FormWindowState)
        EventsAreEnabled = False
        Form_Pulses.Show(Me)
        Form_Pulses.Visible = Form2_StartVisible
        Form_Pulses.WindowState = CType(Form2_StartWindowState, FormWindowState)
        Form_Equalizers.Show(Me)
        Form_Equalizers.Visible = Form3_StartVisible
        Form_Equalizers.WindowState = CType(Form3_StartWindowState, FormWindowState)
        Form_Tomy.Show(Me)
        Form_Tomy.Visible = Not Form4_StartVisible
        Form_Tomy.WindowState = CType(Form4_StartWindowState, FormWindowState)
        EnableDisableTomy()
        DockAllWindows()

        ' ------------------------------------------- Resize TabControl1 and UserText
        TabControl1_Resize()
        txt_UserText.SelectionStart = 9999
        txt_UserText.SelectionLength = 0
        txt_UserText.Focus()
        ' ------------------------------------------- Tomy area
        'EnableDisableTomy()
        ' ------------------------------------------- FadeIn
        Forms_FadeTo(1, 400)
        ' ------------------------------------------- Test StopTimer and Start
        TestTimerBeforeToStart()
        TimerDraw.Interval = 100
        TimerDraw.Start()
        Timer10Hz.Interval = 100
        Timer10Hz.Start()
        Timer1Sec.Interval = 1000
        Timer1Sec.Start()
        ' ------------------------------------------- start with a good wave in the PulseShapeVisualizer 
        WaveRec.Scope_Clear()
        'Log("On load Gain=" & WaveRec.AudioGain & ", LastACB=" & Spectrometer.LastAudioCardBin & ", LastDB=" & Spectrometer.LastDataBin & ", Binfact=" & BinFactor)
        ' -------------------------------------------
        ToolStrip1.Renderer = New ToolStripButtonRenderer
        ' -------------------------------------------
        EventsAreEnabled = True
        ' -------------------------------------------
        If Not ToolStripButton_Run.Checked Then StopRun()
    End Sub

    '    Private Sub Form_Closing(ByVal sender As Object, ByVal e As System.ComponentModel.CancelEventArgs) Handles Me.FormClosing
    Private Sub Form_Closing(ByVal sender As Object, ByVal e As System.Windows.Forms.FormClosingEventArgs) Handles Me.FormClosing
        'Log("E: Form_Main.FormClosing")
        'Log("Form_Tomy.visible=" & Form_Tomy.Visible.ToString)
        'Log(e.CloseReason.ToString & Me.Location.ToString & Me.Size.ToString)
        'MsgBox(e.CloseReason.ToString & Me.Location.ToString & Me.Size.ToString)
        IVmode = False : SaveLoad_INI()
        EventsAreEnabled = False ' do not permit to save the ini file ( already saved from form2 )
        Forms_FadeTo(0, 500)
        Me.Refresh()
        e.Cancel = False
        TimerDraw.Stop()
        Timer1Sec.Stop()
        WaveRec.RecordStop()
        'flog.Close()
    End Sub

    Private Sub Form_Move(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Move
        'Log("E: Form_Main.Move")
        If Not EventsAreEnabled Then Return
        LimitFormPosition(Me)
        DockAllWindows()
    End Sub

    Private Sub Form1_Resize(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Resize
        Log("E: Form_Main.Resize")
        If Not EventsAreEnabled Then Return
        If Me.WindowState = FormWindowState.Minimized Then Return
        InitPictureboxImage(PBox_Spectrum)
        Spectrometer.Picture_Box = PBox_Spectrum
        Spectrometer.Draw()
        DockAllWindows()
    End Sub

    Friend Sub DockAllWindows()
        Form_Pulses.SetSnap()
        Form_Equalizers.SetSnap()
        Form_Tomy.SetSnap()
    End Sub

    ' ===================================================================================
    '   MenuStrip and ToolStrip Gradients
    ' ===================================================================================
    Private Sub MenuStrip1_Paint(ByVal sender As Object, ByVal e As System.Windows.Forms.PaintEventArgs) Handles MenuStrip1.Paint
        Dim bounds As New Rectangle(0, 0, _
                                    MenuStrip1.Width, MenuStrip1.Height)
        Dim brush As New Drawing2D.LinearGradientBrush(bounds, _
                                                       Color.FromArgb(230, 230, 230), _
                                                       Color.FromArgb(200, 200, 200), _
                                                       Drawing2D.LinearGradientMode.Horizontal)
        e.Graphics.FillRectangle(brush, bounds)
    End Sub
    Private Sub ToolStrip1_Paint(ByVal sender As System.Object, ByVal e As System.Windows.Forms.PaintEventArgs) Handles ToolStrip1.Paint
        Dim bounds As New Rectangle(0, 0, _
                                    ToolStrip1.Width, ToolStrip1.Height)
        Dim brush As New Drawing2D.LinearGradientBrush(bounds, _
                                                       Color.White, _
                                                       Color.FromArgb(200, 200, 200), _
                                                       Drawing2D.LinearGradientMode.Vertical)
        e.Graphics.FillRectangle(brush, bounds)
    End Sub

    ' ===================================================================================
    '   ToolStrip PressedButton color
    ' ===================================================================================
    Class ToolStripButtonRenderer
        Inherits System.Windows.Forms.ToolStripProfessionalRenderer
        Protected Overrides Sub OnRenderButtonBackground(ByVal e As ToolStripItemRenderEventArgs)
            Dim btn As ToolStripButton = CType(e.Item, ToolStripButton)
            If btn IsNot Nothing AndAlso btn.CheckOnClick AndAlso btn.Checked Then
                Dim bounds As Rectangle = New Rectangle(0, 0, e.Item.Width - 1, e.Item.Height - 1)
                Dim brush As New Drawing2D.LinearGradientBrush(bounds, _
                                                               Color.Gold, _
                                                               Color.FromArgb(250, 250, 250), _
                                                               Drawing2D.LinearGradientMode.Vertical)
                e.Graphics.FillRectangle(brush, bounds)
                e.Graphics.DrawRectangle(Pens.Orange, bounds)
            Else
                MyBase.OnRenderButtonBackground(e)
            End If
        End Sub
    End Class

    ' ===================================================================================
    '  MenuStrip and ToolStrip accepting the first click
    '  If the form receives a WM_PARENTNOTIFY (528) message and is not focused 
    '  then the form is activated before to exec the message
    ' ===================================================================================
    Protected Overrides Sub WndProc(ByRef m As Message)
        If m.Msg = 528 AndAlso Not Me.Focused Then
            Me.Activate()
        End If
        MyBase.WndProc(m)
    End Sub


    ' =======================================================================================
    '   MENU FILE
    ' =======================================================================================
    Private Sub Menu_File_LoadConfiguration_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Menu_File_LoadConfiguration.Click
        Log("E: Menu_File_LoadConfiguration.Click")
        EventsAreEnabled = False
        LoadConfiguration()
        Set_Props()
        Form_Pulses.SetProps()
        Form_Equalizers.CreateLinearityCurve()
        Form_Equalizers.CreateHeightCurve()
        StartAudioReader()
        EventsAreEnabled = True
    End Sub
    Private Sub Menu_File_SaveConfigurationAs_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Menu_File_SaveConfigurationAs.Click
        Log("E: Menu_File_SaveConfigurationAs.Click")
        SaveConfigurationAs()
    End Sub
    Private Sub Menu_File_SaveImage_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Menu_File_SaveImage.Click
        Log("E: Menu_File_SaveImage.Click")
        SaveImage("ThereminoMCA_", Me)
    End Sub
    Private Sub Menu_File_SavePlotImage_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Menu_File_SavePlotImage.Click
        Log("E: Menu_File_SavePlotImage.Click")
        SaveImage("SPECTRUM_", GroupBox_SpectrumData)
    End Sub
    Private Sub Menu_File_ExportPulseHeight_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Menu_File_ExportPulseHeight.Click
        SaveHistogramFile(chk_ExportWithHeader.Checked, txt_DecimalSeparator.Text, txt_FieldSeparator.Text)
    End Sub
    Private Sub Menu_File_ImportToRef1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Menu_File_ImportToRef1.Click
        If LoadHistogramFile(1) Then btn_Reference1.Checked = True
    End Sub
    Private Sub Menu_File_ImportToRef2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Menu_File_ImportToRef2.Click
        If LoadHistogramFile(2) Then btn_Reference2.Checked = True
    End Sub
    Private Sub Menu_File_ImportToRef3_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Menu_File_ImportToRef3.Click
        If LoadHistogramFile(3) Then btn_Reference3.Checked = True
    End Sub
    Private Sub Menu_File_ImportToBKG_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Menu_File_ImportToBKG.Click
        If LoadHistogramFile(0) Then btn_UseBkg.Enabled = True : btn_UseBkg.Checked = True : Spectrometer.ApplyInterporation(0, 4, Spectrometer.mRefLastDataBin(0))
    End Sub
    Private Sub Menu_File_Exit_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Menu_File_Exit.Click
        Me.Close()
    End Sub


    ' =======================================================================================
    '   MENU TOOLS
    ' =======================================================================================
    Private Sub MenuTools_NoiseTest_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MenuTools_NoiseTest.Click
        If MsgBox("Preparing for noise test:" & vbCrLf & _
                  " - Baseline Test will be disabled" & vbCrLf & _
                  " - Pulse shape visualizer params will be changed" & vbCrLf & _
                  " - The Audio zero will be measured and changed" & vbCrLf & vbCrLf & _
                  "Remember to disconnect the PMT ( the BNC cable )" & vbCrLf & vbCrLf & _
                  "Proceed ?", MsgBoxStyle.YesNo) <> MsgBoxResult.Yes Then Return
        '
        ' ---------------------------------------------------------------------------- prepare
        chk_BltEnable.Checked = False
        Set_Props()
        Form_Pulses.txt_MaxEnergy.NumericValueInteger = 3200
        Form_Pulses.txt_MinEnergy.NumericValueInteger = 0
        Form_Pulses.tk_SizeX.Value = 10
        Form_Pulses.tk_SizeY.Value = 19
        Form_Pulses.tk_PosY.Value = 50
        Form_Pulses.btn_Run.Checked = True
        Form_Pulses.btn_Normalized.Checked = False
        Form_Pulses.SetProps()
        ' ---------------------------------------------------------------------------- do the test
        txt_AudioZero.NumericValueInteger = 0
        Set_Props()
        WaveRec.PeakMeter_Negative = 999999
        WaveRec.PeakMeter_Positive = -999999
        Threading.Thread.Sleep(500)
        Dim v As Int32 = CInt((9 - (WaveRec.PeakMeter_Positive + WaveRec.PeakMeter_Negative) / 2) / WaveRec.AudioGain)
        txt_AudioZero.NumericValueInteger = v
        Set_Props()
    End Sub

    Private Sub MenuTools_StartPulseSimulator_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MenuTools_StartPulseSimulator.Click
        If MsgBox("Pulse simulation" & vbCrLf & vbCrLf & _
                  " - The 3 generators could simulate up to three rows" & vbCrLf & _
                  " - The Freq. must be set near to 50 Hz for normal 150 uS pulses" & vbCrLf & _
                  " - The dB is the energy regulation. Normally from -50 to -10" & vbCrLf & vbCrLf & _
                  "The pulse simulator output signal is an audio signal" & vbCrLf & _
                  "so the MCA audio input must be changed to ""Stereo mixer""." & vbCrLf & vbCrLf & _
                  "Proceed ?", MsgBoxStyle.YesNo) <> MsgBoxResult.Yes Then Return
        Dim fname As String = Application.StartupPath + "\Theremino_AudioExamples.exe"
        If FileExists(fname) Then Process.Start(fname)
    End Sub


    ' =======================================================================================
    '   MENU LANGUAGE
    ' =======================================================================================
    Private Sub Menu_Language_DropDownOpening(ByVal sender As Object, ByVal e As System.EventArgs) Handles Menu_Language.DropDownOpening
        For Each item As ToolStripMenuItem In Menu_Language.DropDownItems
            If item.Name.EndsWith(Language, StringComparison.InvariantCultureIgnoreCase) Then
                item.Select()
            End If
        Next
    End Sub
    Private Sub Menu_Language_Deutsch_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles Menu_Language_Deutsch.Click
        Language = "Deutsch"
        SetLocales()
        'IVmode = False : SaveLoad_INI()
    End Sub
    Private Sub Menu_Language_English_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles Menu_Language_English.Click
        Language = "English"
        SetLocales()
        'IVmode = False : SaveLoad_INI()
    End Sub
    Private Sub Menu_Language_Espanol_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles Menu_Language_Espanol.Click
        Language = "Espanol"
        SetLocales()
        ' IVmode = False : SaveLoad_INI()
    End Sub
    Private Sub Menu_Language_Portoguese_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles Menu_Language_Portoguese.Click
        Language = "Portoguese"
        SetLocales()
        ' IVmode = False : SaveLoad_INI()
    End Sub
    Private Sub Menu_Language_Francais_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles Menu_Language_Francais.Click
        Language = "Francais"
        SetLocales()
        'IVmode = False : SaveLoad_INI()
    End Sub
    Private Sub Menu_Language_Italian_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles Menu_Language_Italian.Click
        Language = "Italian"
        SetLocales()
        'IVmode = False : SaveLoad_INI()
    End Sub
    Private Sub Menu_Language_Japanese_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Menu_Language_Japanese.Click
        Language = "Japanese"
        SetLocales()
        'IVmode = False : SaveLoad_INI()
    End Sub
    Private Sub Menu_Language_Chinese_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Menu_Language_Chinese.Click
        Language = "Chinese"
        SetLocales()
        'IVmode = False : SaveLoad_INI()
    End Sub

    ' =======================================================================================
    '   MENU HELP
    ' =======================================================================================
    Private Sub Menu_Help_ProgramHelp_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Menu_Help_ProgramHelp.Click
        OpenLocalizedHelp("ThereminoMCA_Help", ".pdf")
    End Sub
    Private Sub Menu_Help_StartingGuide_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Menu_Help_StartingGuide.Click
        OpenLocalizedHelp("StartingGuide", ".pdf")
    End Sub
    Private Sub Menu_Help_PmtAdapters_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Menu_Help_PmtAdapters.Click
        OpenLocalizedHelp("PmtAdapters", ".pdf")
    End Sub
    Private Sub Menu_Help_TestAudioSignal_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Menu_Help_TestAudioSignal.Click
        OpenLocalizedHelp("TestAudioSignal", ".pdf")
    End Sub
    Private Sub Menu_Help_SignalConditioning_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Menu_Help_SignalConditioning.Click
        OpenLocalizedHelp("SignalConditioning", ".pdf")
    End Sub
    Private Sub Menu_Help_MinimizingFWHM_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Menu_Help_MinimizingFWHM.Click
        OpenLocalizedHelp("MinimizingFWHM", ".pdf")
    End Sub
    Private Sub Menu_Help_IsotopeIdentifier_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Menu_Help_IsotopeIdentifier.Click
        OpenLocalizedHelp("IsotopeIdentifier_Help", ".pdf")
    End Sub
    Private Sub Menu_Help_Isotopes_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Menu_Help_Isotopes.Click
        OpenLocalizedHelp("Isotopes", ".txt")
    End Sub
    Private Sub Menu_Help_ToDoList_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Menu_Help_ToDoList.Click
        OpenLocalizedHelp("ToDo", ".txt")
    End Sub
    Private Sub Menu_Help_OpenProgramFolder_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Menu_Help_OpenProgramFolder.Click
        Process.Start(Application.StartupPath)
    End Sub
    Private Sub OpenLocalizedHelp(ByVal name As String, Optional ByVal ext As String = ".rtf")
        Dim fname As String = PlatformAdjustedFileName(Application.StartupPath & "\Docs\" & name & "_" & LanguageSuffix() & ext)
        If FileExists(fname) Then
            Process.Start(fname)
        Else
            fname = PlatformAdjustedFileName(Application.StartupPath & "\Docs\" & name & "_ENG" & ext)
            If FileExists(fname) Then
                Process.Start(fname)
            Else
                fname = PlatformAdjustedFileName(Application.StartupPath & "\Docs\" & name & "_ITA" & ext)
                If FileExists(fname) Then
                    Process.Start(fname)
                Else
                    fname = PlatformAdjustedFileName(Application.StartupPath & "\Docs\" & name & ext)
                    If FileExists(fname) Then
                        Process.Start(fname)
                    End If
                End If
            End If
        End If
    End Sub


    ' =======================================================================================
    '   MENU ABOUT
    ' =======================================================================================
    Private Sub Menu_About_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Menu_About.Click
        Form_About.ShowDialog()
    End Sub


    ' =======================================================================================
    '   TOOLBAR
    ' =======================================================================================
    Private Sub ToolStripButton_SaveImage_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ToolStripButton_SaveImage.Click
        ToolStripButton_SaveImage.Visible = False
        ToolStripButton_SaveImage.Visible = True
        Me.Refresh()
        SaveImage("ThereminoMCA_", Me)
    End Sub
    Private Sub ToolStripButton_AudioInputs_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ToolStripButton_AudioInputs.Click
        Shell("control mmsys.cpl,,1", AppWinStyle.NormalFocus)
    End Sub
    Private Sub ToolStripButton_Export_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ToolStripButton_Export.Click
        SaveHistogramFile(chk_ExportWithHeader.Checked, txt_DecimalSeparator.Text, txt_FieldSeparator.Text)
    End Sub
    Private Sub ToolStripButton_ViewPulses_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ToolStripButton_ViewPulses.Click
        If Form_Pulses.Visible Then
            Form_Pulses.Visible = False
        Else
            Form_Pulses.Visible = True
            Me.Focus()
        End If
        DockAllWindows()
    End Sub
    Private Sub ToolStripButton_ViewEqualizers_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ToolStripButton_ViewEqualizers.Click
        If Form_Equalizers.Visible Then
            Form_Equalizers.Visible = False
        Else
            Form_Equalizers.Visible = True
            Me.Focus()
        End If
        DockAllWindows()
    End Sub
    Private Sub ToolStripButton_Run_CheckedChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles ToolStripButton_Run.CheckedChanged
        If Not EventsAreEnabled Then Return
        If ToolStripButton_Run.Checked Then
            TestTimerBeforeToStart()
            WaveRec.Enabled = True
            Spectrometer.LastDataBin = Spectrometer.LastAudioCardBin
            If Spectrometer.LastDataBin > MAX_BIN_INDEX Then Spectrometer.LastDataBin = MAX_BIN_INDEX
        Else
            WaveRec.Enabled = False
        End If
    End Sub
    Private Sub ToolStripButton_StartMeasure_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ToolStripButton_StartMeasure.Click
        AllBinsToZero()
        ToolStripButton_Run.Checked = True
        GroupBox_SpectrumData.Focus()
    End Sub

    Private Sub TestTimerBeforeToStart()
        If txt_StopTimer.NumericValueInteger > 0 Then
            MsgBox("Warning: the aquisiton time is limited to " & _
              txt_StopTimer.NumericValueInteger.ToString & " seconds.")
            StartRun()
        End If
    End Sub

    Private Sub StartRun()
        WaveRec.Enabled = False
        AllBinsToZero()
        lbl_TotalSeconds.Text = "0"
        TotalSeconds = 0
        AutoSaveSeconds = 0
        WaveRec.TotalPulses = 0
        WaveRec.Enabled = True
    End Sub

    Private Sub StopRun()
        WaveRec.Enabled = False
        AllBinsToZero()
        lbl_TotalSeconds.Text = "0"
        TotalSeconds = 0
        AutoSaveSeconds = 0
        WaveRec.TotalPulses = 0
    End Sub


    ' =======================================================================================
    '   TOOLBAR TOMY
    ' =======================================================================================
    Private Sub ToolStripButton_IsotopeIdentifier_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ToolStripButton_Identifier.Click
        '       If Not EventsAreEnabled Then Return
        EnableDisableTomy()
    End Sub
    Private Sub EnableDisableTomy()
        If Not Form_Tomy.Visible Then
            'Form_Tomy.TopMost = False
            IdentiFinder.Enable()
            Form_Tomy.Visible = True
            Me.Focus()
        Else
            IdentiFinder.Disable()
            Form_Tomy.Visible = False
            'Form_Tomy.Hide()
        End If
        DockAllWindows()
    End Sub



    ' ================================================================================================
    '   PBox_Spectrum mouse access
    ' ================================================================================================
    Private Sub PBox_Spectrum_MouseDown(ByVal sender As Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles PBox_Spectrum.MouseDown
        If e.Button = Windows.Forms.MouseButtons.Left Then
            Spectrometer.SetSelectedBinFromX(e.X)
            SelectIsotopeLine()
            Spectrometer.SnapToPeak = False
        End If
        If e.Button = Windows.Forms.MouseButtons.Right Then
            Spectrometer.SetSelectedBinFromX(e.X)
            Spectrometer.SnapToPeak = True
        End If
    End Sub
    Private Sub PBox_Spectrum_MouseMove(ByVal sender As Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles PBox_Spectrum.MouseMove
        If e.Button = Windows.Forms.MouseButtons.Left Then
            Spectrometer.SetSelectedBinFromX(e.X)
            SelectIsotopeLine()
        End If
        If e.Button = Windows.Forms.MouseButtons.Right Then
            Spectrometer.SetSelectedBinFromX(e.X)
        End If
    End Sub

    Private Sub Form_Main_KeyDown(ByVal sender As Object, ByVal e As System.Windows.Forms.KeyEventArgs) Handles Me.KeyDown
        If Not Label_Dummy.Focused Then Return
        If e.KeyCode = Keys.Left Then Spectrometer.ChangeSelectedBin(-1)
        If e.KeyCode = Keys.Right Then Spectrometer.ChangeSelectedBin(1)
        If e.KeyCode = Keys.PageDown Then Spectrometer.ChangeSelectedBin(-10)
        If e.KeyCode = Keys.PageUp Then Spectrometer.ChangeSelectedBin(10)
    End Sub

    Private Sub Form_Main_MouseWheel(ByVal sender As Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles Me.MouseWheel
        If Not Label_Dummy.Focused Then Return
        Spectrometer.ChangeSelectedBin(e.Delta \ 120)
    End Sub

    ' ------------------------------------------ set focus to a dummy label
    Private Sub PBox_Spectrum_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles PBox_Spectrum.Click
        Label_Dummy.Focus()
    End Sub

    Private Sub PBox_Spectrum_DoubleClick(ByVal sender As Object, ByVal e As System.EventArgs) Handles PBox_Spectrum.DoubleClick
        If MyListView1.SelectedItems.Count > 0 Then
            With MyListView1.SelectedItems(0)
                .Checked = Not .Checked
                Spectrometer.IsotopeListChanged = True
            End With
            TimerDraw.Interval = 100 ' show changes immediately
        End If
        Label_Dummy.Focus()
    End Sub

    Private Sub SelectIsotopeLine()
        Dim mindelta As Double = 9999999
        Dim delta As Double
        Dim index As Int32
        Dim energy As Double
        For i As Int32 = 0 To MyListView1.Items.Count - 1
            energy = Val(MyListView1.Items(i).SubItems(1).Text)
            If energy > 0 Then
                delta = Math.Abs(Spectrometer.SelectedEnergy - energy)
                If delta < mindelta Then
                    mindelta = delta
                    index = i
                End If
            End If
        Next
        MyListView1.Items(index).Selected = True
        MyListView1.Select()
        index = index - 10
        If index < 0 Then index = 0
        If index > MyListView1.Items.Count - 1 Then index = MyListView1.Items.Count - 1
        MyListView1.TopItem = MyListView1.Items(index)
        MyListView1.TopItem = MyListView1.Items(index)
        MyListView1.TopItem = MyListView1.Items(index) ' for some strange reason this is required three times
    End Sub

    Private Sub btn_DeselectAllRows_ClickButtonArea(ByVal Sender As System.Object, ByVal e As System.EventArgs) Handles btn_DeselectAllRows.ClickButtonArea
        For i As Int32 = 0 To MyListView1.Items.Count - 1
            MyListView1.Items(i).Checked = False
        Next
        Spectrometer.IsotopeListChanged = True
        TimerDraw.Interval = 100 ' show changes immediately
    End Sub

    Private Sub btn_ExtendCheckedRows_ClickButtonArea(ByVal Sender As System.Object, ByVal e As System.EventArgs) Handles btn_ExtendCheckedRows.ClickButtonArea
        For i As Int32 = 0 To MyListView1.Items.Count - 1
            If MyListView1.Items(i).Checked Then
                Dim name As String = MyListView1.Items(i).Text
                For j As Int32 = 0 To MyListView1.Items.Count - 1
                    If MyListView1.Items(j).Text = name Then
                        MyListView1.Items(j).Checked = True
                    End If
                Next
            End If
        Next
        Spectrometer.IsotopeListChanged = True
        TimerDraw.Interval = 100 ' show changes immediately
    End Sub

    Private Sub btn_ExtendSelectedIsotope_ClickButtonArea(ByVal Sender As System.Object, ByVal e As System.EventArgs) Handles btn_ExtendSelectedIsotope.ClickButtonArea
        If MyListView1.SelectedIndices.Count <> 1 Then Return
        Dim i As Int32 = MyListView1.SelectedIndices(0)
        Dim name As String = MyListView1.Items(i).Text
        For j As Int32 = 0 To MyListView1.Items.Count - 1
            If MyListView1.Items(j).Text = name Then
                MyListView1.Items(j).Checked = True
            End If
        Next
        Spectrometer.IsotopeListChanged = True
        TimerDraw.Interval = 100 ' show changes immediately
    End Sub

    Private Sub cmb_SampleRows_DropDown(ByVal sender As Object, ByVal e As System.EventArgs) Handles cmb_SampleRows.DropDown
        cmb_SampleRows.ItemHeight = 15
        cmb_SampleRows.Items.Clear()
        cmb_SampleRows.Items.Add("No samples")
        Dim fname As String = Application.StartupPath + "\Extra\SampleRows.txt"
        If Not FileExists(fname) Then Return
        Dim StringArray() As String
        StringArray = IO.File.ReadAllLines(fname)
        cmb_SampleRows.Items.Clear()
        For Each s As String In StringArray
            If s.StartsWith("SAMPLE ") Then
                s = s.Substring(6).Trim
                cmb_SampleRows.Items.Add(s)
            End If
        Next
    End Sub
    Private Sub cmb_SampleRows_DropDownClosed(ByVal sender As Object, ByVal e As System.EventArgs) Handles cmb_SampleRows.DropDownClosed
        If cmb_SampleRows.SelectedItem Is Nothing Then
            cmb_SampleRows_Init()
            Return
        End If
        ' ------------------------------------------------------- find nearest rows
        Dim s As String = cmb_SampleRows.SelectedItem.ToString
        Dim sa As String() = s.Split(" "c)
        For Each s In sa
            Dim v As Single = CSng(Val(s.Replace(",", ".")))
            If v > 0 Then
                Dim MinDistance As Double = Double.MaxValue
                Dim Distance As Double
                Dim index As Int32 = 0
                For j As Int32 = 0 To MyListView1.Items.Count - 1
                    Distance = Math.Abs(Val(MyListView1.Items(j).SubItems(1).Text) - v)
                    If Distance <= 1 AndAlso Distance < MinDistance Then
                        MinDistance = Distance
                        index = j
                    End If
                Next
                If index > 0 Then MyListView1.Items(index).Checked = True
            End If
        Next
        Spectrometer.IsotopeListChanged = True
        TimerDraw.Interval = 100 ' show changes immediately
        cmb_SampleRows_Init()    ' reinit the combo
    End Sub
    Private Sub cmb_SampleRows_Init()
        cmb_SampleRows.ItemHeight = 11
        cmb_SampleRows.Items.Clear()
        cmb_SampleRows.Items.Add("Select sample")
        cmb_SampleRows.SelectedIndex = 0
    End Sub

    Private Sub btn_EditSamplesRowsFile_ClickButtonArea(ByVal Sender As System.Object, ByVal e As System.EventArgs) Handles btn_EditSamplesRowsFile.ClickButtonArea
        Dim fname As String = Application.StartupPath + "\Extra\SampleRows.txt"
        If Not FileExists(fname) Then Return
        Process.Start(fname)
    End Sub

    ' ================================================================================================
    '   Show Selected Bin Data - LOWER STATUS ROW
    ' ================================================================================================
    Friend Sub ShowSelectedBinData()
        Dim n As Int32
        If Spectrometer.SelectedBin > 0 AndAlso Spectrometer.SelectedBin <= Spectrometer.mLastBinIndex Then
            n = CInt(WaveRec.Bins(Spectrometer.SelectedBin))
            Spectrometer.SelectedEnergy = Spectrometer.XtoEnergy(Spectrometer.BinToX(Spectrometer.SelectedBin))
            Dim nn As Single = n
            If IntegrationMode Then nn = n / IntegrationFactor

            ' ------------------------------------------------------- original
            'Dim s As String = (nn / TotalSeconds).ToString()
            'If s.Length < 7 Then s &= "       ".Substring(0, 7 - s.Length)
            's = s.Substring(0, 7)
            'StatusLabel2.Text = "Selected Bin=" & Spectrometer.SelectedBin.ToString & _
            '                    "  Energy=" & Spectrometer.SelectedEnergy.ToString("0.0 KeV") & _
            '                    "  Samples=" & nn.ToString("0") & _
            '                    "  cps=" & s

            ' ------------------------------------------------------- corrected CPS
            Dim s As String = (0.5 * Spectrometer.mValues(Spectrometer.SelectedBin) / TotalSeconds).ToString("0.0")
            If s.Length < 7 Then s &= "       ".Substring(0, 7 - s.Length)
            s = s.Substring(0, 7)
            StatusLabel2.Text = "Selected Bin=" & Spectrometer.SelectedBin.ToString & _
                                "  Energy=" & Spectrometer.SelectedEnergy.ToString("0.0 KeV") & _
                                "  Samples=" & nn.ToString("0") & _
                                "  cps=" & s

            ' ------------------------------------------------------- find selected row nearest to selected bin
            'Dim dist As Single
            'Dim mindist As Single = Single.MaxValue
            'Dim SelectedIsotope As Int32
            'For i As Int32 = 0 To Spectrometer.SelectedIsotopes.Length - 1
            '    dist = Math.Abs(Spectrometer.SelectedIsotopes(i).Energy - Spectrometer.SelectedEnergy)
            '    If dist < mindist Then
            '        mindist = dist
            '        SelectedIsotope = i
            '    End If
            'Next

            'Dim s As String = Spectrometer.IsotopeData(SelectedIsotope).ToString()
            'If s.Length < 7 Then s &= "       ".Substring(0, 7 - s.Length)
            's = s.Substring(0, 7)
            'StatusLabel2.Text = "Selected Bin=" & Spectrometer.SelectedBin.ToString & _
            '                    "  Energy=" & Spectrometer.SelectedEnergy.ToString("0.0 KeV") & _
            '                    "  Samples=" & nn.ToString("0") & _
            '                    "  Isotope Value=" & s


            IdentiFinder.IdentifyElements()
        Else
            StatusLabel2.Text = ""
        End If
        TimerDraw.Interval = 100 ' show changes immediately
    End Sub



    ' ================================================================================================
    '   SAVE INI ON LOST-FOCUS
    ' ================================================================================================
    Private Sub Properties_LostFocus(ByVal sender As Object, _
                                     ByVal e As System.EventArgs) Handles txt_AudioGain.LostFocus, _
                                                                          txt_AudioZero.LostFocus, _
                                                                          chk_BltEnable.LostFocus, _
                                                                          txt_BLT_Position.LostFocus, _
                                                                          txt_BLT_Size.LostFocus, _
                                                                          txt_BLT_MaxSlope.LostFocus, _
                                                                          txt_BLT_MaxNoise.LostFocus, _
                                                                          txt_IntegrationTime.LostFocus, _
                                                                          txt_DrawSpeed.LostFocus, _
                                                                          txt_MinEnergy.LostFocus, _
                                                                          txt_IIR_Filter.LostFocus, _
                                                                          chk_ExportWithHeader.LostFocus, _
                                                                          txt_DecimalSeparator.LostFocus, _
                                                                          txt_FieldSeparator.LostFocus, _
                                                                          txt_SlotCounter.LostFocus, _
                                                                          txt_BinsFirstSlot.LostFocus, _
                                                                          txt_BinsNumSlots.LostFocus, _
                                                                          chk_OnlySelectedRows.LostFocus, _
                                                                          txt_StopTimer.LostFocus, _
                                                                          txt_XlogExponent.LostFocus, _
                                                                          txt_YlogExponent.LostFocus, _
                                                                          chk_ResCompEnable.LostFocus, _
                                                                          txt_ResCompSize.LostFocus, _
                                                                          txt_ResCompCenter.LostFocus, _
                                                                          txt_ResCompLeft.LostFocus, _
                                                                          txt_ResCompRight.LostFocus, _
                                                                          chk_GaussianDecEnable.LostFocus, _
                                                                          txt_DeconvSize.LostFocus, _
                                                                          txt_GaussianSize.LostFocus, _
                                                                          chk_ThickLines.LostFocus, _
                                                                          txt_UserText.LostFocus, _
                                                                          btn_Xlog.LostFocus, _
                                                                          btn_Ylog.LostFocus, _
                                                                          tk_Zoom.LostFocus
        If Not EventsAreEnabled Then Return
        'IVmode = False : SaveLoad_INI()
    End Sub
    'btn_AutoSave.LostFocus, _
    'txt_AutoSave.LostFocus, _


    ' ================================================================================================
    '   OPERATION-TAB COMBO
    ' ================================================================================================
    Private Sub cmb_Bins_DropDown(ByVal sender As Object, ByVal e As System.EventArgs) Handles cmb_Bins.DropDown
        cmb_Bins.ItemHeight = 15
    End Sub
    Private Sub cmb_Sampling_DropDown(ByVal sender As Object, ByVal e As System.EventArgs) Handles cmb_Sampling.DropDown
        cmb_Sampling.ItemHeight = 15
    End Sub
    Private Sub cmb_PulsePolarity_DropDown(ByVal sender As Object, ByVal e As System.EventArgs) Handles cmb_PulsePolarity.DropDown
        cmb_PulsePolarity.ItemHeight = 15
    End Sub
    Private Sub cmb_Bins_DropDownClosed(ByVal sender As Object, ByVal e As System.EventArgs) Handles cmb_Bins.DropDownClosed
        If Not EventsAreEnabled Then Return
        cmb_Bins.ItemHeight = 11
        Set_Props()
        Form_Pulses.SetProps()
        Form_Equalizers.CreateLinearityCurve()
        ShowSelectedBinData()
        'AllBinsToZero()
        'IVmode = False : SaveLoad_INI()
        Label_Dummy.Focus()
    End Sub
    Private Sub cmb_Sampling_DropDownClosed(ByVal sender As Object, ByVal e As System.EventArgs) Handles cmb_Sampling.DropDownClosed
        If Not EventsAreEnabled Then Return
        cmb_Sampling.ItemHeight = 11
        Set_Props()
        StartAudioReader()
        'IVmode = False : SaveLoad_INI()
        Label_Dummy.Focus()
    End Sub
    Private Sub cmb_PulsePolarity_DropDownClosed(ByVal sender As Object, ByVal e As System.EventArgs) Handles cmb_PulsePolarity.DropDownClosed
        If Not EventsAreEnabled Then Return
        cmb_PulsePolarity.ItemHeight = 11
        Set_Props()
        'IVmode = False : SaveLoad_INI()
        Label_Dummy.Focus()
    End Sub
    'Private Sub txt_InputDevice_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs)
    '    If Not EventsAreEnabled Then Return
    '    Dim devCount As Int32 = WaveNative.InputDevicesCount
    '    If txt_InputDevice.NumericValueInteger >= devCount Then
    '        txt_InputDevice.NumericValueInteger = devCount - 1
    '    End If
    '    Set_Props()
    '    StartAudioReader()
    '    'IVmode = False : SaveLoad_INI()
    'End Sub
    Private Sub StartAudioReader()
        If WaveRec.RecordStart() Then
            GroupBox_AudioInput.BackColor = GroupBox_OutputSlots.BackColor
        Else
            GroupBox_AudioInput.BackColor = Color.OrangeRed
        End If
    End Sub

    ' ===================================================================================================
    '  SELECT AUDIO INPUT 
    ' ===================================================================================================
    Friend SelectedAudioIn As Int32 = 0
    Private Sub cmb_AudioInDevices_DropDown(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmb_AudioInDevices.DropDown
        cmb_AudioInDevices.ItemHeight = 16
        FillAudioInDevicesCombo()
    End Sub
    Private Sub cmb_AudioInDevices_DropDownClosed(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmb_AudioInDevices.DropDownClosed
        cmb_AudioInDevices.ItemHeight = 11
        SelectedAudioIn = cmb_AudioInDevices.SelectedIndex
        Set_Props()
        StartAudioReader()
        IVmode = False : SaveLoad_INI()
    End Sub
    Private Sub FillAudioInDevicesCombo()
        Dim sa As String() = WaveNative.GetInputDevicesNames
        If sa.Length = 0 Then ReDim sa(0)
        cmb_AudioInDevices.Items.Clear()
        For i As Int32 = 0 To sa.Length - 1
            cmb_AudioInDevices.Items.Add(ExtractDeviceName(sa(i)))
        Next
        Combo_SetIndex(cmb_AudioInDevices, SelectedAudioIn)
    End Sub
    Private Function ExtractDeviceName(ByVal s As String) As String
        If s = Nothing Then Return ""
        Dim i As Int32 = InStr(s, "(") - 1
        If i > 1 Then s = s.Remove(i)
        Return s.Trim
    End Function


    ' ================================================================================================
    '   OPERATION-TAB PROPERTIES
    ' ================================================================================================
    Private Sub txt_AudioGain_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles txt_AudioGain.TextChanged
        If Not EventsAreEnabled Then Return
        AllBinsToZero()
        Set_Props()
    End Sub
    Private Sub txt_AudioZero_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles txt_AudioZero.TextChanged
        If Not EventsAreEnabled Then Return
        Set_Props()
    End Sub

    Private Sub chk_BlrEnable_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles chk_BltEnable.CheckedChanged
        If Not EventsAreEnabled Then Return
        Set_Props()
    End Sub
    Private Sub txt_Blr_Position_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles txt_BLT_Position.TextChanged
        If Not EventsAreEnabled Then Return
        WaveRec.InvalidatePulsePicture()
        Set_Props()
    End Sub
    Private Sub txt_Blr_Size_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles txt_BLT_Size.TextChanged
        If Not EventsAreEnabled Then Return
        WaveRec.InvalidatePulsePicture()
        Set_Props()
    End Sub
    Private Sub txt_MaxSlope_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles txt_BLT_MaxSlope.TextChanged
        If Not EventsAreEnabled Then Return
        Set_Props()
    End Sub
    Private Sub txt_MaxNoise_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles txt_BLT_MaxNoise.TextChanged
        If Not EventsAreEnabled Then Return
        Set_Props()
    End Sub

    Private Sub txt_IntegrationTime_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles txt_IntegrationTime.TextChanged
        If Not EventsAreEnabled Then Return
        'AllBinsToZero()
        Set_Props()
    End Sub
    Private Sub txt_DrawSpeed_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles txt_DrawSpeed.TextChanged
        If Not EventsAreEnabled Then Return
        Set_Props()
    End Sub
    Private Sub txt_MinEnergy_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles txt_MinEnergy.TextChanged
        If Not EventsAreEnabled Then Return
        Dim mbv As Single = 1
        For i As Integer = 0 To 3
            'If Spectrometer.UseReference(i) Then
            For ii As Integer = Spectrometer.EnergyToBin(txt_MinEnergy.NumericValueInteger) To MAX_BIN_INDEX
                If mbv < Spectrometer.mReferences(i, ii) Then mbv = Spectrometer.mReferences(i, ii)
            Next
            Spectrometer.mRefMaxBinValue(i) = mbv
            mbv = 1
        Next
        Set_Props()
    End Sub
    Private Sub txt_IIR_Filter_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles txt_IIR_Filter.TextChanged
        If Not EventsAreEnabled Then Return
        Set_Props()
    End Sub

    ' ================================================================================================
    '   OPTION-TAB PROPERTIES
    ' ================================================================================================
    Private Sub txt_SlotCounterOut_TextChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles txt_SlotCounter.TextChanged
        If Not EventsAreEnabled Then Return
        Set_Props()
    End Sub
    Private Sub txt_BinsFirstSlot_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles txt_BinsFirstSlot.TextChanged
        If Not EventsAreEnabled Then Return
        Set_Props()
    End Sub
    Private Sub txt_BinsNumSlots_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles txt_BinsNumSlots.TextChanged
        If Not EventsAreEnabled Then Return
        Set_Props()
    End Sub
    Private Sub chk_OnlySelectedRows_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles chk_OnlySelectedRows.CheckedChanged
        If Not EventsAreEnabled Then Return
        Set_Props()
    End Sub
    Private Sub txt_StopTimer_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles txt_StopTimer.TextChanged
        '
    End Sub
    Private Sub txt_XlogExponent_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles txt_XlogExponent.TextChanged
        If Not EventsAreEnabled Then Return
        Set_Props()
    End Sub
    Private Sub txt_YlogExponent_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles txt_YlogExponent.TextChanged
        If Not EventsAreEnabled Then Return
        Set_Props()
    End Sub
    Private Sub chk_ThickLines_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles chk_ThickLines.CheckedChanged
        If Not EventsAreEnabled Then Return
        Set_Props()
    End Sub
    Private Sub chk_ResCompEnable_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles chk_ResCompEnable.CheckedChanged
        If Not EventsAreEnabled Then Return
        Set_Props()
    End Sub
    Private Sub txt_ResCompSize_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles txt_ResCompSize.TextChanged
        If Not EventsAreEnabled Then Return
        Set_Props()
    End Sub
    Private Sub txt_ResCompCenter_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles txt_ResCompCenter.TextChanged
        If Not EventsAreEnabled Then Return
        Set_Props()
    End Sub
    Private Sub txt_ResCompLeft_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles txt_ResCompLeft.TextChanged
        If Not EventsAreEnabled Then Return
        Set_Props()
    End Sub
    Private Sub txt_ResCompRight_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles txt_ResCompRight.TextChanged
        If Not EventsAreEnabled Then Return
        Set_Props()
    End Sub
    Private Sub chk_GaussianDecEnable_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles chk_GaussianDecEnable.CheckedChanged
        If Not EventsAreEnabled Then Return
        If chk_GaussianDecEnable.Checked Then
            MessageBox.Show(Lc("DeconvolutionWarning"), "Warning", MessageBoxButtons.OK, MessageBoxIcon.Information)
        End If
        Set_Props()
    End Sub
    Private Sub txt_DeconvSize_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles txt_DeconvSize.TextChanged
        If Not EventsAreEnabled Then Return
        Set_Props()
    End Sub
    Private Sub txt_GaussianSize_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles txt_GaussianSize.TextChanged
        If Not EventsAreEnabled Then Return
        Set_Props()
    End Sub

    Private Sub TabControl1_SelectedIndexChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles TabControl1.SelectedIndexChanged
        TabControl1_Resize()
    End Sub

    Private Sub TabControl1_Resize()
        Select Case TabControl1.SelectedIndex
            Case 0
                TabControl1.Height = GroupBox_Params.Bottom + 28
                txt_UserText.Visible = True
            Case 1
                TabControl1.Height = GroupBox_GaussianDec.Bottom + 28
                txt_UserText.Visible = False
            Case 2
                TabControl1.Height = 520
                txt_UserText.Visible = False
        End Select
        TabControl1.Refresh()
    End Sub


    ' ================================================================================================
    '   Controls
    ' ================================================================================================
    Private Sub btn_SaveAsBkg_ClickButtonArea(ByVal Sender As System.Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles btn_SaveAsBkg.MouseClick
        If e.Button = Windows.Forms.MouseButtons.Right Then
            Spectrometer.SaveReference(0) = True
            btn_UseBkg.Enabled = True
            Ref_right(0) = True
        End If
    End Sub
    Private Sub btn_SaveAsBkg_CheckedChanged(ByVal Sender As System.Object, ByVal e As System.EventArgs) Handles btn_SaveAsBkg.CheckedChanged
        set_RefButton(0, btn_SaveAsBkg.Checked)
    End Sub
    Private Sub btn_UseBkg_CheckedChanged(ByVal Sender As Object, ByVal e As System.EventArgs) Handles btn_UseBkg.CheckedChanged
        Spectrometer.BKGsubtraction = btn_UseBkg.Checked
        Spectrometer.UseReference(0) = Not btn_UseBkg.Checked
        btn_SaveAsBkg.Checked = Not btn_UseBkg.Checked
        Form_BSpectrum.btn_BS_UseBKG.Checked = btn_UseBkg.Checked
        TimerDraw.Interval = 100
    End Sub
    ' ------------------------------------------------------------------------------------------
    '  Right button on Ref1,2,3 and BKG saves current data
    ' ------------------------------------------------------------------------------------------
    Private Ref_right() As Boolean = {False, False, False, False}
    Private Sub btn_Reference1_MouseClick(ByVal sender As Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles btn_Reference1.MouseClick
        If e.Button = Windows.Forms.MouseButtons.Right Then
            Spectrometer.SaveReference(1) = True
            Ref_right(1) = True
            If Form_BSpectrum.BS_Ref = 1 Then Form_BSpectrum.btn_BS_ShowHide.Checked = True
        End If
    End Sub
    Private Sub btn_Reference2_MouseClick(ByVal sender As Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles btn_Reference2.MouseClick
        If e.Button = Windows.Forms.MouseButtons.Right Then
            Spectrometer.SaveReference(2) = True
            Ref_right(2) = True
            If Form_BSpectrum.BS_Ref = 2 Then Form_BSpectrum.btn_BS_ShowHide.Checked = True
        End If
    End Sub
    Private Sub btn_Reference3_MouseClick(ByVal sender As Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles btn_Reference3.MouseClick
        If e.Button = Windows.Forms.MouseButtons.Right Then
            Spectrometer.SaveReference(3) = True
            Ref_right(3) = True
            If Form_BSpectrum.BS_Ref = 3 Then Form_BSpectrum.btn_BS_ShowHide.Checked = True
        End If
    End Sub
    ' ------------------------------------------------------------------------------------------
    '  enable disable references
    ' ------------------------------------------------------------------------------------------
    Private Sub set_RefButton(ByVal n As Integer, ByRef Checked As Boolean)
        If (Not Spectrometer.mReferenceValid(n) And Not Spectrometer.SaveReference(n)) Or (n = 0 And btn_UseBkg.Checked) Then
            Checked = False
        ElseIf (Ref_right(n) And Not Checked) Then
            Checked = True
        Else
            Spectrometer.UseReference(n) = Checked
            TimerDraw.Interval = 100
        End If
        Ref_right(n) = False
        If Form_BSpectrum.BS_Ref = n Then Form_BSpectrum.btn_BS_ShowHide.Checked = Checked
    End Sub

    Private Sub btn_Reference1_CheckedChanged(ByVal Sender As Object, ByVal e As System.EventArgs) Handles btn_Reference1.CheckedChanged
        set_RefButton(1, btn_Reference1.Checked)
    End Sub
    Private Sub btn_Reference2_CheckedChanged(ByVal Sender As Object, ByVal e As System.EventArgs) Handles btn_Reference2.CheckedChanged
        set_RefButton(2, btn_Reference2.Checked)
    End Sub
    Private Sub btn_Reference3_CheckedChanged(ByVal Sender As Object, ByVal e As System.EventArgs) Handles btn_Reference3.CheckedChanged
        set_RefButton(3, btn_Reference3.Checked)
    End Sub
    Private Sub btn_Xlog_CheckedChanged(ByVal Sender As Object, ByVal e As System.EventArgs) Handles btn_Xlog.CheckedChanged
        If Not EventsAreEnabled Then Return
        Set_Props()
    End Sub
    Private Sub btn_Ylog_CheckedChanged(ByVal Sender As Object, ByVal e As System.EventArgs) Handles btn_Ylog.CheckedChanged
        If Not EventsAreEnabled Then Return
        Set_Props()
    End Sub
    Private Sub tk_Zoom_Scroll(ByVal sender As Object, ByVal e As System.EventArgs) Handles tk_Zoom.Scroll, txt_Zoom.TextChanged
        If Not EventsAreEnabled Or tk_Zoom.Value = txt_Zoom.NumericValueInteger Then Return
        If sender Is tk_Zoom Then
            txt_Zoom.NumericValue = tk_Zoom.Value
        Else
            tk_Zoom.Value = txt_Zoom.NumericValueInteger
        End If
        Set_Props()
        Form_Pulses.SetProps()
    End Sub

    Private Sub btn_MaxY_ClickButtonArea(ByVal Sender As System.Object, ByVal e As System.EventArgs) Handles btn_MaxY.ClickButtonArea
        If Not EventsAreEnabled Then Return
        Set_Props()
    End Sub
    Private Sub txt_ManualScaleY_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles txt_MaxY.TextChanged, tk_MaxY.Scroll
        If Not EventsAreEnabled Or txt_MaxY.NumericValue = tknum2(tk_MaxY.Value \ 3) Then Return
        'Spectrometer.mDBG = sender.ToString & vbCrLf & e.ToString & vbCrLf
        If sender Is tk_MaxY Then
            txt_MaxY.NumericValue = tknum2(tk_MaxY.Value \ 3)
            'Spectrometer.mDBG &= (tknum2(tk_MaxY.Value \ 3)).ToString
            'Spectrometer.mDBG &= (tk_MaxY.Value \ 3).ToString & " .A.A. " '& (tknum2Rev(txt_MaxY.NumericValueInteger) * 3).ToString
            EventsAreEnabled = False
            tknum2Rev(txt_MaxY.NumericValueInteger)
            EventsAreEnabled = True
        Else
            Dim n As Integer = CInt(Mid(txt_MaxY.Text, 1, 1))
            Dim dx As Integer = txt_MaxY.Text.Length - 3
            Dim maxy As Integer = txt_MaxY.NumericValueInteger
            If n > 1 Then
                dx += 1
            End If
            If dx < 0 Then dx = 0
            dx = CInt(10 ^ dx)
            maxy = (maxy \ dx) * dx
            EventsAreEnabled = False
            If txt_MaxY.NumericValueInteger > 200 Then
                If txt_MaxY.Text.EndsWith("9") Then
                    txt_MaxY.NumericValueInteger = maxy
                ElseIf txt_MaxY.Text.EndsWith("1") Then
                    maxy += dx
                    txt_MaxY.NumericValueInteger = maxy
                End If
            End If
            txt_MaxY.NumericValueInteger = maxy
            tk_MaxY.Value = tknum2Rev(txt_MaxY.NumericValueInteger) * 3
            'Spectrometer.mDBG &= vbCrLf & x.ToString & " .B.B. " & txt_MaxY.Text & " --- " & maxy & " , " & dx & vbCrLf
        End If
        EventsAreEnabled = True
        Set_Props()
    End Sub
    Function tknum2(ByVal n As Integer) As Integer
        Dim d As Integer = n Mod 18
        n = CInt(10 ^ (n \ 18))
        If d > 9 Then
            Return n * 10 * (d - 8)
        Else
            Return n * 10 + (d * n)
        End If
    End Function
    Function tknum2Rev(ByVal n As Integer) As Integer
        If n <= 20 Then
            Return n - 9
        End If
        Dim dx As Integer
        Dim d As Integer
        Dim da As Integer = 0
        dx = CInt(10 ^ (n.ToString.Length - 1))
        If Mid(n.ToString, 1, 1) = "1" Then
            dx \= 10
            da = 9
        End If
        'Spectrometer.mDBG &= "dx=" & dx.ToString & ", n=" & n.ToString & vbCrLf
        n = (n \ dx) * dx
        d = CInt(Mid(n.ToString, 1, 1))
        Dim dd As Integer = CInt(Mid(n.ToString, 2, 1))
        n = CInt(Math.Log10(n / d)) - 1
        'Spectrometer.mDBG &= "d=" & d.ToString & ", dd=" & dd.ToString & ", n=" & n.ToString & vbCrLf & ((n * 18) + d + dd + 8 - da).ToString
        Return (n * 18) + d + dd + 8 - da
    End Function
    Function tknum(ByVal n As Integer) As Integer ' --- Not used, for now ---
        Dim d As Integer = n Mod 9
        n = CInt(10 ^ (n \ 9 + 1))
        Return n * (d + 1)
    End Function
    Function tknumRev(ByVal n As Integer) As Integer ' --- Not used, for now ---
        Dim d As Integer = CInt(Mid(n.ToString, 1, 1))
        n = CInt(Math.Log10(n / d)) - 1
        Return (n * 9) + d
    End Function

    Private Sub tk_EqMaster_Scroll(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles tk_EqMaster.Scroll, txt_EqMaster.TextChanged
        If Not EventsAreEnabled Or tk_EqMaster.Value = txt_EqMaster.NumericValueInteger Then Return
        If sender Is tk_EqMaster Then
            If MouseButtonLeftPressed() Then
                LockTrackbar(sender)
            End If
            txt_EqMaster.NumericValue = tk_EqMaster.Value
        Else
            tk_EqMaster.Value = txt_EqMaster.NumericValueInteger
        End If
        Form_Equalizers.CreateHeightCurve()
        TimerDraw.Interval = 100 ' show changes immediately
    End Sub
    Private Sub tk_EqMaster_MouseDown(ByVal sender As Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles tk_EqMaster.MouseDown
        If Not EventsAreEnabled Then Return
        If MouseButtonRightPressed() Then
            'CType(sender, TrackBar).Value = 0
            txt_EqMaster.NumericValue = 0
        End If
        'Form_Equalizers.CreateHeightCurve()
        'TimerDraw.Interval = 100 ' show changes immediately
    End Sub
    Private Sub tk_EqMaster_ValueChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles tk_EqMaster.ValueChanged
        ' do not test EventsAreEnabled here (to init colors)
        If Math.Abs(tk_EqMaster.Value) = 0 Then
            tk_EqMaster.BackColor = GroupBox_SpectrumData.BackColor
        Else
            tk_EqMaster.BackColor = HighlightColor
        End If
    End Sub
    Private Sub tk_LinMaster_Scroll(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles tk_LinMaster.Scroll, txt_LinMaster.TextChanged
        If Not EventsAreEnabled Or tk_LinMaster.Value = txt_LinMaster.NumericValueInteger Then Return
        If sender Is tk_LinMaster Then
            If MouseButtonLeftPressed() Then
                LockTrackbar(sender)
            End If
            txt_LinMaster.NumericValue = tk_LinMaster.Value
        Else
            tk_LinMaster.Value = txt_LinMaster.NumericValueInteger
        End If
        Form_Equalizers.CreateLinearityCurve()
        ShowSelectedBinData()
        Form_Pulses.SetProps()
        TimerDraw.Interval = 100 ' show changes immediately
    End Sub


    Private Sub Set_Props()
        If EventsAreEnabled Then Application.DoEvents()
        ' ---------------------------------------------------------------- audio in txt params 
        WaveRec.InputDevice = SelectedAudioIn
        WaveRec.AudioGain = CSng(txt_AudioGain.NumericValue)
        WaveRec.AudioZero = txt_AudioZero.NumericValueInteger
        ' ---------------------------------------------------------------- audio in combo params
        BinFactor = CSng(Val(Mid(cmb_Bins.Text, 2)))
        If Spectrometer.SetNumBins(CInt(1024 * BinFactor)) Then
            Log("Set_Props: cmb_bin=" & BinFactor)
            AllBinsToZero()
        End If
        WaveRec.BinMultiplier = Spectrometer.GetNumBins / 25000.0F
        Spectrometer.LastAudioCardBin = CInt(Spectrometer.MillivoltToBin(1000 * WaveRec.AudioGain) - 1)
        'If WaveRec.Enabled Then Spectrometer.LastDataBin = Spectrometer.LastAudioCardBin
        Spectrometer.LastDataBin = Spectrometer.LastAudioCardBin
        If Spectrometer.LastDataBin > MAX_BIN_INDEX Then Spectrometer.LastDataBin = MAX_BIN_INDEX

        WaveRec.SamplesPerSec = CInt(Val(cmb_Sampling.Text))
        AutoPolarityTest = cmb_PulsePolarity.Text = "Auto"
        If cmb_PulsePolarity.Text = "Pos." Then WaveRec.NegPulses = False
        If cmb_PulsePolarity.Text = "Neg." Then WaveRec.NegPulses = True
        ' ---------------------------------------------------------------- params
        IntegrationTime = CULng(txt_IntegrationTime.NumericValue)
        IntegrationFactor = CalcIntegrationFactor(IntegrationTime, 9.825, 1)
        TickAlpha = CSng(1 - 0.3 / IntegrationTime)
        Spectrometer.MinEnergy = txt_MinEnergy.NumericValueInteger
        Spectrometer.Filter = txt_IIR_Filter.NumericValueInteger
        ' ---------------------------------------------------------------- base line restoring
        If chk_BltEnable.Checked Then
            WaveRec.BLT_Enable = True
            txt_BLT_Position.Enabled = True
            txt_BLT_Size.Enabled = True
            txt_BLT_MaxSlope.Enabled = True
            txt_BLT_MaxNoise.Enabled = True
            Label_AudioZero.Enabled = False
            txt_AudioZero.Enabled = False
        Else
            WaveRec.BLT_Enable = False
            txt_BLT_Position.Enabled = False
            txt_BLT_Size.Enabled = False
            txt_BLT_MaxSlope.Enabled = False
            txt_BLT_MaxNoise.Enabled = False
            Label_AudioZero.Enabled = True
            txt_AudioZero.Enabled = True
        End If
        WaveRec.BLT_Position_uS = txt_BLT_Position.NumericValueInteger()
        WaveRec.BLT_Size_uS = txt_BLT_Size.NumericValueInteger
        WaveRec.BLT_MaxSlope = txt_BLT_MaxSlope.NumericValueInteger
        WaveRec.BLT_MaxNoise = txt_BLT_MaxNoise.NumericValueInteger
        WaveRec.BLT_MaxSlopeAdjust = btn_BLT_MaxSlope.Checked
        ' ---------------------------------------------------------------- slots 
        Slot_Counter = txt_SlotCounter.NumericValueInteger
        Slot_BinsFirstSlot = txt_BinsFirstSlot.NumericValueInteger
        BinsNumSlots = txt_BinsNumSlots.NumericValueInteger
        If chk_OnlySelectedRows.Checked Then
            OnlySelectedRows = True
            txt_BinsNumSlots.Enabled = False
        Else
            OnlySelectedRows = False
            txt_BinsNumSlots.Enabled = True
        End If
        ' ---------------------------------------------------------------- scale options
        Spectrometer.XlogExponent = txt_XlogExponent.NumericValue
        Spectrometer.YlogExponent = txt_YlogExponent.NumericValue
        ' ---------------------------------------------------------------- graph
        Spectrometer.Xlog = btn_Xlog.Checked
        Spectrometer.Ylog = btn_Ylog.Checked
        Spectrometer.ThickLines = chk_ThickLines.Checked
        ' ---------------------------------------------------------------- resolution compensation
        Spectrometer.ResCompEnabled = chk_ResCompEnable.Checked
        Spectrometer.ResCompSize = txt_ResCompSize.NumericValueInteger
        Spectrometer.ResCompCenter = txt_ResCompCenter.NumericValueInteger
        Spectrometer.ResCompLeft = txt_ResCompLeft.NumericValueInteger
        Spectrometer.ResCompRight = txt_ResCompRight.NumericValueInteger
        ' ---------------------------------------------------------------- gaussian deconvolution
        Spectrometer.GaussianDecEnabled = chk_GaussianDecEnable.Checked
        Spectrometer.DeconvSize = txt_DeconvSize.NumericValueInteger
        Spectrometer.GaussianSize = txt_GaussianSize.NumericValueInteger
        ' ---------------------------------------------------------------- zoom
        Spectrometer.ScaleZoom = tk_Zoom.Value
        ' ---------------------------------------------------------------- show non-standard regulations
        If IntegrationMode Then
            txt_IntegrationTime.BackColor = Color.PeachPuff
            Label_TotalPulses.BackColor = Color.PeachPuff
            lbl_TotalPulses.BackColor = Color.PeachPuff
            Label_PulsesPerSec.BackColor = Color.PeachPuff
            lbl_PulsesPerSec.BackColor = Color.PeachPuff
        Else
            txt_IntegrationTime.BackColor = Color.AliceBlue
            Label_TotalPulses.BackColor = GroupBox_Info.BackColor
            lbl_TotalPulses.BackColor = Color.AliceBlue
            Label_PulsesPerSec.BackColor = GroupBox_Info.BackColor
            lbl_PulsesPerSec.BackColor = Color.AliceBlue
        End If
        If txt_AudioZero.NumericValueInteger <> 0 AndAlso Not chk_BltEnable.Checked Then
            Label_AudioZero.BackColor = HighlightColor
            txt_AudioZero.BackColor = HighlightColor
        Else
            Label_AudioZero.BackColor = GroupBox_Params.BackColor
            txt_AudioZero.BackColor = Color.AliceBlue
        End If
        ' ----------------------------------------------------------------
        If btn_MaxY.Checked Then
            txt_MaxY.Enabled = True
            Spectrometer.MaxY = txt_MaxY.NumericValueInteger
        Else
            txt_MaxY.Enabled = False
            Spectrometer.MaxY = 0
        End If
        ' ---------------------------------------------------------------- show changes immediately
        If TimerDraw.Interval > 100 Then TimerDraw.Interval = 100
        'Spectrometer.Draw()
    End Sub

    Friend Sub AllBinsToZero()
        For i As Int32 = 0 To WaveRec.Bins.Length - 1
            WaveRec.Bins(i) = 0
        Next
        TotalSeconds = 0
        tts = 0
        AutoSaveSeconds = 0
        WaveRec.TotalPulses = 0
        WaveRec.Scope_Clear()
        StartTime = Date.Now
        TotalTick = 0
        TickFactor = 1
        Tickbits = 0
        IntegrationSeconds = 0
    End Sub


    Friend TickFactor As Single = 1 ' Sum of  TickAlpha ^ (10Hz tick)
    Friend TickAlpha As Single = 1  ' (1-0.3/IntegrationTIme) 


    Friend Function CalcIntegrationFactor(ByVal it As Single, ByVal t As Single, _
                                      ByVal s As Single) As Single
        If False Then '----  Debug logging + screen monitor
            Spectrometer.mDBG = CInt(IntegrationSeconds) & " sec, " & t & " tick  " & vbCrLf & _
            (TotalTick / IntegrationSeconds).ToString("0.000") & " tick/s  " & _
            IntegrationFactor.ToString("0.0000") & "    " & TickFactor.ToString("0.0000")
            Log(Spectrometer.mDBG)
        End If
        If TotalSeconds = 0 Or IntegrationSeconds = 0 Then Return 1
        Return CSng(TickFactor / TotalSeconds / (TotalTick / IntegrationSeconds))
    End Function

    Friend tts As Single

    ' ================================================================================================
    '   TIMERS
    ' ================================================================================================
    Private Sub Timer1Sec_Tick(ByVal sender As Object, ByVal e As System.EventArgs) Handles Timer1Sec.Tick
        If Not WaveRec.Enabled Then Return
        ' --------------------------------------------------------------------- Totals
        TotalSeconds += 1UL
        Tickbits = 0
        AutoSaveSeconds += 1
        If IntegrationMode Then
            IntegrationSeconds += 1UI

            If TotalSeconds > IntegrationTime Then TotalSeconds = IntegrationTime

            Dim n As Single = 0
            For i As Int32 = Spectrometer.mFirstBinIndex To MAX_BIN_INDEX
                n += WaveRec.Bins(i)
            Next
            IntegrationFactor = CalcIntegrationFactor(IntegrationTime, TotalTick, TotalSeconds)
            ValidPulses = CULng(n / IntegrationFactor)
            Dim ts As ULong = TotalSeconds
            If ts = 0 Then ts = 1
            PulsesPerSec = CSng(ValidPulses / ts)
            lbl_PulsesPerSec.Text = PulsesPerSec.ToString("0.0")
        Else
            ValidPulses = Spectrometer.GetValidPulses
            PulsesPerSec = CSng(ValidPulses / (TotalSeconds - 0.5F))
            lbl_PulsesPerSec.Text = PulsesPerSec.ToString("0.0")
        End If
        lbl_TotalSeconds.Text = TotalSeconds.ToString
        lbl_TotalPulses.Text = ValidPulses.ToString
        ' --------------------------------------------------------------------- Audio test
        If SlowPeakMeter > 0.98 Then
            StatusLabel1.BackColor = Color.Orange
            StatusLabel1.TextAlign = ContentAlignment.MiddleCenter
            StatusLabel1.Text = Lc("TooMuchSignal")
        ElseIf SlowPeakMeter < 0.1 Then
            StatusLabel1.BackColor = Color.Orange
            StatusLabel1.TextAlign = ContentAlignment.MiddleCenter
            StatusLabel1.Text = Lc("NoAudioSignal")
        ElseIf SlowPeakMeter < 0.25 Then
            StatusLabel1.BackColor = Color.Orange
            StatusLabel1.TextAlign = ContentAlignment.MiddleCenter
            StatusLabel1.Text = Lc("TooLowSignal")
        Else
            StatusLabel1.BackColor = Color.LightYellow
            StatusLabel1.TextAlign = ContentAlignment.MiddleLeft
            StatusLabel1.Text = Lc("SignalIsOK")
        End If
        ' --------------------------------------------------------------------- Timers
        If txt_StopTimer.NumericValueInteger > 0 AndAlso _
            TotalSeconds >= txt_StopTimer.NumericValueInteger Then
            ToolStripButton_Run.Checked = False
            GroupBox_SpectrumData.Focus()
            Beep()
        End If
        ' --------------------------------------------------------------------- Experimental Autosave
        If btn_AutoSave.Checked = True AndAlso _
            AutoSaveSeconds >= txt_AutoSave.NumericValueInteger Then
            AutoSaveSeconds = 0
            AutoSaveFiles()
        End If
    End Sub

    Private SlowPeakMeter As Single
    Private PeakPolarity As Single
    Friend Tickbits As Integer = 0

    Private Sub Timer10Hz_Tick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Timer10Hz.Tick
        If ToolStripButton_Run.Checked Then
            ' --------------------------------------------------------------------- reduce counts by integration time
            Tickbits += 1
            If IntegrationMode Then
                TickFactor += CSng(TickAlpha ^ TotalTick)
                TotalTick += 1UI
                'Dim k As Single = 1 - 0.3F / IntegrationTime
                For i As Int32 = 0 To MAX_BIN_INDEX
                    WaveRec.Bins(i) = WaveRec.Bins(i) * TickAlpha ' 0.995F '- 0.02F
                Next
            End If
            ' --------------------------------------------------------------------- Slot counter
            If Slot_Counter >= 0 Then
                Slots.WriteSlot(Slot_Counter, WaveRec.Counter)
            End If
            ' --------------------------------------------------------------------- Slot bins
            If Slot_BinsFirstSlot >= 0 Then
                Dim slot As Int32 = Slot_BinsFirstSlot
                If OnlySelectedRows Then
                    Dim value As Single
                    For i As Int32 = 0 To Spectrometer.SelectedIsotopes.Length - 1
                        value = Spectrometer.mValues(Spectrometer.EnergyToBin(Spectrometer.SelectedIsotopes(i).Energy))
                        Slots.WriteSlot(slot, value / TotalSeconds / 2)
                        slot += 1
                    Next
                Else
                    Static OldCounts(999) As Single
                    Dim MacroBinSize As Int32 = (Spectrometer.mLastBinIndex - Spectrometer.mFirstBinIndex) \ BinsNumSlots
                    If MacroBinSize = 0 Then MacroBinSize = 1
                    Dim counter As Int32 = 0
                    Dim acc As Single = 0
                    For i As Int32 = Spectrometer.mFirstBinIndex To Spectrometer.mLastBinIndex
                        acc += WaveRec.Bins(i)
                        'acc += Spectrometer.mValues(i)
                        counter += 1
                        If counter >= MacroBinSize Then
                            '
                            Slots.WriteSlot(slot, acc - OldCounts(slot))
                            '
                            OldCounts(slot) = acc
                            slot += 1
                            counter = 0
                            acc = 0
                        End If
                    Next
                End If
            End If
            ' --------------------------------------------------------------------- Pulse polarity tester
            If AutoPolarityTest Then
                If WaveRec.PeakMeter_Positive > -WaveRec.PeakMeter_Negative * 0.9F Then
                    PeakPolarity += 1
                    If PeakPolarity > 1 Then PeakPolarity = 1
                Else
                    ' ------------------------------------------------ if enough signal
                    If WaveRec.PeakMeter_Negative < -1000 Then
                        PeakPolarity -= 1
                        ' -------------------------------------------- if polarity < -2 then change 
                        If PeakPolarity < -2 Then
                            PeakPolarity = -2
                            WaveRec.NegPulses = Not WaveRec.NegPulses
                            WaveRec.AudioZero = -WaveRec.AudioZero
                            txt_AudioZero.NumericValueInteger = WaveRec.AudioZero
                            'AllBinsToZero()
                        End If
                    End If
                End If
                ' ----------------------------------------------------------------- test
                'AudioIn.NegPulses = True
                'Text = PeakPolarity.ToString & "  " & _
                '        AudioIn.PeakMeter_Negative.ToString & "  " & _
                '        AudioIn.PeakMeter_Positive.ToString
                ' ----------------------------------------------------------------- clear PeakMmeter_Negative
                WaveRec.PeakMeter_Negative = 0
            End If

            ' --------------------------------------------------------------------- peak meter - ORIGINAL
            'Dim p As Single
            '' ---------------------------------------------- peak meter trimming
            'p = AudioIn.PeakMeter_Positive / 22000
            '' ---------------------------------------------- mean of peaks smoothing
            'MeanOfPeaks += (p - MeanOfPeaks) * 0.03F
            'If MeanOfPeaks > 1 Then MeanOfPeaks = 1
            '' ---------------------------------------------- show meter
            'VuMeter_Vertical(Pbox3, MeanOfPeaks)
            '' ---------------------------------------------- decay speed
            'AudioIn.PeakMeter_Positive -= 1000


            ' --------------------------------------------------------------------- peak meter - NEW
            Dim p As Single
            ' ---------------------------------------------- peak meter trimming
            If WaveRec.PeakMeter_Positive > 32767 Then
                WaveRec.PeakMeter_Positive = 32767
            End If
            p = WaveRec.PeakMeter_Positive / 32768

            ' ---------------------------------------------- logaritmic VuMeter -30dB to 0dB
            If p > 1 Then p = 1
            If p < 0.001 Then p = 0.001
            p = VoltToDecibel(p)
            p = 1 + p / 30

            ' ---------------------------------------------- slow peak meter
            If p > SlowPeakMeter Then
                SlowPeakMeter += (p - SlowPeakMeter) * 0.2F
            Else
                SlowPeakMeter -= 0.01F
            End If
            ' ---------------------------------------------- show meter
            VuMeter_Vertical(Pbox3, p, SlowPeakMeter)
            ' ---------------------------------------------- decay speed
            'AudioIn.PeakMeter_Positive -= 2000
            WaveRec.PeakMeter_Positive *= 0.9F

        Else
            VuMeter_Vertical(Pbox3, 0)
        End If
    End Sub

    Private Sub TimerDraw_Tick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles TimerDraw.Tick
        If Me.WindowState <> FormWindowState.Minimized Then
            'Dim sw1 As Diagnostics.Stopwatch = New Diagnostics.Stopwatch : sw1.Start()
            Spectrometer.Draw()
            'Text = (sw1.Elapsed.TotalMilliseconds * 1000).ToString("0")
            'Text = AudioIn.TimeMicrosec.ToString("AudioIn uS: 0")
            TimerDraw.Interval = 1000 \ txt_DrawSpeed.NumericValueInteger
        End If
    End Sub

    Private Sub Button_BrowseSpectrum(ByVal sender As System.Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles btn_BrowseSpectrum.MouseUp
        If True Then 'e.Button = MouseButtons.Right Then
            Form_BSpectrum.Visible = Not Form_BSpectrum.Visible
            btn_BrowseSpectrum.Checked = Form_BSpectrum.Visible
        Else
            ' Load and Show Spectrum from predetermined dir in predetermined order
            btn_BrowseSpectrum.Checked = Not btn_BrowseSpectrum.Checked
            If LoadHistogramFile(Form_BSpectrum.BS_Ref, "", True) Then
                Select Case Form_BSpectrum.BS_Ref
                    Case 1
                        btn_Reference1.Checked = True
                    Case 2
                        btn_Reference2.Checked = True
                    Case 3
                        btn_Reference3.Checked = True
                    Case 0
                        btn_UseBkg.Enabled = True
                        'btn_UseBkg.Checked = True
                        btn_SaveAsBkg.Checked = True
                End Select
            End If
        End If
    End Sub

    'Private Sub txt_BrowseSpectrum_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs)
    '     If Not EventsAreEnabled Then Return
    '    Form_BSpectrum.BS_IndexChanged(txt_BrowseSpectrum.NumericValueInteger)
    ' End Sub


    Private Sub txt_AutoSave_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles txt_AutoSave.TextChanged
        If Not EventsAreEnabled Then Return
        'txt_AutoSave.Text = Regex.Replace(txt_AutoSave.Text, "[^\d]", "")
        txt_AutoSave.Text = txt_AutoSave.NumericValueInteger.ToString()
    End Sub

    Private Sub btn_AutoSave_RightClick(ByVal sender As System.Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles btn_AutoSave.MouseUp
        If e.Button = MouseButtons.Right Then
            btn_AutoSave.Checked = Not btn_AutoSave.Checked
            If Not Form_AutoSave.Visible Then
                Form_AutoSave.ShowDialog(Me)
                Form_AutoSave.Select()
            End If
        End If
    End Sub

    Friend Sub AutoSaveFiles()
        Dim AutoSave_FileName As String
        AutoSave_FileName = AutoSave_Folder

        If Not AutoSave_FileName.EndsWith("\") Then
            AutoSave_FileName &= "\"
        End If
        AutoSave_FileName &= Translate_DT_Format(AutoSave_Format)
        AutoSave_FileName = CheckAndClean(AutoSave_FileName)
        Directory.CreateDirectory(Path.GetDirectoryName(AutoSave_FileName))

        Dim i As Integer
        For i = 0 To chk_List.Length - 1 ' Iterate array and execute checked Sub(s)
            If CStr(chk_List(i, AutoSave_lst.Name)) = "" Then
                Exit For
            End If

            If CBool(chk_ListBUF(i, AutoSave_lst.Checked)) Then
                AutoSave_sd(i).addr(AutoSave_FileName & "." & CStr(chk_List(i, AutoSave_lst.Ext)))
            End If
        Next

        If AutoSave_StartNew Then  'Start new measure if Checked
            AllBinsToZero()
        End If

        If AutoSave_ExecuteEnabled Then 'Execute any shell command if enabled
            Shell(AutoSave_Execute)
        End If
    End Sub

    Private Sub AutoSave_sd_Init()
        Dim i As Integer = 0
        Dim done As Boolean = False
        Try
            AutoSave_sd(i).addr = AddressOf AutoSaveHistogramFile
            i += 1
            AutoSave_sd(i).addr = AddressOf AutoSaveImageApplication
            i += 1
            AutoSave_sd(i).addr = AddressOf AutoSaveImageApplication
            i += 1
            AutoSave_sd(i).addr = AddressOf AutoSaveImageSpectrum
            i += 1
            AutoSave_sd(i).addr = AddressOf AutoSaveImageSpectrum
            i += 1
            AutoSave_sd(i).addr = AddressOf AutoSaveSpefile
            i += 1
            AutoSave_sd(i).addr = AddressOf dummy
            i += 1
            AutoSave_sd(i).addr = AddressOf dummy
            i += 1
            AutoSave_sd(i).addr = AddressOf dummy
            i += 1
            AutoSave_sd(i).addr = AddressOf dummy
            i += 1
            AutoSave_sd(i).addr = AddressOf dummy
            i += 1
        Catch ex As Exception
            'MsgBox("Initilization of AutoSave delegate failed at " & CStr(i) & "   " & ex.Message)
        End Try
    End Sub


    Friend Sub dummy(ByVal s As String)
        'Do nothing
        MsgBox("dummy function (Not implemented yet) >>>" & s)
    End Sub

    ' Translate date-time format string enclosed in (  ) and $1, $2, etc
    Friend Function Translate_DT_Format(ByVal s As String) As String
        If s.Length() < 2 Then
            Return s
        End If
        Dim r As String = ""
        Dim f As Boolean = False
        Dim i As Integer = 0
        Dim c As String
        Dim ds As String = ""
        Do
            c = s.Substring(i, 1)
            If Not f Then  '  Not in paren.
                If c = "(" Then
                    f = True
                ElseIf c = "$" And i < s.Length() - 1 And IsNumeric(s.Substring(i + 1, 1)) Then
                    Dim si As Integer = CInt(s.Substring(i + 1, 1)) - 1
                    Dim st() As String = txt_UserText.Text.Split(CChar(vbNewLine))
                    If st.Length > si Then
                        r += st(si).Trim(CChar(vbNewLine)).Trim().Replace(" ", "_")
                    End If
                    i += 1
                Else
                    r &= c
                End If
            Else  ' In paren.
                If c = ")" Then
                    r &= Date.Now.ToString(ds)
                    f = False
                    ds = ""
                Else
                    ds &= c
                End If
            End If
            i += 1
        Loop Until (i = s.Length())
        Return r
    End Function

    Private Function CheckAndClean(ByVal StringToCheck As String) As String
        ' Eliminate characters that are not allowed in file/folder name
        Dim illegalCharsPattern As String = Path.GetInvalidPathChars()
        Dim r As Regex = New Regex(String.Format("[{0}]", Regex.Escape(illegalCharsPattern)))
        Return r.Replace(StringToCheck, "")
    End Function

    Private Function AssemblyLastWriteTime(ByVal a As Reflection.Assembly) As DateTime
        Try
            Return File.GetLastWriteTime(a.Location)
        Catch ex As Exception
            Return DateTime.MaxValue
        End Try
    End Function

    Private Sub Lc_Init() ' ----------------------------------  Locale dict initialization
        Lc.Add("TooLowSignal", "Too low Signal")
        Lc.Add("TooMuchSignal", "Too much signal")
        Lc.Add("NoAudioSignal", "No audio signal")
        Lc.Add("SignalIsOK", "Signal is OK")
        Lc.Add("Graph_Line", "Line")
        Lc.Add("Graph_Bar", "Bar")
        Lc.Add("Graph_Dot", "Dot")
        Lc.Add("Isotope_Name", "Name")
        Lc.Add("Isotope_Energy", "Energy")
        Lc.Add("MCA_input", "MCA input")
        Lc.Add("Audio_input", "Audio input")
        Lc.Add("DeconvolutionWarning", "Warning: if not properly used the deconvolution produces wrong results")
    End Sub

    Private Sub MyListView1_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles MyListView1.Click
        Spectrometer.IsotopeListChanged = True
        TimerDraw.Interval = 100 ' show changes immediately
    End Sub

    Private Sub MyListView1_MouseDoubleClick(ByVal sender As System.Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles MyListView1.MouseDoubleClick
        If IsotopeEditing Then
            Exit Sub
        End If
        If e.X < MyListView1.Location.X + 20 Then
            Exit Sub
        End If
        Dim item As ListViewItem = MyListView1.GetItemAt(e.X, e.Y)     ' which listviewitem was clicked
        If item Is Nothing Then
            Exit Sub
        End If
        IsotopeEditing = True
        With item
            .Selected = True
            .Checked = True
            If .SubItems(1).Text <> "" Then
                .Text &= "=" & .SubItems(1).Text.Replace(",", ".").Trim
            End If
            .BeginEdit()
        End With
    End Sub

    ' Isotope marker editing
    Private Sub MyListView1_AfterLabelEdit(ByVal sender As System.Object, ByVal e As System.Windows.Forms.LabelEditEventArgs) Handles MyListView1.AfterLabelEdit
        Dim s() As String = {"", ""}
        If e.Label Is Nothing Then
            MyListView1.Items(e.Item).Checked = False
        ElseIf e.Label.Contains("=") Then
            s = e.Label.Split(CChar("="))
            If Not IsNumeric(s(1)) Then s(1) = ""
            MyListView1.Items(e.Item).SubItems(1).Text = s(1).Replace(",", ".").Trim
            MyListView1.Items(e.Item).Text = s(0)
            MyListView1.Update()
        ElseIf e.Label = "" Then
            MyListView1.Items(e.Item).Text = ""
            MyListView1.Items(e.Item).SubItems(1).Text = ""
            MyListView1.Items(e.Item).Checked = False
        ElseIf IsNumeric(e.Label) Then
            MyListView1.Items(e.Item).SubItems(1).Text = e.Label.Replace(",", ".").Trim
        End If
        IsotopeEditing = False
        Spectrometer.IsotopeListChanged = True
        TimerDraw.Interval = 100 ' show changes immediately
    End Sub

    Private Sub MyListView1_ColumnClick(ByVal sender As System.Object, ByVal e As System.Windows.Forms.ColumnClickEventArgs) Handles MyListView1.ColumnClick
        If IsotopeEditing Then Exit Sub
        If e.Column = 0 Then
            MyListView1.ListViewItemSorter = Isotopes.DefaultComparer
        Else
            MyListView1.ListViewItemSorter = Isotopes.EnergyComparer
        End If
        MyListView1.Sort()
    End Sub

    Private Sub MyListView1_ItemSelectionChanged(ByVal sender As System.Object, ByVal e As System.Windows.Forms.ListViewItemSelectionChangedEventArgs) Handles MyListView1.ItemSelectionChanged
        If IsotopeEditing And e.IsSelected Then
            e.Item.Selected = False
        End If
    End Sub

    Private Sub btn_cps_CheckedChanged(ByVal Sender As System.Object, ByVal e As System.EventArgs) Handles btn_cps.CheckedChanged
        If btn_cps.Checked Then
            txt_MaxY.NumericValue = txt_MaxY.NumericValue / TotalSeconds * 1000
        Else
            txt_MaxY.NumericValue = txt_MaxY.NumericValue * TotalSeconds / 1000
        End If
    End Sub

    Private Sub btn_Graph_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btn_Graph.Click
        Spectrometer.mGraphType += 1
        If Spectrometer.mGraphType > 2 Then Spectrometer.mGraphType = 0
        set_btn_Graph_Lang(Spectrometer.mGraphType)
        If TimerDraw.Interval > 100 Then TimerDraw.Interval = 100
    End Sub

    Friend Sub set_btn_Graph_Lang(ByVal n As Integer)
        Select Case n
            Case 0
                btn_Graph.Text = Lc("Graph_Line")
            Case 1
                btn_Graph.Text = Lc("Graph_Bar")
            Case 2
                btn_Graph.Text = Lc("Graph_Dot")
        End Select
    End Sub

    Private Sub btn_Integration_CheckedChanged(ByVal Sender As System.Object, ByVal e As System.EventArgs) Handles btn_IntegrationTime.CheckedChanged
        If Not EventsAreEnabled Then Return
        IntegrationMode = btn_IntegrationTime.Checked
        'AllBinsToZero()
        Set_Props()
    End Sub

    Private Sub btn_MaxSlope_CheckedChanged(ByVal Sender As System.Object, ByVal e As System.EventArgs) Handles btn_BLT_MaxSlope.CheckedChanged
        Set_Props()
    End Sub

    Private Sub btn_IIRFilter_CheckedChanged(ByVal Sender As System.Object, ByVal e As System.EventArgs) Handles btn_IIR_Filter.CheckedChanged
        TimerDraw.Interval = 100
    End Sub

    Private Sub btn_InputSelection_ClickButtonArea(ByVal Sender As System.Object, ByVal e As System.EventArgs) Handles btn_InputSelection.ClickButtonArea
        btn_InputSelection_set()
    End Sub

    Private Sub btn_InputSelection_set()
        If btn_InputSelection.Checked Then
            btn_InputSelection.Text = Lc("MCA_input")
            Pbox3.Visible = False
            cmb_Sampling.Visible = False
            Label_Sampling.Visible = False
            cmb_PulsePolarity.Visible = False
            Label_PulsePolarity.Visible = False
            cmb_AudioInDevices.Visible = False
            txt_AudioGain.Visible = False
            Label_AudioGain.Visible = False
            txt_AudioZero.Visible = False
            Label_AudioZero.Visible = False
            WaveRec.Enabled = False
        Else
            btn_InputSelection.Text = Lc("Audio_input")
            Pbox3.Visible = True
            cmb_Sampling.Visible = True
            Label_Sampling.Visible = True
            cmb_PulsePolarity.Visible = True
            Label_PulsePolarity.Visible = True
            cmb_AudioInDevices.Visible = True
            txt_AudioGain.Visible = True
            Label_AudioGain.Visible = True
            txt_AudioZero.Visible = True
            Label_AudioZero.Visible = True
            WaveRec.Enabled = True
        End If
    End Sub

    Private Sub PaintVerticalText(ByVal sender As Object, ByVal e As PaintEventArgs) Handles Label_Vert1.Paint, _
                                                                                             Label_Vert2.Paint, _
                                                                                             Label_Vert3.Paint
        Dim c As Control = CType(sender, Control)
        e.Graphics.RotateTransform(-90)
        e.Graphics.DrawString(c.Tag.ToString, c.Font, New SolidBrush(c.ForeColor), _
                              -c.Height, 0, StringFormat.GenericDefault)
    End Sub


End Class



