﻿Public Class Form_Pulses

    Private Sub Form_Pulses_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        InitPictureboxImage(PBoxScope)
        WaveRec.Picture_Box = PBoxScope
        Timer1.Interval = 30
        Timer1.Start()
        InitSnap()
    End Sub
    Private Sub Form_Pulses_FormClosing(ByVal sender As Object, ByVal e As System.Windows.Forms.FormClosingEventArgs) Handles Me.FormClosing
        'Save_INI()
        Log("E: Form_Pulse.FormClosing")
        Me.Hide()
        e.Cancel = True
    End Sub
    'Private Sub Form_Pulses_Move(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Move
    '    If Not EventsAreEnabled Then Return
    'End Sub
    Private Sub Form_Pulses_Resize(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Resize
        If Not EventsAreEnabled Then Return
        If Me.WindowState = FormWindowState.Minimized Then Return
        InitPictureboxImage(PBoxScope)
        WaveRec.Picture_Box = PBoxScope
        WaveRec.Scope_ShowPulses()
        WaveRec.InvalidatePulsePicture()
    End Sub
    Private Sub Form_Pulses_ResizeEnd(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.ResizeEnd
        If Not EventsAreEnabled Then Return
        SetSnap()
    End Sub

    ' ===================================================================================
    '   ToolStrip Gradient
    ' ===================================================================================
    Private Sub ToolStrip1_Paint(ByVal sender As System.Object, ByVal e As System.Windows.Forms.PaintEventArgs) Handles ToolStrip1.Paint
        Dim bounds As New Rectangle(0, 0, _
                                    ToolStrip1.Width, ToolStrip1.Height)
        Dim brush As New Drawing2D.LinearGradientBrush(bounds, _
                                                       Color.White, _
                                                       Color.FromArgb(200, 200, 200), _
                                                       Drawing2D.LinearGradientMode.Vertical)
        e.Graphics.FillRectangle(brush, bounds)
    End Sub


    ' =======================================================================================
    '   SNAP WINDOW
    ' =======================================================================================
    Private SnapPosition As Int32 = 0
    ' --------------------------------------------------------------------- InitSmap must be calle from FormLoad
    Private Sub InitSnap()
        ' ---------------------------------- prepare snap params (timer will be disabled automatically)
        SnapMouseMoveTimer.Enabled = True
        TestSnap()
    End Sub
    ' --------------------------------------------------------------------- Start snap when clicking on TitleBar
    Protected Overrides Sub WndProc(ByRef m As Message)
        Const WM_NCLBUTTONDOWN As Integer = 161
        Const HTCAPTION As Integer = 2
        If m.Msg = WM_NCLBUTTONDOWN AndAlso m.WParam.ToInt32 = HTCAPTION Then
            Me.Select()
            Snap_MouseDown()
            Return
        End If
        MyBase.WndProc(m)
    End Sub
    ' --------------------------------------------------------------------- test snap positions
    Private Sub TestSnap()
        Dim newSnap As Int32 = 0
        If Math.Abs(Me.Left - Form_Main.Left) < 40 And Math.Abs(Me.Top - Form_Main.Bottom) < 40 Then newSnap = 1
        If Math.Abs(Me.Left - (Form_Main.Left + 400)) < 40 And Math.Abs(Me.Top - Form_Main.Bottom) < 40 Then newSnap = 2
        If Math.Abs(Me.Left - Form_Main.Right) < 40 And Math.Abs(Me.Top - Form_Main.Top) < 40 Then newSnap = 3
        If Math.Abs(Me.Left - Form_Main.Right) < 40 And Math.Abs(Me.Top - (Form_Main.Top + 320)) < 40 Then newSnap = 4
        If newSnap <> SnapPosition Then
            SnapPosition = newSnap
            If newSnap <> 0 Then
                SnapMouseMoveTimer.Enabled = False
                SetSnap()
            End If
        End If
    End Sub
    ' --------------------------------------------------------------------- set position to snap positions
    '    must be called from MainForm:DockAllWindows and from ResizeEnd
    ' -----------------------------------------------------------------------------------------------------
    Friend Sub SetSnap()
        If Form_Main.Left < -30000 Then Return
        Select Case SnapPosition
            Case 1 : Me.Left = Form_Main.Left : Me.Top = Form_Main.Bottom
            Case 2 : Me.Left = Form_Main.Left + 400 : Me.Top = Form_Main.Bottom
            Case 3 : Me.Left = Form_Main.Right : Me.Top = Form_Main.Top
            Case 4 : Me.Left = Form_Main.Right : Me.Top = Form_Main.Top + 320
        End Select
    End Sub
    ' --------------------------------------------------------------------- move the window with the mouse
    Private CursorStartPos As Point
    Private FormStartPos As Point
    Private WithEvents SnapMouseMoveTimer As Timer = New Timer
    Private Sub Snap_Form_Move(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Move
        If Not SnapMouseMoveTimer.Enabled Then Return
        LimitFormPosition(Me)
        TestSnap()
    End Sub
    Private Sub Snap_MouseDown()
        CursorStartPos = Cursor.Position
        FormStartPos = Me.Location
        SnapMouseMoveTimer.Interval = 15
        SnapMouseMoveTimer.Enabled = True
    End Sub
    Private Sub SnapMouseMoveTimer_Tick(ByVal sender As Object, ByVal e As System.EventArgs) Handles SnapMouseMoveTimer.Tick
        If MouseButtonLeftPressed() Then
            Me.Location = New Point(FormStartPos.X + Cursor.Position.X - CursorStartPos.X, _
                                    FormStartPos.Y + Cursor.Position.Y - CursorStartPos.Y)
        Else
            SnapMouseMoveTimer.Enabled = False
        End If
    End Sub



    ' =======================================================================================
    '   TOOLBAR
    ' =======================================================================================
    Private Sub ToolStripButton_SaveScopeImage_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ToolStripButton_SaveScopeImage.Click
        ToolStripButton_SaveScopeImage.Visible = False
        ToolStripButton_SaveScopeImage.Visible = True
        Me.Refresh()
        SaveImage("PULSE_SHAPE_", Me)
    End Sub
    Private Sub ToolStripButton_SaveScopeImage_MouseHover(ByVal sender As Object, ByVal e As System.EventArgs) Handles ToolStripButton_SaveScopeImage.MouseHover
        Me.Focus() ' with this the toolstrip responds always at the first click
    End Sub
    'Private Sub ToolStrip1_MouseHover(ByVal sender As Object, ByVal e As System.EventArgs) Handles ToolStrip1.MouseHover
    '    Me.Focus() ' with this the toolstrip responds always at the first click
    'End Sub


    ' ================================================================================================
    '   SAVE INI ON LOST-FOCUS
    ' ================================================================================================
    Private Sub Properties_LostFocus(ByVal sender As Object, _
                                     ByVal e As System.EventArgs) Handles txt_MaxEnergy.LostFocus, _
                                                                          txt_MinEnergy.LostFocus, _
                                                                          btn_Run.LostFocus, _
                                                                          btn_Normalized.LostFocus, _
                                                                          tk_SizeX.LostFocus, _
                                                                          tk_PosY.LostFocus, _
                                                                          tk_SizeY.LostFocus
        If Not EventsAreEnabled Then Return
        IVmode = False : SaveLoad_INI()
    End Sub


    ' ================================================================================================
    '   PROPS
    ' ================================================================================================
    Private Sub txt_MaxEnergy_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles txt_MaxEnergy.TextChanged
        If Not EventsAreEnabled Then Return
        txt_MaxEnergy.NumericValueInteger = hopstep(txt_MaxEnergy.NumericValueInteger, 100)
        SetProps()
    End Sub
    Private Sub txt_MinEnergy_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles txt_MinEnergy.TextChanged
        If Not EventsAreEnabled Then Return
        txt_MinEnergy.NumericValueInteger = hopstep(txt_MinEnergy.NumericValueInteger, 100)
        SetProps()
    End Sub
    Private Sub btn_Run_ClickButtonArea(ByVal Sender As System.Object, ByVal e As System.EventArgs) Handles btn_Run.ClickButtonArea
        btn_OneShot.Checked = False
        If btn_Run.Checked Then
            WaveRec.Scope_Clear()
        Else
            WaveRec.Scope_Stop()
        End If
        SetProps()
    End Sub
    Private Sub btn_OneShot_ClickButtonArea(ByVal Sender As System.Object, ByVal e As System.EventArgs) Handles btn_OneShot.ClickButtonArea
        btn_Run.Checked = False
        WaveRec.Scope_Clear()
    End Sub
    Private Sub btn_Normalize_ClickButtonArea(ByVal Sender As System.Object, ByVal e As System.EventArgs) Handles btn_Normalized.ClickButtonArea
        SetProps()
    End Sub
    Private Sub tk_SizeX_Scroll(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles tk_SizeX.Scroll
        SetProps()
    End Sub
    Private Sub tk_PosY_Scroll(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles tk_PosY.Scroll
        SetProps()
    End Sub
    Private Sub tk_SizeY_Scroll(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles tk_SizeY.Scroll
        SetProps()
    End Sub

    Friend Sub SetProps()
        'txt_MinEnergy.MaxValue = txt_MaxEnergy.NumericValueInteger - 1
        'txt_MaxEnergy.MinValue = txt_MinEnergy.NumericValueInteger + 1
        WaveRec.RejectedReasons = ""
        If WaveRec.Rejected > 0 Then
            btn_PV_S.Visible = True
            btn_PV_N.Visible = True
            btn_PV_B.Visible = True
            btn_PV_R.Visible = True
        Else
            btn_PV_S.Visible = False
            btn_PV_N.Visible = False
            btn_PV_B.Visible = False
            btn_PV_R.Visible = False
            WaveRec.RejectedReasons = ""
        End If
        If btn_PV_N.Checked Then WaveRec.RejectedReasons &= "N"
        If btn_PV_S.Checked Then WaveRec.RejectedReasons &= "S"
        If btn_PV_B.Checked Then WaveRec.RejectedReasons &= "B"
        If btn_PV_R.Checked Then WaveRec.RejectedReasons &= "R"
        Label_Range.Text = "From " & txt_MinEnergy.NumericValueInteger & " KeV to " & _
                (txt_MinEnergy.NumericValueInteger + txt_MaxEnergy.NumericValueInteger) & " KeV"
        WaveRec.MaxEnergy = txt_MaxEnergy.NumericValueInteger
        WaveRec.MinEnergy = txt_MinEnergy.NumericValueInteger
        WaveRec.SizeX = tk_SizeX.Value
        WaveRec.SizeY = tk_to_hopstep(tk_SizeY.Value)
        WaveRec.PosY = tk_PosY.Value
        WaveRec.Normalized = btn_Normalized.Checked
        If btn_Normalized.Checked Then
            tk_SizeY.Enabled = False
            tk_PosY.Enabled = False
        Else
            tk_SizeY.Enabled = True
            tk_PosY.Enabled = True
        End If
    End Sub


    ' ================================================================================================
    '   TIMER
    ' ================================================================================================
    Private Sub Timer1_Tick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Timer1.Tick
        WaveRec.Scope_ShowPulses()
    End Sub

    Private Sub btn_Rejected_CheckedChanged(ByVal Sender As System.Object, ByVal e As System.EventArgs)
        'WaveRec.Rejected = btn_Rejected.Checked
        'SetProps()
    End Sub

    Private Sub btn_Rejected_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btn_Rejected.Click
        If btn_Rejected.Text = "Both" Then
            btn_Rejected.Text = "Valid"
            btn_Rejected.TextShadow = Color.LightBlue
            WaveRec.Rejected = 0
        ElseIf btn_Rejected.Text = "Valid" Then
            btn_Rejected.Text = "Rejected"
            WaveRec.Rejected = 1
            btn_Rejected.TextShadow = Color.Orange
        Else
            btn_Rejected.Text = "Both"
            WaveRec.Rejected = 2
            btn_Rejected.TextShadow = Color.Yellow
        End If
        SetProps()
    End Sub

    Private Sub btn_PV_S_CheckedChanged(ByVal Sender As System.Object, ByVal e As System.EventArgs) Handles btn_PV_S.CheckedChanged
        SetProps()
    End Sub

    Private Sub btn_PV_N_CheckedChanged(ByVal Sender As System.Object, ByVal e As System.EventArgs) Handles btn_PV_N.CheckedChanged
        SetProps()
    End Sub

    Private Sub btn_PV_B_CheckedChanged(ByVal Sender As System.Object, ByVal e As System.EventArgs) Handles btn_PV_B.CheckedChanged
        SetProps()
    End Sub

    Private Sub btn_PV_R_CheckedChanged(ByVal Sender As System.Object, ByVal e As System.EventArgs) Handles btn_PV_R.CheckedChanged
        SetProps()
    End Sub
End Class