Module Module_FillBars


    Friend Sub VuMeter_Vertical(ByVal pbox As PictureBox, _
                                ByVal value As Double, _
                                Optional ByVal MarkPoint As Double = 0)

        If Not pbox.Visible Then Return

        If pbox.Image Is Nothing Then InitPictureboxImage(pbox)

        If value < 0 Then value = 0
        If value > 1 Then value = 1
        '
        Dim h As Int32 = pbox.ClientSize.Height + 1
        Dim w As Int32 = pbox.ClientSize.Width

        Dim r As Rectangle
        r.X = 0
        r.Y = 0
        r.Width = w
        r.Height = h \ 2 - 1 ' <--- (-1) to correct the vertical green line in the middle
        Dim b1 As Drawing2D.LinearGradientBrush = New Drawing2D.LinearGradientBrush(r, _
                                                                            Color.FromArgb(255, 200, 0), _
                                                                            Color.FromArgb(100, 255, 0), _
                                                                            Drawing2D.LinearGradientMode.Vertical)
        Dim b2 As Drawing2D.LinearGradientBrush = New Drawing2D.LinearGradientBrush(r, _
                                                                            Color.FromArgb(255, 0, 0), _
                                                                            Color.FromArgb(255, 200, 0), _
                                                                            Drawing2D.LinearGradientMode.Vertical)
        '


        Dim v As Int32 = CInt(value * h)
        Dim vmid As Int32 = CInt(h / 2) - 1 ' <--- (-1) to correct the vertical green line in the middle

        ' ----------------------------------------------------------- using "Graphics.FromImage" for best performance
        Dim g As Graphics = Graphics.FromImage(pbox.Image)

        If value <= 0.5 Then
            g.FillRectangle(b1, 0, h - v, w, h)
        Else
            g.FillRectangle(b1, 0, vmid - 1, w, h)
            g.FillRectangle(b2, 0, h - v, w, v - vmid - 1)
        End If
        Dim b As Brush = New SolidBrush(pbox.BackColor)
        g.FillRectangle(b, 0, 0, w, h - v)
        '
        ' ----------------------------------------------------------- mark line
        If MarkPoint > 0 Then
            v = CInt(MarkPoint * pbox.Height)
            g.DrawLine(Pens.Black, 0, h - v, w, h - v)
        End If
        '
        ' ----------------------------------------------------------- final refresh - no flickering
        pbox.Refresh()
    End Sub

End Module
