﻿Module Module_MatrixFunctions

    ' ---------------------------------------------------------------------------- 
    '   DETERMINANT - TYPE 5 - DOUBLE ARRAYS  
    '   Execution time with 25 rows: 170 uS (PC) to 220 uS (notebook)
    ' ----------------------------------------------------------------------------
    Public Function Determinant(ByVal Mat(,) As Double) As Double
        'Dim sw As Stopwatch = New Stopwatch
        'sw.Start()
        Dim Rows As Int32 = Mat.GetUpperBound(0)
        Dim Cols As Int32 = Mat.GetUpperBound(1)
        If Rows <> Cols Then
            Throw New Exception("Matrix should be a square matrix.")
        End If
        Dim k, k1, i, j As Int32
        Dim save As Double
        Dim ArrayK As Double
        Dim Det As Double = 1
        Dim DArray(,) As Double = CType(Mat.Clone(), Double(,))
        For k = 0 To Rows
            If DArray(k, k) = 0 Then
                j = k
                Do While ((j < Rows) And (DArray(k, j) = 0))
                    j = j + 1
                Loop
                If DArray(k, j) = 0 Then
                    Det = 0
                    Exit Function
                Else
                    For i = k To Rows
                        save = DArray(i, j)
                        DArray(i, j) = DArray(i, k)
                        DArray(i, k) = save
                    Next
                End If
                Det = -Det
            End If
            ArrayK = DArray(k, k)
            Det = Det * ArrayK
            If k < Rows Then
                k1 = k + 1
                For i = k1 To Rows
                    For j = k1 To Rows
                        DArray(i, j) = DArray(i, j) - DArray(i, k) * (DArray(k, j) / ArrayK)
                    Next
                Next
            End If
        Next
        'Form_Main.Text = (sw.Elapsed.TotalMilliseconds * 1000).ToString("0.0")
        Return Det
    End Function

End Module


