﻿
Imports System.Math
Imports System.Drawing.Imaging
Imports System.IO
Imports System.Collections.Generic
Imports System.Runtime.InteropServices


Module Module_SaveLoad

    Friend EventsAreEnabled As Boolean = False

    ' =======================================================================================================
    '   APP TITLE AND VERSION
    ' =======================================================================================================
    Friend Function AppTitleAndVersion(Optional ByVal Title As String = "") As String
        If Title = "" Then Title = Replace(My.Application.Info.AssemblyName, "_", " ")
        Dim s() As String = Split(My.Application.Info.Version.ToString, ".")
        If s(2) <> "0" Then
            Return Title & " - V" & s(0) & "." & s(1) & "." & s(2)
        Else
            Return Title & " - V" & s(0) & "." & s(1)
        End If
    End Function

    ' =======================================================================================================
    '   Files
    ' =======================================================================================================
    ' returns lower-case extension with initial dot
    Public Function GetExtension(ByVal str As String) As String
        On Error Resume Next
        Return LCase(IO.Path.GetExtension(str))
    End Function
    Public Function RemoveExtension(ByVal str As String) As String
        On Error Resume Next
        Return PlatformAdjustedFileName(IO.Path.GetDirectoryName(str) & "\" & IO.Path.GetFileNameWithoutExtension(str))
    End Function
    Public Function FileExists(ByVal fileName As String) As Boolean
        Return My.Computer.FileSystem.FileExists(fileName)
    End Function
    Public Function FolderExists(ByVal FolderName As String) As Boolean
        If FolderName.Length < 2 Then Return False
        FolderName = LCase(FolderName)
        Select Case FolderName
            Case "a:\", "b:\", "c:\", "d:\", "e:\", "f:\", "g:\", "h:\", "i:\", "j:\", "k:\"
                Return True
        End Select
        Return My.Computer.FileSystem.DirectoryExists(FolderName)
    End Function
    Public Function ValidFilename(ByVal s As String) As String
        s = Replace(s, "/", "_")
        s = Replace(s, "\", "_")
        s = Replace(s, ":", "_")
        s = Replace(s, "*", "_")
        s = Replace(s, "?", "_")
        s = Replace(s, """", "_")
        s = Replace(s, "<", "_")
        s = Replace(s, ">", "_")
        s = Replace(s, "|", "_")
        s = Replace(s, "@", "_")
        Return s
    End Function



    ' =======================================================================================
    '  FORM FUNCTIONS
    ' =======================================================================================
    Friend Sub LimitFormPosition(ByVal f As System.Windows.Forms.Form)
        If f.WindowState <> FormWindowState.Normal Then Return
        GetMaxScreenBounds()
        EnsureFormVisible(f)
        'EnsureFormCompletelyVisible(f)
    End Sub

    Private SB As Rectangle = New Rectangle(Integer.MaxValue, Integer.MaxValue, Integer.MinValue, Integer.MinValue)

    Private Sub GetMaxScreenBounds()
        For Each s As Screen In System.Windows.Forms.Screen.AllScreens
            SB = Rectangle.Union(SB, s.WorkingArea)
        Next
    End Sub

    'Private Sub EnsureFormCompletelyVisible(ByVal frm As Form)
    '    With frm
    '        .Width = Math.Min(.Width, SB.Width)         ' not more than a maximized window
    '        .Height = Math.Min(.Height, SB.Height)      ' not more than a maximized window
    '        .Width = Math.Max(.Width, 32)               ' at least 32x24
    '        .Height = Math.Max(.Height, 24)             ' at least 32x24
    '        .Left = Math.Min(.Left, SB.Right - .Width)  ' not beyond the right border
    '        .Top = Math.Min(.Top, SB.Bottom - .Height)  ' not beyond the bottom border
    '        .Left = Math.Max(.Left, SB.Left)            ' at least at the left border
    '        .Top = Math.Max(.Top, SB.Top)               ' at least at the top border
    '    End With
    'End Sub

    Private Sub EnsureFormVisible(ByVal frm As Form)
        With frm
            .Width = Math.Min(.Width, SB.Width)             ' not more than VIRTUALSCREEN dimensions
            .Height = Math.Min(.Height, SB.Height)          ' not more than VIRTUALSCREEN dimensions 
            .Width = Math.Max(.Width, 32)                   ' at least 32x24
            .Height = Math.Max(.Height, 24)                 ' at least 32x24
            .Left = Math.Min(.Left, SB.Right - 50)          ' not beyond right border - 50 pixels
            .Top = Math.Min(.Top, SB.Bottom - 100)          ' not beyond bottom border - 50 pixels
            .Left = Math.Max(.Left, SB.Left + 100 - .Width) ' at least at left border + 50 pixels
            .Top = Math.Max(.Top, SB.Top - 10)              ' at least at top border
        End With
    End Sub

    ' (The value of the RestoreBounds property is valid only 
    '   when the WindowState property of the Form class is not equal to Normal)
    Friend Function GetFormRectangle(ByVal frm As Form) As Rectangle
        Dim r As Rectangle
        If frm.WindowState = FormWindowState.Normal Then
            r = frm.Bounds
        Else
            r = frm.RestoreBounds
        End If
        Return r
    End Function


    ' ================================================================================================
    '  Private Read-Write functions
    ' ================================================================================================
    Private Function TabString(ByVal Name As String, _
                              Optional ByVal Value As Double = Double.NaN, _
                              Optional ByVal fmt As String = "") As String

        Dim nTab As Int32 = Math.Max(0, 22 - Name.Length)
        If Double.IsNaN(Value) Then
            Return Name
        Else
            Return Name & "=" & Strings.StrDup(nTab, " ") & Value.ToString(fmt)
        End If
    End Function
    Private Function TabString(ByVal Name As String, _
                                  ByVal Value As Boolean) As String

        Dim nTab As Int32 = Math.Max(0, 22 - Name.Length)

        Return Name & "=" & Strings.StrDup(nTab, " ") & Value.ToString
    End Function
    Private Function TabString(ByVal Name As String, _
                                ByVal Value As String) As String

        Dim nTab As Int32 = Math.Max(0, 22 - Name.Length)

        Return Name & "=" & Strings.StrDup(nTab, " ") & Value
    End Function
    Private Function TabStringOBJ(ByVal Name As String, _
                              Optional ByVal Value As Object = Nothing, _
                              Optional ByVal fmt As String = "") As String
        Dim nTab As Int32 = Math.Max(0, 22 - Name.Length)
        Dim sValue As String = Value.ToString
        If Value Is Nothing Then Return Name
        If sValue <> "@#$" Then Return Name & "=" & Strings.StrDup(nTab, " ") & sValue
        Return vbCrLf & Name & vbCrLf & "==========================================="
    End Function
    Private Function Val_Double(ByVal l As String) As Double
        Return Val(Replace(l, ",", "."))
    End Function
    Private Function MultilineToString(ByVal Name As String, _
                                  ByVal Value As String) As String

        Value = Value.Replace(vbCrLf, "%M")
        Return Name & "=" & Value
    End Function
    Private Function StringToMultiline(ByVal Value As String) As String
        Value = Value.Replace("%M", vbCrLf)
        Return Value
    End Function
    Friend Function ExtractParamName(ByRef s As String) As String
        ' ------------------------- Returns the first field from begin to the first "=" symbol
        ' -------------------------  and removes it from the string
        Dim i As Int32
        i = InStr(s, "=")
        If i > 0 Then
            ExtractParamName = Trim(Strings.Left(s, i - 1))
            s = Trim(Mid(s, i + 1))
        Else
            ExtractParamName = Trim(s)
            s = ""
        End If
    End Function
    Private Function AssemblyName() As String
        Return System.Reflection.Assembly.GetExecutingAssembly.GetName.Name
    End Function


    ' ==================================================================================================
    '  SAVE LOAD -- Program INI
    ' ==================================================================================================
    Friend Sub SaveConfigurationAs()
        Dim sfd As SaveFileDialog = New SaveFileDialog()
        sfd.DefaultExt = ".txt"
        sfd.AddExtension = True
        sfd.Filter = "Configuration file (*.txt)|*txt"
        'sfd.FileName = AssemblyName() & "_INI_" & Date.Now.ToString("yyyy_MM_dd_HH_mm_ss")
        sfd.FileName = "MCA_INI_" & Date.Now.ToString("yyyy_MM_dd_HH_mm_ss")
        If sfd.ShowDialog() = Windows.Forms.DialogResult.OK Then
            'Save_INI(sfd.FileName)
            IVmode = False : SaveLoad_INI(sfd.FileName)
        End If
    End Sub

    Friend Sub LoadConfiguration()
        Dim ofd As OpenFileDialog = New OpenFileDialog
        ofd.Filter = "Configuration file (*.txt)|*txt"
        If ofd.ShowDialog() = Windows.Forms.DialogResult.OK Then
            IVmode = True
            SaveLoad_INI(ofd.FileName)
        End If
    End Sub


    Friend Sub IV(ByVal s As String, Optional ByRef o As String = Nothing, Optional ByVal multiline As Boolean = False)

        If IVmode Then ' -------- Load
            If o Is Nothing Then Exit Sub
            IVLi = IVLK.IndexOf(s)
            If IVLi > 0 Then
                If multiline Then
                    o = StringToMultiline(IVLV(IVLi))
                Else
                    o = IVLV(IVLi)
                End If
                IVLK.RemoveAt(IVLi)
                IVLV.RemoveAt(IVLi)
            End If
        Else ' ---------------- Save
            If o Is Nothing Then
                IVf.WriteLine(s)
            Else
                If multiline Then
                    IVf.WriteLine(MultilineToString(s, o))
                Else
                    IVf.WriteLine(TabString(s, o))
                End If
            End If
        End If
    End Sub

    Friend Sub IV(ByVal s As String, ByRef c As MyComboBox)
        If IVmode Then
            If s.StartsWith("Form") And Not IVLoadall Then Exit Sub
            IVLi = IVLK.IndexOf(s)
            If IVLi > 0 Then
                Dim n As Int32 = CInt(Val(IVLV(IVLi)))
                If n >= 0 And n < c.Items.Count Then
                    c.SelectedIndex = n
                End If
                IVLK.RemoveAt(IVLi)
                IVLV.RemoveAt(IVLi)
            End If
        Else
            IVf.WriteLine(TabString(s, c.SelectedIndex.ToString))
        End If
    End Sub

    Friend Sub IV(ByVal s As String, ByRef o As Integer)
        If IVmode Then
            If s.StartsWith("Form") And Not IVLoadall Then Exit Sub
            IVLi = IVLK.IndexOf(s)
            If IVLi > 0 Then
                o = CInt(Val(IVLV(IVLi)))
                IVLK.RemoveAt(IVLi)
                IVLV.RemoveAt(IVLi)
            End If
        Else
            IVf.WriteLine(TabString(s, o.ToString))
        End If
    End Sub

    Friend Sub IV(ByVal s As String, ByRef o As Single)
        If IVmode Then
            If s.StartsWith("Form") And Not IVLoadall Then Exit Sub
            IVLi = IVLK.IndexOf(s)
            If IVLi > 0 Then
                o = CSng(Val(IVLV(IVLi).Replace(",", ".").Trim))
                IVLK.RemoveAt(IVLi)
                IVLV.RemoveAt(IVLi)
            End If
        Else
            IVf.WriteLine(TabString(s, o.ToString.Replace(",", ".")))
        End If
    End Sub

    Friend Sub IV(ByVal s As String, ByRef o As Double)
        If IVmode Then
            If s.StartsWith("Form") And Not IVLoadall Then Exit Sub
            IVLi = IVLK.IndexOf(s)
            If IVLi > 0 Then
                o = CDbl(Val(IVLV(IVLi)))
                IVLK.RemoveAt(IVLi)
                IVLV.RemoveAt(IVLi)
            End If
        Else
            IVf.WriteLine(TabString(s, o.ToString))
        End If
    End Sub

    Friend Sub IV(ByVal s As String, ByRef o As Boolean)
        If IVmode Then
            If s.StartsWith("Form") And Not IVLoadall Then Exit Sub
            IVLi = IVLK.IndexOf(s)
            If IVLi > 0 Then
                o = IVLV(IVLi) = "True"
                IVLK.RemoveAt(IVLi)
                IVLV.RemoveAt(IVLi)
            End If
        Else
            IVf.WriteLine(TabString(s, o))
        End If
    End Sub

    Friend Sub IV(ByVal s As String, ByRef o As Color)
        Dim ss As String
        If IVmode Then
            If s.StartsWith("Form") And Not IVLoadall Then Exit Sub
            IVLi = IVLK.IndexOf(s)
            If IVLi > 0 Then
                ss = IVLV(IVLi)
                If ss.Contains(",") Then
                    Dim sc() As String = ss.Split(CChar(","))
                    Dim scin(2) As Integer
                    For i As Integer = 0 To 2
                        scin(i) = CInt(sc(i).Trim())
                        If scin(i) < 0 Or scin(i) > 255 Then
                            scin(i) = 0
                            Log("Wrong color spec: " + s)
                        End If
                    Next
                    o = Color.FromArgb(scin(0), scin(1), scin(2))
                Else
                    o = Color.FromName(ss)
                End If
                If o.ToArgb = 0 Then
                    o = Color.Red
                    Log("Wrong color spec: " + s)
                End If
                IVLK.RemoveAt(IVLi)
                IVLV.RemoveAt(IVLi)
            End If
        Else
            ss = Mid(o.ToString, 8)
            ss = ss.Replace("]", "")
            If ss.StartsWith("A=") Then
                ss = Mid(ss, 10)
                ss = ss.Replace(" ", "")
                ss = ss.Replace("=", "")
                ss = ss.Replace("B", "")
                ss = ss.Replace("G", "")
            End If
            IVf.WriteLine(TabString(s, ss))
        End If
    End Sub

    Friend IVmode As Boolean = True '  True = Load(Read) , False Save(Write)
    Private IVf As System.IO.StreamWriter
    Private IVLK As List(Of String) = New List(Of String)
    Private IVLV As List(Of String) = New List(Of String)
    Private IVLi As Integer
    Private IVLoadall As Boolean

    Friend Sub SaveLoad_INI(Optional ByVal iniFileName As String = "")
        Dim mbi As Int32 = MAX_BIN_INDEX
        If IVmode Then ' ---------------------------------  Load Preparation
            IVLoadall = False
            If iniFileName = "" Then
                iniFileName = Application.StartupPath & "\" & AssemblyName() & "_INI.txt"
                IVLoadall = True
            End If
            iniFileName = PlatformAdjustedFileName(iniFileName)

            If My.Computer.FileSystem.FileExists(iniFileName) Then
                Dim f As System.IO.StreamReader
                f = IO.File.OpenText(iniFileName)
                Dim l As String
                Dim s As String
                Do While Not f.EndOfStream
                    l = f.ReadLine()
                    If InStr(l, "=") > 0 Then
                        s = ExtractParamName(l)
                        IVLK.Add(s)
                        IVLV.Add(l)
                    End If
                Loop
                f.Close()
            Else
                Exit Sub
            End If
        Else ' ----------------------------------------------  Save praparation
            If Form_Pulses Is Nothing Then
                MsgBox("Error - FormPulses is Nothing")
                Return
            End If
            If Form_Equalizers Is Nothing Then
                MsgBox("Error - Form_Equalizers is Nothing")
                Return
            End If
            '
            If iniFileName = "" Then
                iniFileName = PlatformAdjustedFileName(Application.StartupPath & "\" & AssemblyName() & "_INI.txt")
            End If
            iniFileName = PlatformAdjustedFileName(iniFileName)
            IVf = IO.File.CreateText(iniFileName)
        End If

        Try
            IV(" Special Params")
            IV("===========================================")
            IV("Language", Language)
            IV("MinimumGain", Form_Main.txt_AudioGain.MinValue)
            IV("HalfMaxEnergy", HalfMaxEnergy)
            IV("MAX_BIN_INDEX", MAX_BIN_INDEX)
            IV("DBG", DBG)
            IV("RUN", Form_Main.ToolStripButton_Run.Checked)

            IV("")
            IV(" Color, etc")
            IV("===========================================")
            IV("Back_Color", Form_Main.PBox_Spectrum.BackColor)

            IV("LineGraph_Color", Spectrometer.LineGraph_Color)
            IV("LineGraph_Width", Spectrometer.LineGraph_Width)
            IV("BarGraph_Color", Spectrometer.BarGraph_Color)
            IV("BarGraph_Width", Spectrometer.BarGraph_Width)
            IV("DotGraph_Color", Spectrometer.DotGraph_Color)
            IV("DotGraph_Width", Spectrometer.DotGraph_Width)
            IV("Ref1_Color", Spectrometer.mRef_Color(1))
            IV("Ref2_Color", Spectrometer.mRef_Color(2))
            IV("Ref3_Color", Spectrometer.mRef_Color(3))
            IV("BKG_Color", Spectrometer.mRef_Color(0))

            IV("Line_Color", Spectrometer.Line_Color)
            IV("Line2_Color", Spectrometer.Line2_Color)
            IV("Line_Width", Spectrometer.Marker_Width)
            IV("Number_Color", Spectrometer.Number_Color)
            IV("Number_Font", Spectrometer.Number_Font)
            IV("Number_Fontsize", Spectrometer.Number_Fontsize)

            IV("Identifier_Color", Spectrometer.Identifier_Color)
            IV("Identifier_Width", Spectrometer.Identifier_Width)
            IV("Marker_Color", Spectrometer.Marker_Color)
            IV("Marker_Width", Spectrometer.Marker_Width)
            IV("Marker_Font", Spectrometer.Marker_Font)
            IV("Marker_Fontsize", Spectrometer.Marker_Fontsize)

            IV("Selected_Color", Spectrometer.Selected_Color)
            IV("Selected_Width", Spectrometer.Selected_Width)
            IV("Extra_Division", Spectrometer.Extra_Division)

            IV("")
            IV(" Program Params")
            IV("===========================================")
            ' ------------------------------------------------------------------------------ FORM BOUNDS
            If Not IVmode Then
                Form1_StartWindowState = Form_Main.WindowState
                Form2_StartWindowState = Form_Pulses.WindowState
                Form2_StartVisible = Form_Pulses.Visible
                Form3_StartWindowState = Form_Equalizers.WindowState
                Form3_StartVisible = Form_Equalizers.Visible
                Form4_StartWindowState = Form_Tomy.WindowState
                Form4_StartVisible = Form_Tomy.Visible
            End If
            'Log(Form_Main.Top.ToString & ", " & Form_Main.Left.ToString)
            'MsgBox(Form_Main.Top.ToString & ", " & Form_Main.Left.ToString)
            'Log(Form_Main.Location.ToString)
            IV("Form1_Top", Form_Main.Top)
            IV("Form1_Left", Form_Main.Left)
            IV("Form1_Width", Form_Main.Width)
            IV("Form1_Height", Form_Main.Height)
            IV("Form1_WindowState", Form1_StartWindowState)
            '
            IV("Form2_Top", Form_Pulses.Top)
            IV("Form2_Left", Form_Pulses.Left)
            IV("Form2_Width", Form_Pulses.Width)
            IV("Form2_Height", Form_Pulses.Height)
            IV("Form2_WindowState", Form2_StartWindowState)
            IV("Form2_Visible", Form2_StartVisible)
            '
            IV("Form3_Top", Form_Equalizers.Top)
            IV("Form3_Left", Form_Equalizers.Left)
            IV("Form3_WindowState", Form3_StartWindowState)
            IV("Form3_Visible", Form3_StartVisible)
            '
            IV("Form4_Visible", Form4_StartVisible) ' Form_Tomy
            '
            IV("TabIndex", Form_Main.TabControl1.SelectedIndex)
            '
            IV("")
            IV(" AudioIn")
            IV("===========================================")
            IV("Bins", Form_Main.cmb_Bins.SelectedIndex)
            IV("Sampling", Form_Main.cmb_Sampling.SelectedIndex)
            IV("PulsePolarity", Form_Main.cmb_PulsePolarity.SelectedIndex)
            IV("NegPulses", WaveRec.NegPulses.ToString)
            IV("InputDevice", Form_Main.SelectedAudioIn)
            IV("AudioGain", Form_Main.txt_AudioGain.Text)
            IV("AudioZero", Form_Main.txt_AudioZero.Text)

            '
            IV("")
            IV(" BaseLine")
            IV("===========================================")
            IV("BaseLineEnable", Form_Main.chk_BltEnable.Checked)
            IV("BaseLinePosition", Form_Main.txt_BLT_Position.NumericValueInteger)
            IV("BaseLineSize", Form_Main.txt_BLT_Size.NumericValueInteger)
            IV("BaseLineMaxSlope", Form_Main.txt_BLT_MaxSlope.NumericValueInteger)
            IV("BaseLineMaxNoise", Form_Main.txt_BLT_MaxNoise.NumericValueInteger)
            IV("BaseLineSlopeCorrection", Form_Main.btn_BLT_MaxSlope.Checked)
            '
            IV("")
            IV(" Params")
            IV("===========================================")
            IV("IntegrationTime", Form_Main.txt_IntegrationTime.NumericValueInteger)
            IV("IntegrationTimeMin", Form_Main.txt_IntegrationTime.MinValue)
            IV("IntegrationMode", Form_Main.btn_IntegrationTime.Checked)
            IV("DrawSpeed", Form_Main.txt_DrawSpeed.NumericValueInteger)
            IV("MinEnergy", Form_Main.txt_MinEnergy.NumericValueInteger)
            IV("IIR_Filter", Form_Main.txt_IIR_Filter.NumericValueInteger)
            IV("UseIIR_Filter", Form_Main.btn_IIR_Filter.Checked)
            '
            IV("")
            IV(" Export options")
            IV("===========================================")
            IV("ExportWithHeader", Form_Main.chk_ExportWithHeader.Checked)
            IV("DecimalSeparator", Form_Main.txt_DecimalSeparator.Text)
            IV("FieldSeparator", Form_Main.txt_FieldSeparator.Text)
            '
            IV("")
            IV(" Output slots")
            IV("===========================================")
            IV("SlotCounter", Form_Main.txt_SlotCounter.Text)
            IV("BinsFirstSlot", Form_Main.txt_BinsFirstSlot.Text)
            IV("BinsNumSlots", Form_Main.txt_BinsNumSlots.Text)
            IV("OnlySelectedRows", Form_Main.chk_OnlySelectedRows.Checked)
            '
            IV("")
            IV(" Timers")
            IV("===========================================")
            IV("StopTimer", Form_Main.txt_StopTimer.Text)
            '
            IV("")
            IV(" Scale options")
            IV("===========================================")
            IV("XlogExponent", Form_Main.txt_XlogExponent.Text)
            IV("YlogExponent", Form_Main.txt_YlogExponent.Text)
            IV("ThickLines", Form_Main.chk_ThickLines.Checked)
            '
            IV("")
            IV(" Resolution compensation")
            IV("===========================================")
            IV("ResCompEnable", Form_Main.chk_ResCompEnable.Checked)
            IV("ResCompSize", Form_Main.txt_ResCompSize.NumericValueInteger)
            IV("ResCompCenter", Form_Main.txt_ResCompCenter.NumericValueInteger)
            IV("ResCompLeft", Form_Main.txt_ResCompLeft.NumericValueInteger)
            IV("ResCompRight", Form_Main.txt_ResCompRight.NumericValueInteger)
            '
            IV("")
            IV(" Gaussian deconvolution")
            IV("===========================================")
            IV("GaussianDecEnable", Form_Main.chk_GaussianDecEnable.Checked)
            IV("DeconvSize", Form_Main.txt_DeconvSize.NumericValueInteger)
            IV("GaussianSize", Form_Main.txt_GaussianSize.NumericValueInteger)
            '
            IV("")
            IV(" Graph")
            IV("===========================================")
            IV("cps_Enabled", Form_Main.btn_cps.Checked)
            IV("MaxY_Enabled", Form_Main.btn_MaxY.Checked)
            IV("MaxY", Form_Main.txt_MaxY.Text)
            IV("Xlog", Form_Main.btn_Xlog.Checked)
            IV("Ylog", Form_Main.btn_Ylog.Checked)
            IV("Zoom", Form_Main.tk_Zoom.Value)
            IV("LinMaster", Form_Main.tk_LinMaster.Value)
            IV("EqMaster", Form_Main.tk_EqMaster.Value)
            '
            IV("")
            IV(" Form1 - User Text")
            IV("===========================================")
            IV("UserText", Form_Main.txt_UserText.Text, True) ' --- Multiline
            '
            IV("")
            IV(" Form2 - ShapeVisualizer")
            IV("===========================================")
            IV("ScopeMaxEnergy", Form_Pulses.txt_MaxEnergy.Text)
            IV("ScopeMinEnergy", Form_Pulses.txt_MinEnergy.Text)
            IV("ScopeSizeX", Form_Pulses.tk_SizeX.Value)
            IV("ScopeSizeY", Form_Pulses.tk_SizeY.Value)
            IV("ScopePosY", Form_Pulses.tk_PosY.Value)
            IV("ScopeRun", Form_Pulses.btn_Run.Checked)
            IV("ScopeNormalize", Form_Pulses.btn_Normalized.Checked)
            '
            IV("")
            IV(" Form3 - Equalizers")
            IV("===========================================")
            IV("LinOn", Form_Equalizers.chk_LinOn.Checked)
            IV("EqOn", Form_Equalizers.chk_EqOn.Checked)
            '
            IV("")
            IV(" Tomy")
            IV("===========================================")
            IV("FormTomy_Top", Form_Tomy.Top)
            IV("FormTomy_Left", Form_Tomy.Left)
            IV("FormTomy_Width", Form_Tomy.Width)
            IV("FormTomy_Height", Form_Tomy.Height)
            '
            IV("")
            IV("Autosave")
            IV("===========================================")
            IV("AutoSave_Enabled", Form_Main.btn_AutoSave.Checked)
            IV("AutoSave", Form_Main.txt_AutoSave.Text)
            IV("AutoSave_StartNew", AutoSave_StartNew)
            IV("AutoSave_Folder", AutoSave_Folder)
            IV("AutoSave_Format", AutoSave_Format)
            IV("AutoSave_Execute", AutoSave_Execute)
            IV("AutoSave_ExecuteEnabled", AutoSave_ExecuteEnabled)
            IV("AutoSaveSecondsMinimum", AutoSaveSecondsMinimum)
            If Not IVmode Then
                Dim ic As Integer
                For ic = 0 To chk_List.Length() - 1
                    If CStr(chk_List(ic, 0)) = "" Then
                        Exit For
                    End If
                    IVf.WriteLine(TabString("AutoSave_List_" & _
                        CStr(chk_List(ic, 0)).Replace(" ", "_"), _
                                           CBool(chk_ListBUF(ic, 2))))
                Next
            End If

            IV("")
            IV("Browse Spectrum")
            IV("===========================================")
            IV("BS_Folder", Form_BSpectrum.BS_Folder)
            IV("BS_File", Form_BSpectrum.txt_BS_Filename.Text)
            IV("BS_RawData", Form_BSpectrum.BS_RawData)
            IV("BS_Repeat", Form_BSpectrum.BS_Repeat)
            IV("BS_Speed", Form_BSpectrum.tk_BS_Speed.Value)
            IV("BS_Options", Form_BSpectrum.btn_BS_MoreOptions.Checked)
            IV("BS_LocationX", Form_BSpectrum.BS_LocationX)
            IV("BS_LocationY", Form_BSpectrum.BS_LocationY)
            IV("BS_OffsetMax", Form_BSpectrum.BS_OffsetMax)
            IV("BS_Output", Form_BSpectrum.BS_Output)

            SaveLoadLinearizer()
            SaveLoadEqualizer()

            If IVmode Then ' --------------------------- Load finalize
                Dim param As String
                Dim l As String
                Dim ic As Integer
                Dim s(1) As String
                Dim it As ListViewItem
                For i As Integer = 0 To IVLK.Count - 1 ' Load AutoSave list and Isotope marker list
                    param = IVLK(i)
                    l = IVLV(i)
                    If param.StartsWith("AutoSave_List_") Then
                        For ic = 0 To chk_List.Length() - 1
                            If CStr(chk_List(ic, 0)) = "" Then Exit For
                            If CStr(chk_List(ic, 0)) = param.Substring(14).Replace("_", " ") Then
                                chk_ListBUF(ic, 2) = l = "True"
                            End If
                        Next
                    ElseIf param.StartsWith("Isotope_") Then
                        s = param.Substring(8).Split(CChar("_"))
                        For Each it In Form_Main.MyListView1.Items
                            If it.Text = s(0) And it.SubItems(1).Text = s(1) Then
                                it.Checked = l = "True"
                                Exit For
                            End If
                            If it.Text & it.SubItems(1).Text = "" Then
                                it.Text = s(0)
                                it.SubItems(1).Text = s(1).Replace(",", ".").Trim
                                it.Checked = l = "True"
                                Exit For
                            End If
                        Next
                    End If

                Next
                If MAX_BIN_INDEX <> mbi Then ' Larger MAX_BIN_INDEX specified
                    Spectrometer.LastDataBin = Spectrometer.LastAudioCardBin
                    If Spectrometer.LastDataBin > MAX_BIN_INDEX Or Spectrometer.LastDataBin <= 0 Then Spectrometer.LastDataBin = MAX_BIN_INDEX
                    ReDim Spectrometer.EnergyLinArray(MAX_BIN_INDEX + 1)
                    ReDim Spectrometer.HeightLinArray(MAX_BIN_INDEX + 1)
                    ReDim Spectrometer.mValues(MAX_BIN_INDEX)
                    ReDim Spectrometer.mReferences(6, MAX_BIN_INDEX)
                    ReDim Spectrometer.CompOldValues(MAX_BIN_INDEX + 120)
                    ReDim WaveRec.Bins(MAX_BIN_INDEX)
                    Spectrometer.mMaxEnergy = CInt(Spectrometer.XtoEnergy(Spectrometer.mPBoxW))
                    Spectrometer.mFirstBinIndex = Spectrometer.EnergyToBin(Spectrometer.mMinEnergy)
                    Spectrometer.mMaxBinValue = 10

                End If

                IVLK.Clear()
                IVLV.Clear()

                If Form_Main.WindowState = FormWindowState.Minimized Then Form_Main.WindowState = FormWindowState.Normal
                LimitFormPosition(Form_Main)
                LimitFormPosition(Form_Pulses)
                LimitFormPosition(Form_Equalizers)
                LimitFormPosition(Form_Tomy)
                Spectrometer.Fill_IsotopeList_and_SelectedIsotopesArray()

            Else             ' --------------------------- Save Finalize
                IV("")
                IV(" Isotopes")
                IV("===========================================")
                Dim it As ListViewItem
                Dim ss As String = ""
                For Each it In Form_Main.MyListView1.Items
                    If it.Text = "" And it.SubItems(1).Text = "" Then Exit For
                    IVf.WriteLine(TabString("Isotope_" & it.Text & "_" & it.SubItems(1).Text, _
                                           CBool(it.Checked)))
                Next
                IVf.Close()
            End If
        Catch
        End Try
    End Sub

 
    ' ==================================================================================================
    '  SAVE LOAD -- LINEARIZER and EQUALIZER
    ' ==================================================================================================
    Friend Sub SaveLinearizerAs()
        Dim sfd As SaveFileDialog = New SaveFileDialog()
        sfd.DefaultExt = ".txt"
        sfd.AddExtension = True
        sfd.Filter = "Configuration file (*.txt)|*txt"
        sfd.FileName = "MCA_LINEARIZER_INI" & Date.Now.ToString("yyyy_MM_dd_HH_mm_ss")
        If sfd.ShowDialog() = Windows.Forms.DialogResult.OK Then
            If sfd.FileName = "" Then
                sfd.FileName = PlatformAdjustedFileName(Application.StartupPath & "\" & AssemblyName() & "_LIN_INI.txt")
            End If
            sfd.FileName = PlatformAdjustedFileName(sfd.FileName)
            Dim f As System.IO.StreamWriter
            f = IO.File.CreateText(sfd.FileName)
            IVf = f : IVmode = False : SaveLoadLinearizer()
            f.Close()
        End If
    End Sub

    Friend Sub LoadLinearizer()
        Dim ofd As OpenFileDialog = New OpenFileDialog
        ofd.Filter = "Configuration file (*.txt)|*txt"
        If ofd.ShowDialog() = Windows.Forms.DialogResult.OK Then
            If ofd.FileName = "" Then
                ofd.FileName = Application.StartupPath & "\" & AssemblyName() & "_LIN_INI.txt"
            End If
            ofd.FileName = PlatformAdjustedFileName(ofd.FileName)
            '
            Dim l As String
            If My.Computer.FileSystem.FileExists(ofd.FileName) Then
                Dim f As System.IO.StreamReader
                f = IO.File.OpenText(ofd.FileName)
                Dim s As String
                Do While Not f.EndOfStream
                    l = f.ReadLine()
                    If InStr(l, "=") > 0 Then
                        s = ExtractParamName(l)
                        IVLK.Add(s)
                        IVLV.Add(l)
                    End If
                Loop
                f.Close()
                IVmode = True : SaveLoadLinearizer()
            End If
        End If
    End Sub

    Friend Sub SaveEqualizerAs()
        Dim sfd As SaveFileDialog = New SaveFileDialog()
        sfd.DefaultExt = ".txt"
        sfd.AddExtension = True
        sfd.Filter = "Configuration file (*.txt)|*txt"
        sfd.FileName = "MCA_EQUALIZER_INI_" & Date.Now.ToString("yyyy_MM_dd_HH_mm_ss")
        If sfd.ShowDialog() = Windows.Forms.DialogResult.OK Then
            If sfd.FileName = "" Then
                sfd.FileName = PlatformAdjustedFileName(Application.StartupPath & "\" & AssemblyName() & "_EQ_INI.txt")
            End If
            sfd.FileName = PlatformAdjustedFileName(sfd.FileName)
            Dim f As System.IO.StreamWriter
            f = IO.File.CreateText(sfd.FileName)
            IVf = f : IVmode = False : SaveLoadEqualizer()
            f.Close()
        End If
    End Sub
    Friend Sub LoadEqualizer()
        Dim ofd As OpenFileDialog = New OpenFileDialog
        ofd.Filter = "Configuration file (*.txt)|*txt"
        If ofd.ShowDialog() = Windows.Forms.DialogResult.OK Then
            If ofd.FileName = "" Then
                ofd.FileName = Application.StartupPath & "\" & AssemblyName() & "_EQ_INI.txt"
            End If
            ofd.FileName = PlatformAdjustedFileName(ofd.FileName)
            '
            Dim l As String
            If My.Computer.FileSystem.FileExists(ofd.FileName) Then
                Dim f As System.IO.StreamReader
                f = IO.File.OpenText(ofd.FileName)
                Dim s As String
                Do While Not f.EndOfStream
                    l = f.ReadLine()
                    If InStr(l, "=") > 0 Then
                        s = ExtractParamName(l)
                        IVLK.Add(s)
                        IVLV.Add(l)
                    End If
                Loop
                f.Close()
                IVmode = True : SaveLoadEqualizer()
            End If
        End If
    End Sub

    Friend Sub SaveLoadLinearizer()
        IV("")
        IV(" Energy Linearizer")
        IV("===========================================")
        IV("Lin1", Form_Equalizers.tk_Lin1.Value)
        IV("Lin2", Form_Equalizers.tk_Lin2.Value)
        IV("Lin3", Form_Equalizers.tk_Lin3.Value)
        IV("Lin4", Form_Equalizers.tk_Lin4.Value)
        IV("Lin5", Form_Equalizers.tk_Lin5.Value)
        IV("Lin6", Form_Equalizers.tk_Lin6.Value)
        IV("Lin7", Form_Equalizers.tk_Lin7.Value)
        IV("Lin8", Form_Equalizers.tk_Lin8.Value)
        IV("LinEnergy1", Form_Equalizers.txt_Lin1.NumericValueInteger)
        IV("LinEnergy2", Form_Equalizers.txt_Lin2.NumericValueInteger)
        IV("LinEnergy3", Form_Equalizers.txt_Lin3.NumericValueInteger)
        IV("LinEnergy4", Form_Equalizers.txt_Lin4.NumericValueInteger)
        IV("LinEnergy5", Form_Equalizers.txt_Lin5.NumericValueInteger)
        IV("LinEnergy6", Form_Equalizers.txt_Lin6.NumericValueInteger)
        IV("LinEnergy7", Form_Equalizers.txt_Lin7.NumericValueInteger)
        IV("LinEnergy8", Form_Equalizers.txt_Lin8.NumericValueInteger)
        IV("LinMax", Form_Equalizers.txt_LinMax.NumericValueInteger)
        IV("LinInterp", Form_Equalizers.txt_LinInterp.NumericValueInteger)
    End Sub

    Friend Sub SaveLoadEqualizer()
        IV("")
        IV(" Height Equalizer")
        IV("===========================================")
        IV("Eq1", Form_Equalizers.tk_Eq1.Value)
        IV("Eq2", Form_Equalizers.tk_Eq2.Value)
        IV("Eq3", Form_Equalizers.tk_Eq3.Value)
        IV("Eq4", Form_Equalizers.tk_Eq4.Value)
        IV("Eq5", Form_Equalizers.tk_Eq5.Value)
        IV("Eq6", Form_Equalizers.tk_Eq6.Value)
        IV("Eq7", Form_Equalizers.tk_Eq7.Value)
        IV("Eq8", Form_Equalizers.tk_Eq8.Value)
        IV("EqEnergy1", Form_Equalizers.txt_Eq1.NumericValueInteger)
        IV("EqEnergy2", Form_Equalizers.txt_Eq2.NumericValueInteger)
        IV("EqEnergy3", Form_Equalizers.txt_Eq3.NumericValueInteger)
        IV("EqEnergy4", Form_Equalizers.txt_Eq4.NumericValueInteger)
        IV("EqEnergy5", Form_Equalizers.txt_Eq5.NumericValueInteger)
        IV("EqEnergy6", Form_Equalizers.txt_Eq6.NumericValueInteger)
        IV("EqEnergy7", Form_Equalizers.txt_Eq7.NumericValueInteger)
        IV("EqEnergy8", Form_Equalizers.txt_Eq8.NumericValueInteger)
        IV("EqMax", Form_Equalizers.txt_EqMax.NumericValueInteger)
        IV("EqInterp", Form_Equalizers.txt_EqInterp.NumericValueInteger)
    End Sub


    ' ==================================================================================================
    '  SAVE IMAGE
    ' ==================================================================================================
    Public Sub SaveImage(ByVal img As Image, _
                         ByVal filename As String, _
                         ByVal extension As String, _
                         ByVal Quality As Int32)

        extension = LCase(extension)
        filename = RemoveImageExtensions(filename)
        filename += "." & extension
        '
        If img Is Nothing Then Return
        Try
            File_Kill(filename)
            If extension = "jpg" Then
                Dim ImageEncoders() As ImageCodecInfo = ImageCodecInfo.GetImageEncoders()
                Dim myEncoder As System.Drawing.Imaging.Encoder = System.Drawing.Imaging.Encoder.Quality
                Dim myEncoderParameters As New EncoderParameters(1)
                Dim myEncoderParameter As New EncoderParameter(myEncoder, Quality)
                myEncoderParameters.Param(0) = myEncoderParameter
                img.Save(filename, ImageEncoders(1), myEncoderParameters)
            Else
                img.Save(filename, ImageFormatFromFileExtension(extension))
            End If
        Catch
            MsgBox("Image save error", MsgBoxStyle.Exclamation)
        End Try
    End Sub

    Private Function ImageFormatFromFileExtension(ByVal extension As String) As ImageFormat
        Select Case LCase(extension)
            Case "jpg" : Return ImageFormat.Jpeg
            Case "png" : Return ImageFormat.Png
            Case "tiff" : Return ImageFormat.Tiff
            Case "exif" : Return ImageFormat.Exif
            Case "emf" : Return ImageFormat.Emf
            Case "wmf" : Return ImageFormat.Wmf
            Case "gif" : Return ImageFormat.Gif
            Case "bmp" : Return ImageFormat.Bmp
                'Case "ico" : Return ImageFormat.Icon
            Case Else : Return ImageFormat.Jpeg
        End Select
    End Function

    Private Function RemoveImageExtensions(ByVal fname As String) As String
        Dim ext As String = IO.Path.GetExtension(fname)
        Select Case LCase(ext)
            Case ".jpg", ".png", ".tiff", ".exif", ".emf", ".wmf", ".gif", ".bmp"
                fname = Left(fname, fname.Length - ext.Length)
        End Select
        Return fname
    End Function

    Friend Sub File_Kill(ByVal filename As String)
        If My.Computer.FileSystem.FileExists(filename) Then
            My.Computer.FileSystem.DeleteFile(filename, FileIO.UIOption.OnlyErrorDialogs, FileIO.RecycleOption.DeletePermanently)
        End If
    End Sub

    Friend Sub SaveImage(ByVal Prefix As String, ByVal cnt As Control)
        Dim img As Image = GetImage(cnt)
        Dim sfd As SaveFileDialog = New SaveFileDialog()
        sfd.Filter = "Portable network graphics (*.png)|*png|JPEG image (*.jpg)|*.jpg"
        sfd.FileName = Prefix & Date.Now.ToString("yyyy_MM_dd_HH_mm_ss")
        If sfd.ShowDialog() = Windows.Forms.DialogResult.OK Then
            SaveImage(img, sfd.FileName, If(sfd.FilterIndex = 2, "jpg", "png"), 100)
        End If
    End Sub
    Friend Function GetImage(ByVal cnt As Control) As Bitmap
        Dim s As Size = cnt.Size
        Dim bmp As Bitmap = New Bitmap(s.Width, s.Height)
        cnt.DrawToBitmap(bmp, New Rectangle(0, 0, s.Width, s.Height))
        Return bmp
    End Function

    Friend Sub SaveHistogramFile(ByVal ExportWithHeader As Boolean, _
                                 ByVal DecimalSeparator As String, _
                                 ByVal FieldSeparator As String, _
                                 Optional ByVal nref As Integer = -1)
        '
        Dim s As String = Spectrometer.GetBinDataString(ExportWithHeader, DecimalSeparator, FieldSeparator, nref)
        Dim sfd As SaveFileDialog = New SaveFileDialog()
        sfd.DefaultExt = ".txt"
        sfd.AddExtension = True
        sfd.Filter = "CSV text file (*.txt)|*.txt|All file (*.*)|*.*"
        sfd.FileName = "HISTOGRAM_" & Date.Now.ToString("yyyy_MM_dd_HH_mm_ss")
        If sfd.ShowDialog() = Windows.Forms.DialogResult.OK Then
            Dim writer As System.IO.StreamWriter
            writer = New System.IO.StreamWriter(sfd.FileName)
            writer.Write(s)
            writer.Close()
        End If
    End Sub

    ' ==================================================================================================
    '  AUTO SAVE IMAGE      ------------- nkom beta ---------------
    ' ==================================================================================================
    Friend Sub AutoSaveHistogramFile(ByVal FileName As String, Optional ByVal nref As Integer = -1)
        'to save histogram file without dialogue
        Dim s As String = Spectrometer.GetBinDataString(Form_Main.chk_ExportWithHeader.Checked, _
                                            Form_Main.txt_DecimalSeparator.Text, Form_Main.txt_FieldSeparator.Text, nref)
        Dim writer As System.IO.StreamWriter
        writer = New System.IO.StreamWriter(FileName)
        writer.Write(s)
        writer.Close()
        'End If
    End Sub

    Friend Sub AutoSaveImageApplication(ByVal FileName As String)
        Dim img As Image = GetImage(Form_Main)
        SaveImage(img, FileName, If(FileName.EndsWith(".png"), "png", "jpg"), 100)
    End Sub

    Friend Sub AutoSaveImageSpectrum(ByVal FileName As String)
        Dim img As Image = GetImage(Form_Main.GroupBox_SpectrumData)
        SaveImage(img, FileName, If(FileName.EndsWith(".png"), "png", "jpg"), 100)
    End Sub

    Friend Sub AutoSaveSpefile(ByVal FileName As String, Optional ByVal nref As Int32 = -1)
        ' SPE format (MCA166, MCA527 by GBS ELEKTRONIK) Used by PM1703MO-1A/B, PM1406
        Dim s As String = ""
        s += "$MCA_166_ID:" & vbCrLf
        s += "Theremino_MCA-nkom-beta" & vbCrLf
        s += "$DATE_MEA:" & vbCrLf
        s += StartTime.ToString("yyyy/MM/dd HH':'mm':'ss") & vbCrLf
        s += "$MEAS_TIM:" & vbCrLf
        s += TotalSeconds.ToString & " " & TotalSeconds.ToString & vbCrLf
        s += "$COUNT_RATE:" & vbCrLf
        s += (ValidPulses / CSng(TotalSeconds)).ToString("0.0") & vbCrLf
        s += "$TEMPER" & vbCrLf
        s += "24" & vbCrLf  ' Bogus temp ...
        s += "$DATA:" & vbCrLf

        If nref < 0 Then
            s += "0 " & CStr(Spectrometer.LastDataBin) & vbCrLf
            For i As Int32 = 0 To Spectrometer.LastDataBin '  mFirstBinIndex To mLastBinIndex
                s += WaveRec.Bins(i).ToString & vbCrLf
            Next
        Else
            s += "0 " & CStr(Spectrometer.mRefLastDataBin(nref)) & vbCrLf
            For i As Int32 = 0 To Spectrometer.mRefLastDataBin(nref) '  mFirstBinIndex To mLastBinIndex
                s += Spectrometer.mReferences(nref, i).ToString & vbCrLf
            Next
        End If

        Dim bin2614 As Integer = Spectrometer.EnergyToBin(2614)
        s += "$ENER_FIT:" & vbCrLf
        s += "0 " & CStr(2614 / bin2614) & vbCrLf
        s += "$ENER_DATA:" & vbCrLf
        s += "2" & vbCrLf   ' 2 points calibration
        s += "2614 " & bin2614 & vbCrLf
        s += "1 " & Spectrometer.BinToEnergy(1) & vbCrLf

        Dim writer As System.IO.StreamWriter
        writer = New System.IO.StreamWriter(FileName)
        writer.Write(s)
        writer.Close()
    End Sub

    Friend Function LoadHistogramFile(ByVal destination As Int32, Optional ByVal fn As String = "", _
               Optional ByVal q As Boolean = False, Optional ByVal rawdata As Boolean = False) As Boolean
        ' destination: 0 = background, 1,2,3 = Ref1,2,3,  -1 = Current data (WaveRec.Bins)
        ' Show dialog if fn (Filename) isn't provided or if it's ""
        If destination < 0 Then
            WaveRec.Enabled = False
            Form_Main.ToolStripButton_Run.Checked = False
        End If

        If fn = "" Or Not FileExists(fn) Then
            Dim ofd As OpenFileDialog = New OpenFileDialog
            If Form_BSpectrum.BS_Folder <> "" Then ofd.InitialDirectory = Form_BSpectrum.BS_Folder
            If fn = "" Then
                ofd.Filter = "Histogram file (*.txt)|*txt|Spectrum file (*.spe)|*.spe"
            Else
                Dim ext As String = Path.GetExtension(fn)
                ofd.Filter = "Spectrum file (*" & ext & ")|*" & ext & "|All file (*.*)|*.*"
            End If
            If ofd.ShowDialog() = Windows.Forms.DialogResult.OK Then
                fn = ofd.FileName
                Form_BSpectrum.BS_Folder = Path.GetDirectoryName(fn)
                Form_BSpectrum.txt_BS_Filename.Text = fn
                q = False
            Else
                Return False
            End If
        End If
        Dim StringArray() As String
        StringArray = IO.File.ReadAllLines(fn)

        Return Spectrometer.FillBinsFromStringArray(destination, StringArray, q, rawdata, fn)
    End Function


End Module
